/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver.requests;

import com.google.common.base.Charsets;
import config.WurstProjectConfigData;
import de.peeeq.wurstio.Pjass;
import de.peeeq.wurstio.TimeTaker;
import de.peeeq.wurstio.UtilsIO;
import de.peeeq.wurstio.WurstCompilerJassImpl;
import de.peeeq.wurstio.languageserver.ModelManager;
import de.peeeq.wurstio.languageserver.ProjectConfigBuilder;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.WurstLanguageServer;
import de.peeeq.wurstio.languageserver.requests.RequestFailedException;
import de.peeeq.wurstio.languageserver.requests.RunMap;
import de.peeeq.wurstio.languageserver.requests.UserRequest;
import de.peeeq.wurstio.mpq.MpqEditor;
import de.peeeq.wurstio.mpq.MpqEditorFactory;
import de.peeeq.wurstio.utils.W3InstallationData;
import de.peeeq.wurstscript.RunArgs;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.jassAst.JassProg;
import de.peeeq.wurstscript.jassprinter.JassPrinter;
import de.peeeq.wurstscript.luaAst.LuaCompilationUnit;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.utils.LineOffsets;
import de.peeeq.wurstscript.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.NonWritableChannelException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.moonlightflower.wc3libs.bin.app.W3I;
import net.moonlightflower.wc3libs.port.Orient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;
import org.jetbrains.annotations.Nullable;

public abstract class MapRequest
extends UserRequest<Object> {
    protected final WurstLanguageServer langServer;
    protected final Optional<File> map;
    protected final List<String> compileArgs;
    protected final WFile workspaceRoot;
    protected final RunArgs runArgs;
    protected final Optional<String> wc3Path;
    protected final W3InstallationData w3data;
    protected final TimeTaker timeTaker;
    public static long mapLastModified = 0L;
    public static String mapPath = "";
    private static Long lastMapModified = 0L;
    private static String lastMapPath = "";
    protected SafetyLevel safeCompilation = SafetyLevel.KindOfSafe;

    public TimeTaker getTimeTaker() {
        return this.timeTaker;
    }

    public MapRequest(WurstLanguageServer langServer, Optional<File> map, List<String> compileArgs, WFile workspaceRoot, Optional<String> wc3Path) {
        this.langServer = langServer;
        this.map = map;
        this.compileArgs = compileArgs;
        this.workspaceRoot = workspaceRoot;
        this.runArgs = new RunArgs(compileArgs);
        this.wc3Path = wc3Path;
        this.w3data = this.getBestW3InstallationData();
        this.timeTaker = this.runArgs.isMeasureTimes() ? new TimeTaker.Recording() : new TimeTaker.Default();
    }

    @Override
    public void handleException(LanguageClient languageClient, Throwable err, CompletableFuture<Object> resFut) {
        if (err instanceof RequestFailedException) {
            RequestFailedException rfe = (RequestFailedException)err;
            languageClient.showMessage(new MessageParams(rfe.getMessageType(), rfe.getMessage()));
            resFut.complete(new Object());
        } else {
            super.handleException(languageClient, err, resFut);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File compileMap(File projectFolder, WurstGui gui, Optional<File> mapCopy, RunArgs runArgs, WurstModel model, WurstProjectConfigData projectConfigData, boolean isProd) {
        try (@Nullable MpqEditor mpqEditor = MpqEditorFactory.getEditor(mapCopy);){
            File file;
            if (mpqEditor != null && !mpqEditor.canWrite()) {
                WLogger.severe("The supplied map is invalid/corrupted/protected and Wurst cannot write to it.\nPlease supply a valid .w3x input map that can be opened in the world editor.");
                throw new NonWritableChannelException();
            }
            WurstCompilerJassImpl compiler = new WurstCompilerJassImpl(this.timeTaker, projectFolder, gui, mpqEditor, runArgs);
            compiler.setMapFile(mapCopy);
            this.purgeUnimportedFiles(model);
            gui.sendProgress("Check program");
            compiler.checkProg(model);
            if (gui.getErrorCount() > 0) {
                throw new RequestFailedException(MessageType.Warning, "Could not compile project: ", gui.getErrorList().get(0));
            }
            this.print("translating program ... ");
            compiler.translateProgToIm(model);
            if (gui.getErrorCount() > 0) {
                throw new RequestFailedException(MessageType.Error, "Could not compile project (error in translation): " + gui.getErrorList().get(0));
            }
            this.timeTaker.measure("Runinng Compiletime Functions", () -> compiler.runCompiletime(projectConfigData, isProd, runArgs.isCompiletimeCache()));
            if (runArgs.isLua()) {
                this.print("Translating program to Lua ... ");
                Optional<LuaCompilationUnit> luaCode = Optional.ofNullable(compiler.transformProgToLua());
                if (!luaCode.isPresent()) {
                    this.print("Could not compile project\n");
                    throw new RuntimeException("Could not compile project (error in LUA translation)");
                }
                StringBuilder sb = new StringBuilder();
                luaCode.get().print(sb, 0);
                String compiledMapScript = sb.toString();
                File buildDir = this.getBuildDir();
                File outFile = new File(buildDir, "compiled.lua");
                com.google.common.io.Files.write((byte[])compiledMapScript.getBytes(Charsets.UTF_8), (File)outFile);
                File file2 = outFile;
                return file2;
            }
            this.print("Translating program to jass ... ");
            compiler.transformProgToJass();
            Optional<JassProg> jassProg = Optional.ofNullable(compiler.getProg());
            if (!jassProg.isPresent()) {
                this.print("Could not compile project\n");
                throw new RuntimeException("Could not compile project (error in JASS translation)");
            }
            gui.sendProgress("Printing program");
            JassPrinter printer = new JassPrinter(!runArgs.isOptimize(), jassProg.get());
            String compiledMapScript = printer.printProg();
            File buildDir = this.getBuildDir();
            File outFile = new File(buildDir, "compiled.j.txt");
            com.google.common.io.Files.write((byte[])compiledMapScript.getBytes(Charsets.UTF_8), (File)outFile);
            if (!runArgs.isDisablePjass()) {
                gui.sendProgress("Running PJass");
                Pjass.Result pJassResult = Pjass.runPjass(outFile, new File(buildDir, "common.j").getAbsolutePath(), new File(buildDir, "blizzard.j").getAbsolutePath());
                WLogger.info(pJassResult.getMessage());
                if (!pJassResult.isOk()) {
                    Iterator<CompileError> iterator = pJassResult.getErrors().iterator();
                    while (iterator.hasNext()) {
                        CompileError err = iterator.next();
                        gui.sendError(err);
                    }
                    throw new RuntimeException("Could not compile project (PJass error)");
                }
            }
            if (runArgs.isHotStartmap()) {
                gui.sendProgress("Running JHCR");
                file = this.runJassHotCodeReload(outFile);
                return file;
            }
            file = outFile;
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File runJassHotCodeReload(File mapScript) throws IOException, InterruptedException {
        File buildDir = this.getBuildDir();
        File commonJ = new File(buildDir, "common.j");
        File blizzardJ = new File(buildDir, "blizzard.j");
        if (!commonJ.exists()) {
            throw new IOException("Could not find file " + commonJ.getAbsolutePath());
        }
        if (!blizzardJ.exists()) {
            throw new IOException("Could not find file " + blizzardJ.getAbsolutePath());
        }
        ProcessBuilder pb = new ProcessBuilder(this.langServer.getConfigProvider().getJhcrExe(), "init", commonJ.getName(), blizzardJ.getName(), mapScript.getName());
        pb.directory(buildDir);
        Utils.exec(pb, Duration.ofSeconds(30L), System.err::println);
        return new File(buildDir, "jhcr_war3map.j");
    }

    private void purgeUnimportedFiles(WurstModel model) {
        Set<CompilationUnit> imported = model.stream().filter(cu -> this.isInWurstFolder(cu.getCuInfo().getFile()) || cu.getCuInfo().getFile().endsWith(".j")).collect(Collectors.toSet());
        this.addImports(imported, imported);
        model.removeIf(cu -> !imported.contains(cu));
    }

    private boolean isInWurstFolder(String file) {
        Path w;
        Path p = Paths.get(file, new String[0]);
        try {
            w = this.workspaceRoot.getPath();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        return p.startsWith(w) && Files.exists(p, new LinkOption[0]) && Utils.isWurstFile(file);
    }

    protected File getBuildDir() {
        File buildDir;
        try {
            buildDir = new File(this.workspaceRoot.getFile(), "_build");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot get build dir", e);
        }
        if (!buildDir.exists()) {
            UtilsIO.mkdirs(buildDir);
        }
        return buildDir;
    }

    private void addImports(Set<CompilationUnit> result, Set<CompilationUnit> toAdd) {
        Set<CompilationUnit> imported = toAdd.stream().flatMap(cu -> cu.getPackages().stream()).flatMap(p -> p.getImports().stream()).map(WImport::attrImportedPackage).filter(Objects::nonNull).map(WPackage::attrCompilationUnit).collect(Collectors.toSet());
        boolean changed = result.addAll(imported);
        if (changed) {
            this.addImports(result, imported);
        }
    }

    protected void print(String s) {
        WLogger.info(s);
    }

    protected void println(String s) {
        WLogger.info(s);
    }

    protected File compileScript(WurstGui gui, ModelManager modelManager, List<String> compileArgs, Optional<File> mapCopy, WurstProjectConfigData projectConfigData, boolean isProd, File scriptFile) throws Exception {
        RunArgs runArgs = new RunArgs(compileArgs);
        gui.sendProgress("Compiling Script");
        this.print("Compile Script : ");
        for (File dep : modelManager.getDependencyWurstFiles()) {
            WLogger.info("dep: " + dep.getPath());
        }
        this.print("Dependencies done.");
        if (this.safeCompilation != SafetyLevel.QuickAndDirty) {
            gui.sendProgress("Cleaning project");
            modelManager.clean();
            gui.sendProgress("Building project");
            modelManager.buildProject();
        }
        MapRequest.replaceBaseScriptWithConfig(modelManager, scriptFile);
        if (modelManager.hasErrors()) {
            for (CompileError compileError : modelManager.getParseErrors()) {
                gui.sendError(compileError);
            }
            throw new RequestFailedException(MessageType.Warning, "Cannot run code with syntax errors.");
        }
        WurstModel model = modelManager.getModel();
        if (this.safeCompilation != SafetyLevel.QuickAndDirty) {
            model = ModelManager.copy(model);
        }
        return this.compileMap(modelManager.getProjectPath(), gui, mapCopy, runArgs, model, projectConfigData, isProd);
    }

    private static void replaceBaseScriptWithConfig(ModelManager modelManager, File scriptFile) throws IOException {
        Optional<CompilationUnit> war3mapJ = modelManager.getModel().stream().filter(cu -> cu.getCuInfo().getFile().endsWith("war3map.j")).findFirst();
        if (war3mapJ.isPresent()) {
            modelManager.syncCompilationUnitContent(WFile.create(war3mapJ.get().getCuInfo().getFile()), Files.readString(scriptFile.toPath()));
        }
    }

    protected CompilationResult compileScript(ModelManager modelManager, WurstGui gui, Optional<File> testMap, WurstProjectConfigData projectConfigData, File buildDir, boolean isProd) throws Exception {
        CompilationResult result;
        boolean deleteOk;
        if (testMap.isPresent() && testMap.get().exists() && !(deleteOk = testMap.get().delete())) {
            throw new RequestFailedException(MessageType.Error, "Could not delete old mapfile: " + testMap);
        }
        if (this.map.isPresent() && testMap.isPresent()) {
            com.google.common.io.Files.copy((File)this.map.get(), (File)testMap.get());
        }
        if (this.runArgs.isHotReload()) {
            result = new CompilationResult();
            result.script = new File(buildDir, "war3mapj_with_config.j.txt");
            if (!result.script.exists()) {
                result.script = new File(new File(this.workspaceRoot.getFile(), "wurst"), "war3map.j");
            }
            if (!result.script.exists()) {
                throw new RequestFailedException(MessageType.Error, "Could not find war3map.j file");
            }
        } else {
            this.timeTaker.beginPhase("load map script");
            File scriptFile = this.loadMapScript(testMap, modelManager, gui);
            this.timeTaker.endPhase();
            result = this.applyProjectConfig(gui, testMap, buildDir, projectConfigData, scriptFile);
        }
        result.script = this.compileScript(gui, modelManager, this.compileArgs, testMap, projectConfigData, isProd, result.script);
        Optional<WurstModel> model = Optional.ofNullable(modelManager.getModel());
        if (!model.isPresent() || model.get().stream().noneMatch(cu -> cu.getCuInfo().getFile().endsWith("war3map.j"))) {
            this.println("No 'war3map.j' file could be found inside the map nor inside the wurst folder");
            this.println("If you compile the map with WurstPack once, this file should be in your wurst-folder. ");
            this.println("We will try to start the map now, but it will probably fail. ");
        }
        return result;
    }

    private File loadMapScript(Optional<File> mapCopy, ModelManager modelManager, WurstGui gui) throws Exception {
        File scriptFile = new File(new File(this.workspaceRoot.getFile(), "wurst"), "war3map.j");
        if (!mapCopy.isPresent() || this.runArgs.isNoExtractMapScript()) {
            if (scriptFile.exists()) {
                modelManager.syncCompilationUnit(WFile.create(scriptFile));
                return scriptFile;
            }
            throw new CompileError(new WPos("", new LineOffsets(), 0, 0), "RunArg noExtractMapScript is set but no mapscript is provided inside the wurst folder");
        }
        if (mapLastModified > lastMapModified || !mapPath.equals(lastMapPath)) {
            CompileError err;
            String msg;
            lastMapModified = mapLastModified;
            lastMapPath = mapPath;
            System.out.println("Map not cached yet, extracting script");
            byte[] extractedScript = null;
            try (@Nullable MpqEditor mpqEditor = MpqEditorFactory.getEditor(mapCopy, true);){
                if (mpqEditor.hasFile("war3map.j")) {
                    extractedScript = mpqEditor.extractFile("war3map.j");
                }
            }
            if (extractedScript == null) {
                if (scriptFile.exists()) {
                    msg = "No war3map.j in map file, using old extracted file";
                    WLogger.info(msg);
                } else {
                    err = new CompileError(new WPos(mapCopy.toString(), new LineOffsets(), 0, 0), "No war3map.j found in map file.");
                    gui.showInfoMessage(err.getMessage());
                    WLogger.severe(err);
                }
            } else if (new String(extractedScript, StandardCharsets.UTF_8).startsWith("// this script was compiled with wurst ")) {
                WLogger.info("map has already been compiled with wurst");
                if (scriptFile.exists()) {
                    msg = "Cannot use war3map.j from map file, because it already was compiled with wurst. Using war3map.j from Wurst directory instead.";
                    WLogger.info(msg);
                } else {
                    err = new CompileError(new WPos(mapCopy.toString(), new LineOffsets(), 0, 0), "Cannot use war3map.j from map file, because it already was compiled with wurst. Please add war3map.j to the wurst directory.");
                    gui.showInfoMessage(err.getMessage());
                    WLogger.severe(err);
                }
            } else {
                WLogger.info("new map, use extracted");
                com.google.common.io.Files.write((byte[])extractedScript, (File)scriptFile);
            }
        } else {
            System.out.println("Map not modified, not extracting script");
        }
        return scriptFile;
    }

    private CompilationResult applyProjectConfig(WurstGui gui, Optional<File> testMap, File buildDir, WurstProjectConfigData projectConfig, File scriptFile) {
        AtomicReference result = new AtomicReference();
        gui.sendProgress("Applying Map Config...");
        this.timeTaker.measure("Applying Map Config", () -> {
            try {
                result.set(ProjectConfigBuilder.apply(projectConfig, (File)testMap.get(), scriptFile, buildDir, this.runArgs, this.w3data));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return (CompilationResult)result.get();
    }

    private W3InstallationData getBestW3InstallationData() throws RequestFailedException {
        if (Orient.isLinuxSystem()) {
            return new W3InstallationData(Optional.empty(), Optional.empty());
        }
        if (this.wc3Path.isPresent() && StringUtils.isNotBlank((String)this.wc3Path.get())) {
            W3InstallationData w3data = new W3InstallationData(this.langServer, new File(this.wc3Path.get()), this instanceof RunMap && !this.runArgs.isHotReload());
            if (w3data.getWc3PatchVersion().isEmpty()) {
                throw new RequestFailedException(MessageType.Error, "Could not find Warcraft III installation at specified path: " + this.wc3Path);
            }
            return w3data;
        }
        return new W3InstallationData(this.langServer, this instanceof RunMap && !this.runArgs.isHotReload());
    }

    protected void injectMapData(WurstGui gui, Optional<File> testMap, CompilationResult result) throws Exception {
        gui.sendProgress("Injecting map data");
        try (MpqEditor mpqEditor = MpqEditorFactory.getEditor(testMap);){
            String mapScriptName;
            if (this.runArgs.isLua()) {
                mapScriptName = "war3map.lua";
                this.injectExternalLuaFiles(result.script);
            } else {
                mapScriptName = "war3map.j";
            }
            mpqEditor.deleteFile("war3map.j");
            mpqEditor.deleteFile("war3map.lua");
            if (result.w3i != null) {
                mpqEditor.deleteFile(W3I.GAME_PATH.getName());
                mpqEditor.insertFile(W3I.GAME_PATH.getName(), result.w3i);
            }
            mpqEditor.insertFile(mapScriptName, result.script);
        }
    }

    private void injectExternalLuaFiles(File script) {
        File[] children;
        File luaDir;
        try {
            luaDir = new File(this.workspaceRoot.getFile(), "lua");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot get build dir", e);
        }
        if (luaDir.exists() && (children = luaDir.listFiles()) != null) {
            Arrays.stream(children).forEach(child -> {
                try {
                    byte[] bytes = Files.readAllBytes(child.toPath());
                    if (child.getName().startsWith("pre_")) {
                        byte[] existingBytes = Files.readAllBytes(script.toPath());
                        Files.write(script.toPath(), bytes, new OpenOption[0]);
                        Files.write(script.toPath(), existingBytes, StandardOpenOption.APPEND);
                    } else {
                        Files.write(script.toPath(), bytes, StandardOpenOption.APPEND);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static class CompilationResult {
        public File script;
        public File w3i;
    }

    static enum SafetyLevel {
        QuickAndDirty,
        KindOfSafe;

    }
}

