/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.OsType;
import dorkbox.util.Property;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.TimeZone;

public class OS {
    @Property
    public static boolean FORCE_HIGH_RES_TIMER = true;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    private static final OsType osType;
    private static final String originalTimeZone;
    public static final int javaVersion;

    public static OsType get() {
        return osType;
    }

    public static boolean is64bit() {
        return osType.is64bit();
    }

    public static boolean is32bit() {
        return osType.is32bit();
    }

    public static boolean isArm() {
        return osType.isArm();
    }

    public static boolean isLinux() {
        return osType.isLinux();
    }

    public static boolean isWindows() {
        return osType.isWindows();
    }

    public static boolean isMacOsX() {
        return osType.isMacOsX();
    }

    public static boolean isAndroid() {
        return osType.isAndroid();
    }

    private static int _getJavaVersion() {
        String fullJavaVersion = System.getProperty("java.version");
        char versionChar = fullJavaVersion.startsWith("1.") ? fullJavaVersion.charAt(2) : fullJavaVersion.charAt(0);
        switch (versionChar) {
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }

    public static void setUTC() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    public static String getOriginalTimeZone() {
        return originalTimeZone;
    }

    public static int getOptimumNumberOfThreads() {
        return Math.max(Runtime.getRuntime().availableProcessors() - 2, 1);
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public final void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException();
    }

    public final void readObject(ObjectInputStream in) throws IOException {
        throw new NotSerializableException();
    }

    static {
        originalTimeZone = TimeZone.getDefault().getID();
        javaVersion = OS._getJavaVersion();
        if (FORCE_HIGH_RES_TIMER) {
            Thread timerAccuracyThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(Long.MAX_VALUE);
                            }
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
            }, "ForceHighResTimer");
            timerAccuracyThread.setDaemon(true);
            timerAccuracyThread.start();
        }
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (osName != null && osArch != null) {
            osName = osName.toLowerCase(Locale.US);
            osType = (osArch = osArch.toLowerCase(Locale.US)).equals("armeabi") ? OsType.AndroidArm56 : (osArch.equals("armeabi-v7a") ? OsType.AndroidArm7 : (osArch.equals("arm64-v8a") ? OsType.AndroidArm8 : (osArch.equals("x86") ? OsType.AndroidX86 : (osArch.equals("x86_64") ? OsType.AndroidX86_64 : (osArch.equals("mips") ? OsType.AndroidMips : (osArch.equals("mips64") ? OsType.AndroidMips64 : (osName.startsWith("linux") ? ("amd64".equals(osArch) ? OsType.Linux64 : (osArch.startsWith("arm") ? (osArch.contains("v8") ? OsType.LinuxArm64 : OsType.LinuxArm32) : OsType.Linux32)) : (osName.startsWith("windows") ? ("amd64".equals(osArch) ? OsType.Windows64 : OsType.Windows32) : (osName.startsWith("mac os x") || osName.startsWith("darwin") ? ("x86_64".equals(osArch) ? OsType.MacOsX64 : OsType.MacOsX32) : null)))))))));
        } else {
            osType = null;
        }
    }
}

