/*
 * Decompiled with CFR 0.152.
 */
package net;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import net.ConnectionManager;
import net.NetStatus;
import org.jetbrains.annotations.NotNull;
import us.monoid.json.JSONArray;
import us.monoid.json.JSONObject;
import us.monoid.web.JSONResource;
import us.monoid.web.Resty;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/ConnectionManager;", "", "()V", "MASTER_BRANCH", "", "WURST_COMPILER_URL", "WURST_SETUP_URL", "log", "Lmu/KLogger;", "netStatus", "Lnet/NetStatus;", "getNetStatus", "()Lnet/NetStatus;", "setNetStatus", "(Lnet/NetStatus;)V", "resty", "Lus/monoid/web/Resty;", "checkConnectivity", "url", "checkWurstBuild", "contactWurstServer", "", "findJsonTag", "Lus/monoid/json/JSONObject;", "path", "name", "getBuildNumber", "", "branch", "getLatestCompilerBuild", "getLatestSetupBuild", "WurstSetup"})
@SourceDebugExtension(value={"SMAP\nConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionManager.kt\nnet/ConnectionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1549#2:104\n1620#2,3:105\n288#2,2:108\n*S KotlinDebug\n*F\n+ 1 ConnectionManager.kt\nnet/ConnectionManager\n*L\n29#1:104\n29#1:105,3\n30#1:108,2\n*E\n"})
public final class ConnectionManager {
    @NotNull
    public static final ConnectionManager INSTANCE = new ConnectionManager();
    @NotNull
    private static final String WURST_SETUP_URL = "peeeq.de/hudson/job/WurstSetup/lastSuccessfulBuild/api/json";
    @NotNull
    private static final String WURST_COMPILER_URL = "peeeq.de/hudson/job/Wurst/lastSuccessfulBuild/api/json";
    @NotNull
    private static final String MASTER_BRANCH = "refs/remotes/origin/master";
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
    @NotNull
    private static final Resty resty = new Resty(new Resty.Option[0]);
    @NotNull
    private static NetStatus netStatus = NetStatus.CLIENT_OFFLINE;

    private ConnectionManager() {
    }

    @NotNull
    public final NetStatus getNetStatus() {
        return netStatus;
    }

    public final void setNetStatus(@NotNull NetStatus netStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)netStatus), (String)"<set-?>");
        ConnectionManager.netStatus = netStatus;
    }

    /*
     * WARNING - void declaration
     */
    private final JSONObject findJsonTag(String url, String path, String name) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            JSONArray actions = new JSONArray(resty.json(url).get(Resty.path((String)path)).toString());
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)actions.length());
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new JSONObject(actions.get((int)it).toString()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JSONObject it = (JSONObject)element$iv;
                boolean bl = false;
                if (!it.has(name)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        JSONObject jSONObject = v0;
        JSONObject jSONObject2 = jSONObject != null ? jSONObject.getJSONObject(name) : null;
        return jSONObject2 == null ? new JSONObject() : jSONObject2;
    }

    @NotNull
    public final NetStatus checkConnectivity(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        netStatus = NetStatus.SERVER_CONTACT;
        try {
            JSONResource json = resty.json(url);
            if (netStatus == NetStatus.SERVER_CONTACT && (json == null || StringsKt.isBlank((CharSequence)json.toString()))) {
                netStatus = NetStatus.CLIENT_OFFLINE;
                return netStatus;
            }
        }
        catch (IOException e) {
            log.debug("couldn't contact: " + e.getLocalizedMessage());
        }
        return netStatus;
    }

    private final void contactWurstServer(String url) {
        NetStatus netStatus;
        try {
            JSONResource wurstResponse = resty.json(url);
            netStatus = wurstResponse == null || StringsKt.isBlank((CharSequence)wurstResponse.toString()) ? NetStatus.SERVER_OFFLINE : NetStatus.ONLINE;
        }
        catch (IOException e) {
            log.debug("couldn't contact wurst jenkins: " + e.getLocalizedMessage());
            netStatus = NetStatus.SERVER_OFFLINE;
        }
        ConnectionManager.netStatus = netStatus;
    }

    private final int getBuildNumber(String url, String branch) {
        if (netStatus != NetStatus.ONLINE) {
            return 0;
        }
        JSONObject response = this.findJsonTag(url, "actions", "buildsByBranchName");
        if (response.has(branch)) {
            JSONObject innerObject = new JSONObject(response.get(branch).toString());
            return Integer.parseInt(innerObject.get("buildNumber").toString());
        }
        return -1;
    }

    public final int getLatestSetupBuild() {
        int n;
        log.debug("getting latest setup build");
        try {
            n = this.getBuildNumber("https://peeeq.de/hudson/job/WurstSetup/lastSuccessfulBuild/api/json", MASTER_BRANCH);
        }
        catch (IOException e) {
            n = this.getBuildNumber("http://peeeq.de/hudson/job/WurstSetup/lastSuccessfulBuild/api/json", MASTER_BRANCH);
        }
        return n;
    }

    public final int getLatestCompilerBuild() {
        int n;
        log.debug("getting latest compiler build");
        try {
            n = this.getBuildNumber("https://peeeq.de/hudson/job/Wurst/lastSuccessfulBuild/api/json", MASTER_BRANCH);
        }
        catch (IOException e) {
            n = this.getBuildNumber("http://peeeq.de/hudson/job/Wurst/lastSuccessfulBuild/api/json", MASTER_BRANCH);
        }
        return n;
    }

    @NotNull
    public final NetStatus checkWurstBuild() {
        log.debug("checking wurst build");
        this.contactWurstServer("https://peeeq.de/hudson/job/Wurst/lastSuccessfulBuild/api/json");
        if (netStatus == NetStatus.SERVER_OFFLINE) {
            this.contactWurstServer("http://peeeq.de/hudson/job/Wurst/lastSuccessfulBuild/api/json");
        }
        return netStatus;
    }
}

