/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u001e\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 V*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002VWB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010+J\u0014\u0010,\u001a\u00020-2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J)\u0010,\u001a\u00020)2\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006\u00a2\u0006\u0002\u00101J\u001f\u0010,\u001a\u00020)2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0010\"\u00028\u0000\u00a2\u0006\u0002\u00102J\u001b\u0010,\u001a\u00020-2\u000e\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0010\u00a2\u0006\u0002\u0010\u0014J+\u0010,\u001a\u00020-2\u000e\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00102\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0006\u00a2\u0006\u0002\u00103J\u0016\u0010,\u001a\u00020)2\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u000005H\u0016J\u0015\u00106\u001a\u00020-2\u0006\u00107\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u00020-H\u0016J\u0010\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020\u0006H\u0016J\u0016\u0010;\u001a\u00020)2\u0006\u0010*\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010+J\u0016\u0010<\u001a\u00020)2\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u000005H\u0016J\u000e\u0010=\u001a\u00020-2\u0006\u0010>\u001a\u00020\u0006J\u0013\u0010?\u001a\u00020)2\b\u0010@\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\r\u0010A\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010BJ\u0018\u0010C\u001a\u0004\u0018\u00018\u00002\u0006\u00107\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010DJ\b\u0010E\u001a\u00020\u0006H\u0016J\b\u0010F\u001a\u00020)H\u0016J\u000f\u0010G\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0096\u0002J\u0015\u0010H\u001a\u00020\u00062\b\u00107\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010IJ\u0006\u0010J\u001a\u00020)J\u0015\u0010K\u001a\u00020\u00062\u0006\u0010L\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010IJ\u0015\u0010M\u001a\u00020)2\u0006\u0010*\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010+J\u0016\u0010N\u001a\u00020)2\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u000005H\u0016J\u0010\u0010O\u001a\u00020-2\u0006\u0010P\u001a\u00020\u0006H\u0002J\u0016\u0010Q\u001a\u00020)2\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u000005H\u0016J\u000e\u0010R\u001a\u00020-2\u0006\u0010:\u001a\u00020\u0006J\b\u0010S\u001a\u00020TH\u0016J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020TH\u0016R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001a\u0010%\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001e\u00a8\u0006X"}, d2={"Ldorkbox/collections/ObjectSet;", "T", "", "", "()V", "initialCapacity", "", "loadFactor", "", "(IF)V", "set", "(Ldorkbox/collections/ObjectSet;)V", "iterator1", "Ldorkbox/collections/ObjectSet$ObjectSetIterator;", "iterator2", "keyTable", "", "getKeyTable", "()[Ljava/lang/Object;", "setKeyTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "getLoadFactor", "()F", "setLoadFactor", "(F)V", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "setSize", "threshold", "getThreshold", "setThreshold", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "", "array", "offset", "length", "([Ljava/lang/Object;II)Z", "([Ljava/lang/Object;)Z", "([Ljava/lang/Object;II)V", "elements", "", "addResize", "key", "(Ljava/lang/Object;)V", "clear", "maximumCapacity", "contains", "containsAll", "ensureCapacity", "additionalCapacity", "equals", "other", "first", "()Ljava/lang/Object;", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "isEmpty", "iterator", "locateKey", "(Ljava/lang/Object;)I", "notEmpty", "place", "item", "remove", "removeAll", "resize", "newSize", "retainAll", "shrink", "toString", "", "separator", "Companion", "ObjectSetIterator", "Collections"})
@SourceDebugExtension(value={"SMAP\nObjectSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectSet.kt\ndorkbox/collections/ObjectSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,574:1\n1#2:575\n1855#3,2:576\n1855#3,2:580\n1855#3,2:582\n13579#4,2:578\n*S KotlinDebug\n*F\n+ 1 ObjectSet.kt\ndorkbox/collections/ObjectSet\n*L\n185#1:576,2\n272#1:580,2\n357#1:582,2\n260#1:578,2\n*E\n"})
public class ObjectSet<T>
implements Set<T>,
KMutableSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size;
    @NotNull
    private T[] keyTable;
    private float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    @Nullable
    private transient ObjectSetIterator<T> iterator1;
    @Nullable
    private transient ObjectSetIterator<T> iterator2;
    @NotNull
    public static final String version = "2.4";

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @NotNull
    public final T[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(@NotNull T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"<set-?>");
        this.keyTable = TArray;
    }

    public final float getLoadFactor() {
        return this.loadFactor;
    }

    public final void setLoadFactor(float f) {
        this.loadFactor = f;
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public ObjectSet() {
        this(51, 0.8f);
    }

    public ObjectSet(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Companion.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[tableSize];
    }

    public /* synthetic */ ObjectSet(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public ObjectSet(@NotNull ObjectSet<? extends T> set) {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        this((int)((float)set.keyTable.length * set.loadFactor), set.loadFactor);
        System.arraycopy(set.keyTable, 0, this.keyTable, 0, set.keyTable.length);
        this.setSize(set.size());
    }

    protected final int place(@NotNull T item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return (int)((long)item.hashCode() * -7046029254386353131L >>> this.shift);
    }

    public final int locateKey(@Nullable T key) {
        if (key == null) {
            boolean $i$a$-requireNotNull-ObjectSet$locateKey$22 = false;
            String $i$a$-requireNotNull-ObjectSet$locateKey$22 = "key cannot be null.";
            throw new IllegalArgumentException($i$a$-requireNotNull-ObjectSet$locateKey$22.toString());
        }
        T[] keyTable = this.keyTable;
        int i = this.place(key);
        while (keyTable[i] != null) {
            T other;
            if (Intrinsics.areEqual(other, key)) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return -(i + 1);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean added = false;
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            added = this.add((T)it) || added;
        }
        return added;
    }

    @Override
    public boolean add(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        int i = this.locateKey(element);
        if (i >= 0) {
            return false;
        }
        i = -(i + 1);
        this.keyTable[i] = element;
        this.setSize(this.size() + 1);
        if (this.size() >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return true;
    }

    public final void addAll(@NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        this.addAll(array, 0, array.length);
    }

    public final void addAll(@NotNull T[] array, int offset, int length) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        if (offset + length > array.length) {
            throw new StateException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.length);
        }
        this.addAll(array, offset, length);
    }

    public final boolean addAll(T ... array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return this.addAll(array, 0, array.length);
    }

    public final boolean addAll(@NotNull T[] array, int offset, int length) {
        int i;
        Intrinsics.checkNotNullParameter(array, (String)"array");
        this.ensureCapacity(length);
        int oldSize = this.size();
        int n = i + length;
        for (i = offset; i < n; ++i) {
            this.add(array[i]);
        }
        return oldSize != this.size();
    }

    public final void addAll(@NotNull ObjectSet<T> set) {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        this.ensureCapacity(set.size());
        for (T key : set.keyTable) {
            T it;
            if (key == null) continue;
            boolean bl = false;
            this.add(it);
        }
    }

    private final void addResize(T key) {
        T[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == null) {
                keyTable[i] = key;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = false;
        T[] $this$forEach$iv = this.keyTable;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            T element$iv;
            T key = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (key == null || elements.contains(key)) continue;
            removed = this.remove(key) || removed;
        }
        return removed;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = false;
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            if (!this.remove(it)) continue;
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean remove(@Nullable Object element) {
        if (element == null) {
            return false;
        }
        int i = this.locateKey(element);
        if (i < 0) {
            return false;
        }
        T[] keyTable = this.keyTable;
        int mask = this.mask;
        int next = i + 1 & mask;
        T k = null;
        while (true) {
            T t;
            T it = t = keyTable[next];
            boolean bl = false;
            k = it;
            if (t == null) break;
            T t2 = k;
            Intrinsics.checkNotNull(t2);
            int placement = this.place(t2);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = k;
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = null;
        int n = this.size();
        this.setSize(n + -1);
        return true;
    }

    public final boolean notEmpty() {
        return this.size() > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.setSize(0);
        this.resize(tableSize);
    }

    @Override
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        this.setSize(0);
        Arrays.fill(this.keyTable, null);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            if (this.contains(it)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        if (element == null) {
            return false;
        }
        return this.locateKey(element) >= 0;
    }

    @Nullable
    public final T get(@NotNull T key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int i = this.locateKey(key);
        return i < 0 ? null : (T)this.keyTable[i];
    }

    @Nullable
    public final T first() {
        T[] keyTable = this.keyTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            if (keyTable[i] == null) continue;
            return keyTable[i];
        }
        throw new IllegalStateException("ObjectSet is empty.");
    }

    public final void ensureCapacity(int additionalCapacity) {
        int tableSize = Companion.tableSize(this.size() + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    private final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        T[] oldKeyTable = this.keyTable;
        this.keyTable = new Object[newSize];
        if (this.size() > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                T key = oldKeyTable[i];
                if (key != null) {
                    T it;
                    boolean bl = false;
                    this.addResize(it);
                }
            }
        }
    }

    @Override
    public int hashCode() {
        int h = this.size();
        for (T key : this.keyTable) {
            if (key == null) continue;
            h += key.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ObjectSet)) {
            return false;
        }
        ObjectSet cfr_ignored_0 = (ObjectSet)other;
        if (((ObjectSet)other).size() != this.size()) {
            return false;
        }
        T[] keyTable = this.keyTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            if (keyTable[i] == null || CollectionsKt.contains((Iterable)((Iterable)other), keyTable[i])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        return '{' + this.toString(", ") + '}';
    }

    @NotNull
    public String toString(@NotNull String separator) {
        T key;
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if (this.size() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(32);
        T[] keyTable = this.keyTable;
        int i = keyTable.length;
        while (i-- > 0) {
            T t = keyTable[i];
            if (t == null) continue;
            key = t;
            buffer.append((Object)(key == this ? "(this)" : key));
            break;
        }
        while (i-- > 0) {
            if (keyTable[i] == null) continue;
            buffer.append(separator);
            buffer.append((Object)(key == this ? "(this)" : key));
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @Override
    @NotNull
    public ObjectSetIterator<T> iterator() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new ObjectSetIterator(this);
        }
        if (this.iterator1 == null) {
            this.iterator1 = new ObjectSetIterator(this);
            this.iterator2 = new ObjectSetIterator(this);
        }
        ObjectSetIterator<T> objectSetIterator = this.iterator1;
        Intrinsics.checkNotNull(objectSetIterator);
        if (!objectSetIterator.getValid()) {
            ObjectSetIterator<T> objectSetIterator2 = this.iterator1;
            Intrinsics.checkNotNull(objectSetIterator2);
            objectSetIterator2.reset();
            ObjectSetIterator<T> objectSetIterator3 = this.iterator1;
            Intrinsics.checkNotNull(objectSetIterator3);
            objectSetIterator3.setValid(true);
            ObjectSetIterator<T> objectSetIterator4 = this.iterator2;
            Intrinsics.checkNotNull(objectSetIterator4);
            objectSetIterator4.setValid(false);
            ObjectSetIterator<T> objectSetIterator5 = this.iterator1;
            Intrinsics.checkNotNull(objectSetIterator5, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectSet.ObjectSetIterator<T of dorkbox.collections.ObjectSet>");
            return objectSetIterator5;
        }
        ObjectSetIterator<T> objectSetIterator6 = this.iterator2;
        Intrinsics.checkNotNull(objectSetIterator6);
        objectSetIterator6.reset();
        ObjectSetIterator<T> objectSetIterator7 = this.iterator2;
        Intrinsics.checkNotNull(objectSetIterator7);
        objectSetIterator7.setValid(true);
        ObjectSetIterator<T> objectSetIterator8 = this.iterator1;
        Intrinsics.checkNotNull(objectSetIterator8);
        objectSetIterator8.setValid(false);
        ObjectSetIterator<T> objectSetIterator9 = this.iterator2;
        Intrinsics.checkNotNull(objectSetIterator9, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectSet.ObjectSetIterator<T of dorkbox.collections.ObjectSet>");
        return objectSetIterator9;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u001c\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\t\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0096\u0002J\u000e\u0010\u001f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u001dH\u0016J\u0013\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010$H\u0016\u00a2\u0006\u0002\u0010%J!\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00010$H\u0016\u00a2\u0006\u0002\u0010'R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006("}, d2={"Ldorkbox/collections/ObjectSet$ObjectSetIterator;", "K", "", "", "", "set", "Ldorkbox/collections/ObjectSet;", "(Ldorkbox/collections/ObjectSet;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "nextIndex", "getNextIndex", "setNextIndex", "getSet", "()Ldorkbox/collections/ObjectSet;", "valid", "getValid", "setValid", "findNextIndex", "", "iterator", "next", "()Ljava/lang/Object;", "remove", "reset", "toArray", "", "()[Ljava/lang/Object;", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "Collections"})
    @SourceDebugExtension(value={"SMAP\nObjectSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectSet.kt\ndorkbox/collections/ObjectSet$ObjectSetIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,574:1\n1#2:575\n*E\n"})
    public static class ObjectSetIterator<K>
    implements Iterable<K>,
    Iterator<K>,
    KMappedMarker,
    KMutableIterator {
        @NotNull
        private final ObjectSet<K> set;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;

        public ObjectSetIterator(@NotNull ObjectSet<K> set) {
            Intrinsics.checkNotNullParameter(set, (String)"set");
            this.set = set;
            this.valid = true;
            this.reset();
        }

        @NotNull
        public final ObjectSet<K> getSet() {
            return this.set;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        private final void findNextIndex() {
            block1: {
                K[] keyTable = this.set.getKeyTable();
                int n = this.set.getKeyTable().length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (keyTable[this.nextIndex] == null);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            Object object;
            int i = this.currentIndex;
            if (!(i >= 0)) {
                boolean $i$a$-check-ObjectSet$ObjectSetIterator$remove$22 = false;
                String $i$a$-check-ObjectSet$ObjectSetIterator$remove$22 = "next must be called before remove.";
                throw new IllegalStateException($i$a$-check-ObjectSet$ObjectSetIterator$remove$22.toString());
            }
            K[] keyTable = this.set.getKeyTable();
            int mask = this.set.getMask();
            int next = i + 1 & mask;
            Object key = null;
            while (true) {
                object = keyTable[next];
                K it = object;
                boolean bl = false;
                key = it;
                if (object == null) break;
                Object t = key;
                Intrinsics.checkNotNull(t);
                int placement = this.set.place(t);
                if ((next - placement & mask) > (i - placement & mask)) {
                    keyTable[i] = key;
                    i = next;
                }
                next = next + 1 & mask;
            }
            keyTable[i] = null;
            object = this.set;
            int n = ((ObjectSet)object).size();
            ((ObjectSet)object).setSize(n + -1);
            if (i != this.currentIndex) {
                this.nextIndex += -1;
            }
            this.currentIndex = -1;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        @NotNull
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            K key = this.set.getKeyTable()[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            K k = key;
            Intrinsics.checkNotNull(k);
            return k;
        }

        @Override
        @NotNull
        public ObjectSetIterator<K> iterator() {
            return this;
        }

        @NotNull
        public K[] toArray() {
            int n = 0;
            int n2 = this.set.size();
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                objectArray[n3] = this.next();
            }
            return objectArray;
        }

        @NotNull
        public K[] toArray(@NotNull K[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            int i = 0;
            while (this.hasNext) {
                array[i++] = this.next();
            }
            return array;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ/\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\b\b\u0001\u0010\f*\u00020\u00012\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\f0\u000e\"\u0002H\f\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldorkbox/collections/ObjectSet$Companion;", "", "()V", "version", "", "tableSize", "", "capacity", "loadFactor", "", "with", "Ldorkbox/collections/ObjectSet;", "T", "array", "", "([Ljava/lang/Object;)Ldorkbox/collections/ObjectSet;", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> ObjectSet<T> with(T ... array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            ObjectSet<T> set = new ObjectSet<T>();
            set.addAll(Arrays.copyOf(array, array.length));
            return set;
        }

        public final int tableSize(int capacity, float loadFactor) {
            if (capacity < 0) {
                throw new StateException("capacity must be >= 0: " + capacity);
            }
            int tableSize = Collections.INSTANCE.nextPowerOfTwo((int)Math.max(2.0, (double)((int)Math.ceil((float)capacity / loadFactor))));
            if (tableSize > 0x40000000) {
                throw new StateException("The required capacity is too large: " + capacity);
            }
            return tableSize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

