/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.dataTypes.app.FlagsInt;
import net.moonlightflower.wc3libs.port.Orient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcCaller {
    private static final Logger log = LoggerFactory.getLogger((String)FlagsInt.class.getName());
    private final ProcessBuilder _builder;
    private Process _proc;
    private String _outString;
    private String _errString;
    private boolean _minimized = false;
    private final List<String> _cmds = new ArrayList<String>();

    public String getOutString() {
        return this._outString;
    }

    public String getErrString() {
        return this._errString;
    }

    public int exitVal() {
        return this._proc != null ? this._proc.exitValue() : -1;
    }

    public void exec() throws IOException {
        if (this._minimized && Orient.isWindowsSystem()) {
            StringBuilder sb = new StringBuilder();
            sb.append("cmd.exe /c ");
            sb.append("start /wait /min \"abc\" ");
            for (String s : this._builder.command()) {
                if (s.startsWith("/")) {
                    sb.append(String.format("%s ", s));
                    continue;
                }
                sb.append(String.format("\"%s\" ", s.replace("/", "/")));
            }
            this._proc = Runtime.getRuntime().exec(sb.toString());
        } else {
            this._proc = this._builder.start();
        }
        StreamReader reader = new StreamReader(this._proc.getInputStream());
        StreamReader errReader = new StreamReader(this._proc.getErrorStream());
        reader.start();
        errReader.start();
        try {
            this._proc.waitFor();
            reader.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this._outString = reader.toString();
        this._errString = errReader.toString();
    }

    public void setMinimized(boolean val) {
        this._minimized = val;
    }

    public ProcCaller(String ... command) {
        Collections.addAll(this._cmds, command);
        this._builder = new ProcessBuilder(this._cmds);
    }

    private static class StreamReader
    extends Thread {
        private final InputStream _inStream;
        private final StringWriter _stringWriter = new StringWriter();

        @Override
        public String toString() {
            return this._stringWriter.toString();
        }

        @Override
        public void run() {
            try {
                int len;
                byte[] bytes = new byte[1024];
                while ((len = this._inStream.read(bytes, 0, bytes.length)) != -1) {
                    this._stringWriter.write(new String(bytes, 0, len));
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }

        public StreamReader(@Nonnull InputStream inStream) {
            this._inStream = inStream;
        }
    }
}

