/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.ObjectMap;
import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0016\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 n*\u0004\b\u0000\u0010\u00012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002:\u0006nopqrsB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010F\u001a\u00020GH\u0016J\u000e\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u0006J\u0010\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020\u0003H\u0016J\u0017\u0010K\u001a\u00020\u00162\b\u0010L\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010MJ\u001a\u0010K\u001a\u00020\u00162\b\u0010L\u001a\u0004\u0018\u00010N2\b\b\u0002\u0010O\u001a\u00020\u0016J\u000e\u0010P\u001a\u00020G2\u0006\u0010Q\u001a\u00020\u0006J\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0013J\u0013\u0010R\u001a\u00020\u00162\b\u0010S\u001a\u0004\u0018\u00010NH\u0096\u0002J\u0010\u0010T\u001a\u00020\u00162\b\u0010S\u001a\u0004\u0018\u00010NJ\u001f\u0010U\u001a\u0004\u0018\u00010\u00032\b\u0010L\u001a\u0004\u0018\u00010N2\u0006\u0010O\u001a\u00020\u0016\u00a2\u0006\u0002\u0010VJ \u0010U\u001a\u00020\u00032\b\u0010L\u001a\u0004\u0018\u00010N2\u0006\u0010O\u001a\u00020\u00162\u0006\u0010W\u001a\u00020\u0003J\u0018\u0010X\u001a\u0004\u0018\u00018\u00002\u0006\u0010J\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010YJ \u0010X\u001a\u0004\u0018\u00018\u00002\u0006\u0010J\u001a\u00020\u00032\u0006\u0010Z\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010[J\b\u0010\\\u001a\u00020\u0006H\u0016J\b\u0010]\u001a\u00020\u0016H\u0016J\u0006\u0010!\u001a\u00020$J\u0010\u0010^\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\u0003H\u0002J\u0006\u0010_\u001a\u00020\u0016J\u0010\u0010`\u001a\u00020\u00062\u0006\u0010a\u001a\u00020\u0003H\u0004J!\u0010b\u001a\u0004\u0018\u00018\u00002\u0006\u0010J\u001a\u00020\u00032\b\u0010L\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010[J\u0018\u0010c\u001a\u00020G2\u0010\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000\u0000J \u0010c\u001a\u00020G2\u0016\u0010d\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00018\u00000eH\u0016J\u001f\u0010f\u001a\u00020G2\u0006\u0010J\u001a\u00020\u00032\b\u0010L\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010gJ\u0017\u0010h\u001a\u0004\u0018\u00018\u00002\u0006\u0010J\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010YJ\u0010\u0010i\u001a\u00020G2\u0006\u0010j\u001a\u00020\u0006H\u0002J\u000e\u0010k\u001a\u00020G2\u0006\u0010H\u001a\u00020\u0006J\b\u0010l\u001a\u00020mH\u0016J\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000>R.\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000e0\r8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0004\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0011R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R\u0014\u0010.\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010(R\u000e\u00100\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u000003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00108\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001c\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0018\u0010=\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010?\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010@\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010E\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006t"}, d2={"Ldorkbox/collections/LongMap;", "V", "", "", "()V", "initialCapacity", "", "loadFactor", "", "(IF)V", "map", "(Ldorkbox/collections/LongMap;)V", "entries", "", "", "getEntries$annotations", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/LongMap$Entries;", "entries2", "hasZeroValue", "", "getHasZeroValue", "()Z", "setHasZeroValue", "(Z)V", "keyTable", "", "getKeyTable", "()[J", "setKeyTable", "([J)V", "keys", "getKeys", "keys1", "Ldorkbox/collections/LongMap$Keys;", "keys2", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "size_", "threshold", "valueTable", "", "getValueTable", "()[Ljava/lang/Object;", "setValueTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/LongMap$Values;", "values2", "zeroValue", "getZeroValue", "()Ljava/lang/Object;", "setZeroValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "clear", "", "maximumCapacity", "containsKey", "key", "containsValue", "value", "(Ljava/lang/Object;)Z", "", "identity", "ensureCapacity", "additionalCapacity", "equals", "other", "equalsIdentity", "findKey", "(Ljava/lang/Object;Z)Ljava/lang/Long;", "notFound", "get", "(J)Ljava/lang/Object;", "defaultValue", "(JLjava/lang/Object;)Ljava/lang/Object;", "hashCode", "isEmpty", "locateKey", "notEmpty", "place", "item", "put", "putAll", "from", "", "putResize", "(JLjava/lang/Object;)V", "remove", "resize", "newSize", "shrink", "toString", "", "Companion", "Entries", "Entry", "Keys", "MapIterator", "Values", "Collections"})
@SourceDebugExtension(value={"SMAP\nLongMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongMap.kt\ndorkbox/collections/LongMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1034:1\n1#2:1035\n1855#3,2:1036\n*S KotlinDebug\n*F\n+ 1 LongMap.kt\ndorkbox/collections/LongMap\n*L\n299#1:1036,2\n*E\n"})
public final class LongMap<V>
implements Map<Long, V>,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size_;
    @NotNull
    private long[] keyTable;
    @NotNull
    private V[] valueTable;
    @Nullable
    private V zeroValue;
    private boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    @Nullable
    private transient Entries<V> entries1;
    @Nullable
    private transient Entries<V> entries2;
    @Nullable
    private transient Values<V> values1;
    @Nullable
    private transient Values<V> values2;
    @Nullable
    private transient Keys keys1;
    @Nullable
    private transient Keys keys2;
    @NotNull
    public static final String version = "2.4";

    @NotNull
    public final long[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(@NotNull long[] lArray) {
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
        this.keyTable = lArray;
    }

    @NotNull
    public final V[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(@NotNull V[] VArray) {
        Intrinsics.checkNotNullParameter(VArray, (String)"<set-?>");
        this.valueTable = VArray;
    }

    @Nullable
    public final V getZeroValue() {
        return this.zeroValue;
    }

    public final void setZeroValue(@Nullable V v) {
        this.zeroValue = v;
    }

    public final boolean getHasZeroValue() {
        return this.hasZeroValue;
    }

    public final void setHasZeroValue(boolean bl) {
        this.hasZeroValue = bl;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public LongMap() {
        this(51, 0.8f);
    }

    public LongMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = ObjectSet.Companion.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new long[tableSize];
        this.valueTable = new Object[tableSize];
    }

    public /* synthetic */ LongMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public LongMap(@NotNull LongMap<? extends V> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.size_ = map.size_;
        this.zeroValue = map.zeroValue;
        this.hasZeroValue = map.hasZeroValue;
    }

    protected final int place(long item) {
        return (int)(item * -7046029254386353131L >>> this.shift);
    }

    private final int locateKey(long key) {
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        long other;
        while ((other = keyTable[i]) != 0L) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return -(i + 1);
    }

    @Override
    @Nullable
    public V put(long key, @Nullable V value) {
        if (key == 0L) {
            V oldValue = this.zeroValue;
            this.zeroValue = value;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                int n = this.size_;
                this.size_ = n + 1;
            }
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        ++this.size_;
        if (this.size_ >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    public final void putAll(@NotNull LongMap<? extends V> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.ensureCapacity(map.size_);
        if (map.hasZeroValue) {
            V v = map.zeroValue;
            Intrinsics.checkNotNull(v);
            this.put(0L, v);
        }
        long[] keyTable = map.keyTable;
        V[] valueTable = map.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            long key = keyTable[i];
            if (key == 0L) continue;
            V v = valueTable[i];
            Intrinsics.checkNotNull(v);
            this.put(key, v);
        }
    }

    private final void putResize(long key, V value) {
        long[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == 0L) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    @Nullable
    public V get(long key) {
        if (key == 0L) {
            return this.hasZeroValue ? (V)this.zeroValue : null;
        }
        int i = this.locateKey(key);
        return i >= 0 ? (V)this.valueTable[i] : null;
    }

    @Nullable
    public final V get(long key, V defaultValue) {
        if (key == 0L) {
            V v;
            if (this.hasZeroValue) {
                V v2 = this.zeroValue;
                v = v2;
                Intrinsics.checkNotNull(v2);
            } else {
                v = defaultValue;
            }
            return v;
        }
        int i = this.locateKey(key);
        return i >= 0 ? this.valueTable[i] : defaultValue;
    }

    @Nullable
    public V remove(long key) {
        if (key == 0L) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            V oldValue = this.zeroValue;
            this.zeroValue = null;
            int n = this.size_;
            this.size_ = n + -1;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return null;
        }
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        V oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        long k = 0L;
        while (true) {
            long l;
            long it = l = keyTable[next];
            boolean bl = false;
            k = it;
            if (l == 0L) break;
            int placement = this.place(k);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = k;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = 0L;
        valueTable[i] = null;
        int n = this.size_;
        this.size_ = n + -1;
        return oldValue;
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size_ == 0;
    }

    @Override
    public void putAll(@NotNull Map<? extends Long, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.ensureCapacity(from.size());
        Iterable $this$forEach$iv = from.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            long k = ((Number)entry.getKey()).longValue();
            Object v = entry.getValue();
            this.put(k, v);
        }
    }

    public final void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public final void clear(int maximumCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.hasZeroValue = false;
        this.zeroValue = null;
        this.resize(tableSize);
    }

    @NotNull
    public Set<Map.Entry<Long, V>> getEntries() {
        Entries<V> entries = this.entries();
        Intrinsics.checkNotNull(entries, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.collections.MutableMap.MutableEntry<kotlin.Long, V of dorkbox.collections.LongMap?>>");
        return TypeIntrinsics.asMutableSet(entries);
    }

    public static /* synthetic */ void getEntries$annotations() {
    }

    @NotNull
    public Set<Long> getKeys() {
        return this.keys();
    }

    public int getSize() {
        return this.size_;
    }

    @NotNull
    public Collection<V> getValues() {
        return this.values();
    }

    @Override
    public void clear() {
        if (this.size_ == 0) {
            return;
        }
        this.size_ = 0;
        Arrays.fill(this.keyTable, 0L);
        Arrays.fill(this.valueTable, null);
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.containsValue(value, false);
    }

    public final boolean containsValue(@Nullable Object value, boolean identity) {
        V[] valueTable = this.valueTable;
        if (value == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            long[] keyTable = this.keyTable;
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (keyTable[i = n--] == 0L || valueTable[i] != null) continue;
                    return true;
                } while (0 <= n);
            }
        } else if (identity) {
            if (value == this.zeroValue) {
                return true;
            }
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (valueTable[i = n--] != value) continue;
                    return true;
                } while (0 <= n);
            }
        } else {
            if (this.hasZeroValue && Intrinsics.areEqual((Object)value, this.zeroValue)) {
                return true;
            }
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (!Intrinsics.areEqual((Object)value, valueTable[i = n--])) continue;
                    return true;
                } while (0 <= n);
            }
        }
        return false;
    }

    public static /* synthetic */ boolean containsValue$default(LongMap longMap, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return longMap.containsValue(object, bl);
    }

    public boolean containsKey(long key) {
        return key == 0L ? this.hasZeroValue : this.locateKey(key) >= 0;
    }

    @Nullable
    public final Long findKey(@Nullable Object value, boolean identity) {
        V[] valueTable = this.valueTable;
        if (value == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0L;
            }
            long[] keyTable = this.keyTable;
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (keyTable[i = n--] == 0L || valueTable[i] != null) continue;
                    return keyTable[i];
                } while (0 <= n);
            }
        } else if (identity) {
            if (value == this.zeroValue) {
                return 0L;
            }
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (valueTable[i = n--] != value) continue;
                    return this.keyTable[i];
                } while (0 <= n);
            }
        } else {
            if (this.hasZeroValue && Intrinsics.areEqual((Object)value, this.zeroValue)) {
                return 0L;
            }
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (!Intrinsics.areEqual((Object)value, valueTable[i = n--])) continue;
                    return this.keyTable[i];
                } while (0 <= n);
            }
        }
        return null;
    }

    public final long findKey(@Nullable Object value, boolean identity, long notFound) {
        Long l = this.findKey(value, identity);
        return l != null ? l : notFound;
    }

    public final void ensureCapacity(int additionalCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(this.size_ + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    private final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        long[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new long[newSize];
        this.valueTable = new Object[newSize];
        if (this.size_ > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                long key = oldKeyTable[i];
                if (key == 0L) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    @Override
    public int hashCode() {
        int h = this.size_;
        if (this.hasZeroValue && this.zeroValue != null) {
            V v = this.zeroValue;
            h += v != null ? v.hashCode() : 0;
        }
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            long key = keyTable[i];
            if (key == 0L) continue;
            h += (int)key * 31;
            V value = valueTable[i];
            if (value == null) continue;
            h += value.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LongMap)) {
            return false;
        }
        LongMap cfr_ignored_0 = (LongMap)other;
        if (((LongMap)other).size_ != this.size_) {
            return false;
        }
        if (((LongMap)other).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (((LongMap)other).zeroValue == null ? this.zeroValue != null : !Intrinsics.areEqual(((LongMap)other).zeroValue, this.zeroValue))) {
            return false;
        }
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            V value;
            long key = keyTable[i];
            if (key == 0L || !((value = valueTable[i]) == null ? ((LongMap)other).get(key, ObjectMap.Companion.getDummy$Collections()) != null : !Intrinsics.areEqual(value, ((LongMap)other).get((Object)key)))) continue;
            return false;
        }
        return true;
    }

    public final boolean equalsIdentity(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LongMap)) {
            return false;
        }
        LongMap cfr_ignored_0 = (LongMap)other;
        if (((LongMap)other).size_ != this.size_) {
            return false;
        }
        if (((LongMap)other).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && this.zeroValue != ((LongMap)other).zeroValue) {
            return false;
        }
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            long key = keyTable[i];
            if (key == 0L || valueTable[i] == ((LongMap)other).get(key, ObjectMap.Companion.getDummy$Collections())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        long key;
        if (this.size_ == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        long[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i = keyTable.length;
        if (this.hasZeroValue) {
            buffer.append("0=");
            buffer.append(this.zeroValue);
        } else {
            while (i-- > 0) {
                key = keyTable[i];
                if (key == 0L) continue;
                buffer.append(key);
                buffer.append('=');
                buffer.append(valueTable[i]);
                break;
            }
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0L) continue;
            buffer.append(", ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
        }
        buffer.append(']');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @NotNull
    public final Entries<V> entries() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.LongMap<V of dorkbox.collections.LongMap?>");
            return new Entries(this);
        }
        if (this.entries1 == null) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.LongMap<V of dorkbox.collections.LongMap?>");
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries<V> entries = this.entries1;
        Intrinsics.checkNotNull(entries);
        if (!entries.getValid()) {
            Entries<V> entries2 = this.entries1;
            Intrinsics.checkNotNull(entries2);
            entries2.reset();
            Entries<V> entries3 = this.entries1;
            Intrinsics.checkNotNull(entries3);
            entries3.setValid(true);
            Entries<V> entries4 = this.entries2;
            Intrinsics.checkNotNull(entries4);
            entries4.setValid(false);
            Entries<V> entries5 = this.entries1;
            Intrinsics.checkNotNull(entries5, (String)"null cannot be cast to non-null type dorkbox.collections.LongMap.Entries<V of dorkbox.collections.LongMap?>");
            return entries5;
        }
        Entries<V> entries6 = this.entries2;
        Intrinsics.checkNotNull(entries6);
        entries6.reset();
        Entries<V> entries7 = this.entries2;
        Intrinsics.checkNotNull(entries7);
        entries7.setValid(true);
        Entries<V> entries8 = this.entries1;
        Intrinsics.checkNotNull(entries8);
        entries8.setValid(false);
        Entries<V> entries9 = this.entries2;
        Intrinsics.checkNotNull(entries9, (String)"null cannot be cast to non-null type dorkbox.collections.LongMap.Entries<V of dorkbox.collections.LongMap?>");
        return entries9;
    }

    @Override
    @NotNull
    public final Values<V> values() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.LongMap<V of dorkbox.collections.LongMap?>");
            return new Values(this);
        }
        if (this.values1 == null) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type dorkbox.collections.LongMap<V of dorkbox.collections.LongMap?>");
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        Values<V> values = this.values1;
        Intrinsics.checkNotNull(values);
        if (!values.getValid()) {
            Values<V> values2 = this.values1;
            Intrinsics.checkNotNull(values2);
            values2.reset();
            Values<V> values3 = this.values1;
            Intrinsics.checkNotNull(values3);
            values3.setValid(true);
            Values<V> values4 = this.values2;
            Intrinsics.checkNotNull(values4);
            values4.setValid(false);
            Values<V> values5 = this.values1;
            Intrinsics.checkNotNull(values5, (String)"null cannot be cast to non-null type dorkbox.collections.LongMap.Values<V of dorkbox.collections.LongMap?>");
            return values5;
        }
        Values<V> values6 = this.values2;
        Intrinsics.checkNotNull(values6);
        values6.reset();
        Values<V> values7 = this.values2;
        Intrinsics.checkNotNull(values7);
        values7.setValid(true);
        Values<V> values8 = this.values1;
        Intrinsics.checkNotNull(values8);
        values8.setValid(false);
        Values<V> values9 = this.values2;
        Intrinsics.checkNotNull(values9, (String)"null cannot be cast to non-null type dorkbox.collections.LongMap.Values<V of dorkbox.collections.LongMap?>");
        return values9;
    }

    @NotNull
    public final Keys keys() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new Keys((LongMap<?>)this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys((LongMap<?>)this);
            this.keys2 = new Keys((LongMap<?>)this);
        }
        Keys keys = this.keys1;
        Intrinsics.checkNotNull((Object)keys);
        if (!keys.getValid()) {
            Keys keys2 = this.keys1;
            Intrinsics.checkNotNull((Object)keys2);
            keys2.reset();
            Keys keys3 = this.keys1;
            Intrinsics.checkNotNull((Object)keys3);
            keys3.setValid(true);
            Keys keys4 = this.keys2;
            Intrinsics.checkNotNull((Object)keys4);
            keys4.setValid(false);
            Keys keys5 = this.keys1;
            Intrinsics.checkNotNull((Object)keys5);
            return keys5;
        }
        Keys keys6 = this.keys2;
        Intrinsics.checkNotNull((Object)keys6);
        keys6.reset();
        Keys keys7 = this.keys2;
        Intrinsics.checkNotNull((Object)keys7);
        keys7.setValid(true);
        Keys keys8 = this.keys1;
        Intrinsics.checkNotNull((Object)keys8);
        keys8.setValid(false);
        Keys keys9 = this.keys2;
        Intrinsics.checkNotNull((Object)keys9);
        return keys9;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u00022\u0018\u0012\u0006\u0012\u0004\u0018\u0001H\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u0004B\u0015\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0016J\u001e\u0010\u0010\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0019\u0010\u0015\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0096\u0002J\u001e\u0010\u0016\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\t\u0010\u0017\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0017\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u001aH\u0096\u0002J\u0011\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0096\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003H\u0016J\u001e\u0010\u001d\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016J\u001e\u0010\u001e\u001a\u00020\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u00030\u0012H\u0016R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Ldorkbox/collections/LongMap$Entries;", "V", "", "Ldorkbox/collections/LongMap$Entry;", "Ldorkbox/collections/LongMap$MapIterator;", "map", "Ldorkbox/collections/LongMap;", "(Ldorkbox/collections/LongMap;)V", "entry", "size", "", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "remove", "removeAll", "retainAll", "Collections"})
    @SourceDebugExtension(value={"SMAP\nLongMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongMap.kt\ndorkbox/collections/LongMap$Entries\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1034:1\n1855#2,2:1035\n1855#2,2:1037\n288#2,2:1039\n288#2,2:1042\n1855#2,2:1045\n13607#3:1041\n13608#3:1044\n*S KotlinDebug\n*F\n+ 1 LongMap.kt\ndorkbox/collections/LongMap$Entries\n*L\n750#1:1035,2\n771#1:1037,2\n792#1:1039,2\n802#1:1042,2\n813#1:1045,2\n800#1:1041\n800#1:1044\n*E\n"})
    public static final class Entries<V>
    extends MapIterator<V, Entry<V>>
    implements Set<Entry<V>>,
    KMutableSet {
        @NotNull
        private final Entry<V> entry;

        public Entries(@NotNull LongMap<V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
            this.entry = new Entry<V>(map);
        }

        @Override
        @NotNull
        public Entry<V> next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            long[] keyTable = this.getMap().getKeyTable();
            if (this.getNextIndex() == -1) {
                this.entry.setKey(0L);
                this.entry.setValue(this.getMap().getZeroValue());
            } else {
                this.entry.setKey(keyTable[this.getNextIndex()]);
                this.entry.setValue(this.getMap().getValueTable()[this.getNextIndex()]);
            }
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public boolean add(@NotNull Entry<V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            this.getMap().put(element.getKey(), element.getValue());
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Entry<V>> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean added = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry it = (Entry)element$iv;
                boolean bl = false;
                this.getMap().put(it.getKey(), it.getValue());
                added = true;
            }
            return added;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                long k = ((Number)((Map.Entry)entry).getKey()).longValue();
                Object v = ((Map.Entry)entry).getValue();
                if (Intrinsics.areEqual(this.getMap().get((Object)k), v)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(@NotNull Entry<V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            return Intrinsics.areEqual(this.getMap().get(element.getKey()), element.getValue());
        }

        @Override
        @NotNull
        public Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            if (this.getMap().getHasZeroValue()) {
                boolean hasElement;
                Object v0;
                block5: {
                    Iterable $this$firstOrNull$iv = elements;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Entry it = (Entry)element$iv;
                        boolean bl = false;
                        if (!(it.getKey() == 0L)) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                boolean bl = hasElement = v0 != null;
                if (hasElement) {
                    removed = this.getMap().remove((Object)0L) != null;
                }
            }
            long[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean hasElement;
                Object v2;
                long key;
                block6: {
                    long element$iv;
                    key = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    if (key == 0L) continue;
                    Iterable $this$firstOrNull$iv = elements;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Entry it = (Entry)element$iv2;
                        boolean bl2 = false;
                        if (!(it.getKey() == key)) continue;
                        v2 = element$iv2;
                        break block6;
                    }
                    v2 = null;
                }
                boolean bl = hasElement = v2 != null;
                if (hasElement) continue;
                removed = this.getMap().remove((Object)key) != null || removed;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                long k = ((Number)((Map.Entry)entry).getKey()).longValue();
                removed = this.getMap().remove((Object)k) != null || removed;
            }
            this.reset();
            return removed;
        }

        public boolean remove(@NotNull Entry<V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            boolean removed = this.getMap().remove(this.entry.getKey()) != null;
            this.reset();
            return removed;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0015\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\t\u0010\u0016\u001a\u00020\fH\u0096\u0002J\b\u0010\u0017\u001a\u00020\fH\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019H\u0096\u0002J\u000e\u0010\u001a\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u001d\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\u0016\u0010\u001e\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\u0011\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 \u00a2\u0006\u0002\u0010!R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Ldorkbox/collections/LongMap$Values;", "V", "", "Ldorkbox/collections/LongMap$MapIterator;", "map", "Ldorkbox/collections/LongMap;", "(Ldorkbox/collections/LongMap;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Object;", "remove", "removeAll", "retainAll", "toArray", "", "()[Ljava/lang/Object;", "Collections"})
    @SourceDebugExtension(value={"SMAP\nLongMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongMap.kt\ndorkbox/collections/LongMap$Values\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1034:1\n1855#2,2:1035\n1855#2,2:1039\n13607#3,2:1037\n*S KotlinDebug\n*F\n+ 1 LongMap.kt\ndorkbox/collections/LongMap$Values\n*L\n864#1:1035,2\n897#1:1039,2\n882#1:1037,2\n*E\n"})
    public static final class Values<V>
    extends MapIterator<V, V>
    implements Collection<V>,
    KMutableCollection {
        public Values(@NotNull LongMap<V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public V next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            V value = null;
            value = this.getNextIndex() == -1 ? this.getMap().getZeroValue() : this.getMap().getValueTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            V v = value;
            Intrinsics.checkNotNull(v);
            return v;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends V> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean add(V element) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (this.getMap().containsValue(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(Object element) {
            return this.getMap().containsValue(element);
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            long[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Object value;
                long element$iv;
                long key = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (key == 0L || CollectionsKt.contains((Iterable)elements, value = this.getMap().get((Object)key))) continue;
                this.getMap().remove((Object)key);
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Long key = this.getMap().findKey(it, false);
                if (key == null) continue;
                removed = this.getMap().remove(key) != null || removed;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean remove(Object element) {
            boolean removed = false;
            Long key = this.getMap().findKey(element, false);
            if (key != null) {
                removed = this.getMap().remove(key) != null;
            }
            this.reset();
            return removed;
        }

        @Override
        @NotNull
        public final V[] toArray() {
            int n = 0;
            int n2 = this.getMap().size_;
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.next(), (String)"null cannot be cast to non-null type kotlin.Any");
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0011\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0011\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0015\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\t\u0010\u0016\u001a\u00020\rH\u0096\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0096\u0002J\u000e\u0010\u001a\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Ldorkbox/collections/LongMap$Keys;", "", "", "Ldorkbox/collections/LongMap$MapIterator;", "", "map", "Ldorkbox/collections/LongMap;", "(Ldorkbox/collections/LongMap;)V", "size", "", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Long;", "remove", "removeAll", "retainAll", "toArray", "", "array", "Collections"})
    @SourceDebugExtension(value={"SMAP\nLongMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongMap.kt\ndorkbox/collections/LongMap$Keys\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1034:1\n1855#2,2:1035\n1855#2,2:1037\n1855#2,2:1041\n13607#3,2:1039\n*S KotlinDebug\n*F\n+ 1 LongMap.kt\ndorkbox/collections/LongMap$Keys\n*L\n950#1:1035,2\n966#1:1037,2\n997#1:1041,2\n984#1:1039,2\n*E\n"})
    public static final class Keys
    extends MapIterator<Object, Long>
    implements Set<Long>,
    KMutableSet {
        public Keys(@NotNull LongMap<?> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        @NotNull
        public Long next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            long key = this.getNextIndex() == -1 ? 0L : this.getMap().getKeyTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return key;
        }

        public int getSize() {
            return this.getMap().size_;
        }

        @Override
        public void clear() {
            this.getMap().clear();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Long> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean alreadyAdded = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long it = ((Number)element$iv).longValue();
                boolean bl = false;
                alreadyAdded = alreadyAdded || this.getMap().put(it, (Object)null) == null;
            }
            return alreadyAdded;
        }

        @Override
        public boolean add(long element) {
            return this.getMap().put(element, (Object)null) == null;
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().size_ == 0;
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long it = ((Number)element$iv).longValue();
                boolean bl = false;
                if (this.getMap().containsKey((Object)it)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(long element) {
            return this.getMap().containsKey((Object)element);
        }

        @Override
        @NotNull
        public Iterator<Long> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            long[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                long element$iv;
                long it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (elements.contains(it) || this.getMap().remove((Object)it) != null) continue;
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                long it = ((Number)element$iv).longValue();
                boolean bl = false;
                if (this.getMap().remove((Object)it) != null) continue;
                removed = true;
            }
            this.reset();
            return removed;
        }

        public boolean remove(long element) {
            return this.getMap().remove((Object)element) == null;
        }

        @NotNull
        public final long[] toArray() {
            long[] array = new long[this.getMap().size()];
            int index = 0;
            while (this.hasNext()) {
                array[index++] = this.next();
            }
            return array;
        }

        @NotNull
        public final long[] toArray(@NotNull long[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int index = 0;
            while (this.getHasNext()) {
                array[index++] = this.next();
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/LongMap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010'\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0011\u001a\u0004\u0018\u00018\u00012\b\u0010\u0014\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0007\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00018\u0001X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Ldorkbox/collections/LongMap$Entry;", "V", "", "", "map", "Ldorkbox/collections/LongMap;", "(Ldorkbox/collections/LongMap;)V", "key", "getKey", "()Ljava/lang/Long;", "setKey", "(J)V", "getMap", "()Ldorkbox/collections/LongMap;", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "toString", "", "Collections"})
    public static final class Entry<V>
    implements Map.Entry<Long, V>,
    KMutableMap.Entry {
        @NotNull
        private final LongMap<V> map;
        private long key;
        @Nullable
        private V value;

        public Entry(@NotNull LongMap<V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
        }

        @NotNull
        public final LongMap<V> getMap() {
            return this.map;
        }

        @Override
        @NotNull
        public Long getKey() {
            return this.key;
        }

        public void setKey(long l) {
            this.key = l;
        }

        @Override
        @Nullable
        public V getValue() {
            return this.value;
        }

        @Override
        public void setValue(@Nullable V v) {
            this.value = v;
        }

        @Override
        @Nullable
        public V setValue(@Nullable V newValue) {
            V oldValue = this.getValue();
            ((Map)this.map).put(this.getKey(), newValue);
            this.setValue(newValue);
            return oldValue;
        }

        @NotNull
        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000  *\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004:\u0001 B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0006\u0010\u001f\u001a\u00020\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006!"}, d2={"Ldorkbox/collections/LongMap$MapIterator;", "V", "I", "", "", "map", "Ldorkbox/collections/LongMap;", "(Ldorkbox/collections/LongMap;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "getMap", "()Ldorkbox/collections/LongMap;", "nextIndex", "getNextIndex", "setNextIndex", "valid", "getValid", "setValid", "findNextIndex", "", "remove", "reset", "Companion", "Collections"})
    @SourceDebugExtension(value={"SMAP\nLongMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongMap.kt\ndorkbox/collections/LongMap$MapIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1034:1\n1#2:1035\n*E\n"})
    public static abstract class MapIterator<V, I>
    implements Iterable<I>,
    Iterator<I>,
    KMappedMarker,
    KMutableIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final LongMap<V> map;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;
        private static final int INDEX_ILLEGAL = -2;
        public static final int INDEX_ZERO = -1;

        public MapIterator(@NotNull LongMap<V> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
            this.valid = true;
            this.reset();
        }

        @NotNull
        public final LongMap<V> getMap() {
            return this.map;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public final void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.getHasZeroValue()) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        public final void findNextIndex() {
            block1: {
                long[] keyTable = this.map.getKeyTable();
                int n = keyTable.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (keyTable[this.nextIndex] == 0L);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            int i = this.currentIndex;
            if (i == -1 && this.map.getHasZeroValue()) {
                this.map.setHasZeroValue(false);
                this.map.setZeroValue(null);
            } else {
                if (i < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                long[] keyTable = this.map.getKeyTable();
                V[] valueTable = this.map.getValueTable();
                int mask = this.map.getMask();
                int next = i + 1 & mask;
                long key = 0L;
                while (true) {
                    long l;
                    long it = l = keyTable[next];
                    boolean bl = false;
                    key = it;
                    if (l == 0L) break;
                    int placement = this.map.place(key);
                    if ((next - placement & mask) > (i - placement & mask)) {
                        keyTable[i] = key;
                        valueTable[i] = valueTable[next];
                        i = next;
                    }
                    next = next + 1 & mask;
                }
                keyTable[i] = 0L;
                valueTable[i] = null;
                if (i != this.currentIndex) {
                    this.nextIndex += -1;
                }
                this.currentIndex = -2;
                LongMap<V> longMap = this.map;
                int n = ((LongMap)longMap).size_;
                ((LongMap)longMap).size_ = n + -1;
            }
        }

        @Override
        public Iterator<I> iterator() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/collections/LongMap$MapIterator$Companion;", "", "()V", "INDEX_ILLEGAL", "", "INDEX_ZERO", "Collections"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

