/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app.objMod;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.MetaState;
import net.moonlightflower.wc3libs.bin.ObjMod;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.DataList;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.AbilCode;
import net.moonlightflower.wc3libs.dataTypes.app.AbilId;
import net.moonlightflower.wc3libs.dataTypes.app.DefType;
import net.moonlightflower.wc3libs.dataTypes.app.Icon;
import net.moonlightflower.wc3libs.dataTypes.app.ItemClass;
import net.moonlightflower.wc3libs.dataTypes.app.Model;
import net.moonlightflower.wc3libs.dataTypes.app.PathingRequire;
import net.moonlightflower.wc3libs.dataTypes.app.War3Bool;
import net.moonlightflower.wc3libs.dataTypes.app.War3Char;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.MetaFieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.app.objs.ItemSLK;

public class W3T
extends ObjMod<Item> {
    public static final File GAME_PATH = new File("war3map.w3t");
    public static final File SKIN_PATH = new File("war3mapSkin.w3t");
    public static final File CAMPAIGN_PATH = new File("war3campaign.w3t");

    public W3T(@Nonnull Wc3BinInputStream stream) throws IOException {
        super(stream);
    }

    public W3T(@Nonnull File file) throws Exception {
        super(file);
    }

    public W3T() {
    }

    @Nonnull
    public static W3T ofMapFile(@Nonnull File mapFile) throws IOException {
        return W3T.ofMapFile(W3T.class, mapFile);
    }

    @Override
    protected Item createObj(@Nonnull ObjId id, @Nullable ObjId baseId) {
        return new Item(id, baseId);
    }

    @Override
    @Nonnull
    protected Item createObj(@Nonnull Wc3BinInputStream stream, @Nonnull ObjMod.EncodingFormat format) throws BinStream.StreamException {
        return new Item(stream, format);
    }

    @Nonnull
    public W3T copy() {
        W3T other = new W3T();
        other.merge(this);
        return other;
    }

    @Override
    public Collection<File> getSLKs() {
        return Collections.singletonList(ItemSLK.GAME_PATH);
    }

    @Override
    public Collection<File> getNecessarySLKs() {
        return Collections.singletonList(ItemSLK.GAME_PATH);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull ObjMod.EncodingFormat format) throws BinStream.StreamException {
        super.write(stream, format);
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        super.write(stream);
    }

    public static class State<T extends DataType>
    extends MetaState<T> {
        public static final State<DataList<AbilId>> ABIL_ABILS = new State("iabi", new DataTypeInfo((Class<? extends DataType>)DataList.class, (Class<? extends DataType>)AbilId.class));
        public static final State<War3Int> ART_BUTTON_POS_X = new State<War3Int>("ubpx", War3Int.class);
        public static final State<War3Int> ART_BUTTON_POS_Y = new State<War3Int>("ubpy", War3Int.class);
        public static final State<War3Int> ART_COLOR_BLUE = new State<War3Int>("iclb", War3Int.class);
        public static final State<War3Int> ART_COLOR_GREEN = new State<War3Int>("iclg", War3Int.class);
        public static final State<War3Int> ART_COLOR_RED = new State<War3Int>("iclr", War3Int.class);
        public static final State<Icon> ART_ICON = new State<Icon>("iico", Icon.class);
        public static final State<Model> ART_MODEL = new State<Model>("ifil", Model.class);
        public static final State<War3Real> ART_SCALE = new State<War3Real>("isca", War3Real.class);
        public static final State<War3Real> ART_SELECTION_SCALE = new State<War3Real>("issc", War3Real.class);
        public static final State<DefType> COMBAT_ARMOR_TYPE = new State<DefType>("iarm", DefType.class);
        public static final State<War3Int> DATA_CHARGES = new State<War3Int>("iuse", War3Int.class);
        public static final State<ItemClass> DATA_CLASS = new State<ItemClass>("icla", ItemClass.class);
        public static final State<AbilCode> DATA_COOLDOWN_ID = new State<AbilCode>("icid", AbilCode.class);
        public static final State<War3Int> DATA_COST_GOLD = new State<War3Int>("igol", War3Int.class);
        public static final State<War3Int> DATA_COST_LUMBER = new State<War3Int>("ilum", War3Int.class);
        public static final State<War3Bool> DATA_DROPPABLE = new State<War3Bool>("idro", War3Bool.class);
        public static final State<War3Bool> DATA_DROPPED = new State<War3Bool>("idrp", War3Bool.class);
        public static final State<War3Bool> DATA_IGNORE_COOLDOWN = new State<War3Bool>("iicd", War3Bool.class);
        public static final State<War3Int> DATA_LEVEL = new State<War3Int>("ilev", War3Int.class);
        public static final State<War3Int> DATA_LEVEL_OLD = new State<War3Int>("ilvo", War3Int.class);
        public static final State<War3Int> DATA_LIFE = new State<War3Int>("ihtp", War3Int.class);
        public static final State<War3Bool> DATA_MORPHABLE = new State<War3Bool>("imor", War3Bool.class);
        public static final State<War3Bool> DATA_PAWNABLE = new State<War3Bool>("ipaw", War3Bool.class);
        public static final State<War3Bool> DATA_PERISHABLE = new State<War3Bool>("iper", War3Bool.class);
        public static final State<War3Bool> DATA_POWERUP = new State<War3Bool>("ipow", War3Bool.class);
        public static final State<War3Int> DATA_PRIO = new State<War3Int>("ipri", War3Int.class);
        public static final State<War3Bool> DATA_RANDOMED = new State<War3Bool>("iprn", War3Bool.class);
        public static final State<War3Bool> DATA_SELLABLE = new State<War3Bool>("isel", War3Bool.class);
        public static final State<War3Int> DATA_STOCK_MAX = new State<War3Int>("isto", War3Int.class);
        public static final State<War3Int> DATA_STOCK_REGEN = new State<War3Int>("istr", War3Int.class);
        public static final State<War3Int> DATA_STOCK_INITIAL = new State<War3Int>("isst", War3Int.class);
        public static final State<War3Bool> DATA_USABLE = new State<War3Bool>("iusa", War3Bool.class);
        public static final State<DataList<PathingRequire>> TECH_REQUIRES = new State("ureq", new DataTypeInfo((Class<? extends DataType>)DataList.class, (Class<? extends DataType>)PathingRequire.class));
        public static final State<DataList<War3Int>> TECH_REQUIRES_COUNT = new State("urqa", new DataTypeInfo((Class<? extends DataType>)DataList.class, (Class<? extends DataType>)War3Int.class));
        public static final State<War3String> TEXT_DESCRIPTION = new State<War3String>("ides", War3String.class);
        public static final State<War3Char> TEXT_HOTKEY = new State<War3Char>("uhot", War3Char.class);
        public static final State<War3String> TEXT_NAME = new State<War3String>("unam", War3String.class);
        public static final State<War3String> TEXT_TOOLTIP = new State<War3String>("utip", War3String.class);
        public static final State<War3String> TEXT_TOOLTIP_UBER = new State<War3String>("utub", War3String.class);

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
            this(idString, new DataTypeInfo((Class<? extends DataType>)type), defVal);
        }

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo) {
            this(idString, typeInfo, null);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type) {
            this(idString, new DataTypeInfo((Class<? extends DataType>)type), null);
        }
    }

    public static class Item
    extends ObjMod.Obj {
        public Item(@Nonnull Wc3BinInputStream stream, @Nonnull ObjMod.EncodingFormat format) throws BinStream.StreamException {
            super(stream, format);
        }

        public Item(@Nonnull ObjId id, @Nullable ObjId baseId) {
            super(id, baseId);
        }

        @Override
        public boolean isExtended() {
            return false;
        }

        @Override
        protected ObjMod.Obj copySpec() {
            return new Item(this.getId(), this.getBaseId());
        }

        public <T extends DataType> T get(@Nonnull State<T> state) {
            try {
                return state.tryCastVal(super.get((MetaFieldId)state.getFieldId()));
            }
            catch (DataTypeInfo.CastException castException) {
                return null;
            }
        }

        public <T extends DataType> void set(@Nonnull State<T> state, T val) {
            super.set((MetaFieldId)state.getFieldId(), val);
        }

        public <T extends DataType> void remove(@Nonnull State<T> state) {
            super.remove((MetaFieldId)state.getFieldId());
        }
    }
}

