/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.hex;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J,\u0010\u0019\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u001e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017J\u001e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00070\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldorkbox/hex/HexUtil;", "", "()V", "BYTE2CHAR", "", "BYTE2HEX", "", "", "[Ljava/lang/String;", "BYTE2HEX_PAD", "BYTEPADDING", "EMPTY_STRING", "HEXDUMP_ROWPREFIXES", "HEXDUMP_TABLE", "HEXPADDING", "NEWLINE", "kotlin.jvm.PlatformType", "appendHexDumpRowPrefix", "", "dump", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "row", "", "rowStartIndex", "appendPrettyHexDump", "array", "", "fromIndex", "length", "hexDump", "prettyHexDump", "HexUtilities"})
@SourceDebugExtension(value={"SMAP\nHexUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexUtil.kt\ndorkbox/hex/HexUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
public final class HexUtil {
    @NotNull
    public static final HexUtil INSTANCE;
    private static String NEWLINE;
    @NotNull
    private static String EMPTY_STRING;
    @NotNull
    private static final char[] BYTE2CHAR;
    @NotNull
    private static final char[] HEXDUMP_TABLE;
    @NotNull
    private static final String[] HEXPADDING;
    @NotNull
    private static final String[] HEXDUMP_ROWPREFIXES;
    @NotNull
    private static final String[] BYTE2HEX;
    @NotNull
    private static final String[] BYTEPADDING;
    @NotNull
    private static final String[] BYTE2HEX_PAD;

    private HexUtil() {
    }

    @NotNull
    public final String hexDump(@NotNull byte[] array, int fromIndex, int length) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (length == 0) {
            return "";
        }
        int endIndex = fromIndex + length;
        char[] buf = new char[length << 1];
        int srcIdx = fromIndex;
        int dstIdx = 0;
        while (srcIdx < endIndex) {
            System.arraycopy(HEXDUMP_TABLE, (array[srcIdx] & 0xFF) << 1, buf, dstIdx, 2);
            ++srcIdx;
            dstIdx += 2;
        }
        return new String(buf);
    }

    @NotNull
    public final String prettyHexDump(@NotNull byte[] array, int fromIndex, int length) {
        String string;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (length == 0) {
            string = EMPTY_STRING;
        } else {
            int rows = length / 16 + ((length & 0xF) == 0 ? 0 : 1) + 4;
            StringBuilder buf = new StringBuilder(rows * 80);
            this.appendPrettyHexDump(buf, array, fromIndex, length);
            String string2 = buf.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            val rows =\u2026 buf.toString()\n        }");
        }
        return string;
    }

    private final void appendPrettyHexDump(StringBuilder dump, byte[] array, int fromIndex, int length) {
        if (!(0 <= fromIndex ? fromIndex <= length : false)) {
            boolean $i$a$-require-HexUtil$appendPrettyHexDump$22 = false;
            String $i$a$-require-HexUtil$appendPrettyHexDump$22 = "expected: 0 <= fromIndex(" + fromIndex + ") <= length(" + length + ')';
            throw new IllegalArgumentException($i$a$-require-HexUtil$appendPrettyHexDump$22.toString());
        }
        if (length == 0) {
            return;
        }
        dump.append("         +-------------------------------------------------+" + NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + NEWLINE + "+--------+-------------------------------------------------+----------------+");
        int fullRows = length >>> 4;
        int remainder = length & 0xF;
        for (int row = 0; row < fullRows; ++row) {
            int j;
            int rowStartIndex = (row << 4) + fromIndex;
            this.appendHexDumpRowPrefix(dump, row, rowStartIndex);
            int rowEndIndex = rowStartIndex + 16;
            for (j = rowStartIndex; j < rowEndIndex; ++j) {
                dump.append(BYTE2HEX[(short)(array[j] & 0xFF)]);
            }
            dump.append(" |");
            for (j = rowStartIndex; j < rowEndIndex; ++j) {
                dump.append(BYTE2CHAR[(short)(array[j] & 0xFF)]);
            }
            dump.append('|');
        }
        if (remainder != 0) {
            int j;
            int rowStartIndex = (fullRows << 4) + fromIndex;
            this.appendHexDumpRowPrefix(dump, fullRows, rowStartIndex);
            int rowEndIndex = rowStartIndex + remainder;
            for (j = rowStartIndex; j < rowEndIndex; ++j) {
                dump.append(BYTE2HEX[(short)(array[j] & 0xFF)]);
            }
            dump.append(HEXPADDING[remainder]);
            dump.append(" |");
            for (j = rowStartIndex; j < rowEndIndex; ++j) {
                dump.append(BYTE2CHAR[(short)(array[j] & 0xFF)]);
            }
            dump.append(BYTEPADDING[remainder]);
            dump.append('|');
        }
        dump.append(NEWLINE + "+--------+-------------------------------------------------+----------------+");
    }

    private final void appendHexDumpRowPrefix(StringBuilder dump, int row, int rowStartIndex) {
        if (row < HEXDUMP_ROWPREFIXES.length) {
            dump.append(HEXDUMP_ROWPREFIXES[row]);
        } else {
            dump.append(NEWLINE);
            dump.append(Long.toHexString((long)rowStartIndex & 0xFFFFFFFFL | 0x100000000L));
            dump.setCharAt(dump.length() - 9, '|');
            dump.append('|');
        }
    }

    static {
        int j;
        StringBuilder buf;
        int i;
        INSTANCE = new HexUtil();
        NEWLINE = System.getProperty("line.separator", "\n");
        EMPTY_STRING = "";
        BYTE2CHAR = new char[256];
        HEXDUMP_TABLE = new char[1024];
        HEXPADDING = new String[16];
        HEXDUMP_ROWPREFIXES = new String[4096];
        BYTE2HEX = new String[256];
        BYTEPADDING = new String[16];
        BYTE2HEX_PAD = new String[256];
        int n = BYTE2HEX_PAD.length;
        for (int i2 = 0; i2 < n; ++i2) {
            String str = Integer.toHexString(i2);
            HexUtil.BYTE2HEX_PAD[i2] = i2 > 15 ? str : '0' + str;
        }
        char[] cArray = "0123456789abcdef".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] DIGITS = cArray;
        for (i = 0; i < 256; ++i) {
            HexUtil.HEXDUMP_TABLE[i << 1] = DIGITS[i >>> 4 & 0xF];
            HexUtil.HEXDUMP_TABLE[(i << 1) + 1] = DIGITS[i & 0xF];
        }
        i = 0;
        for (i = 0; i < HEXPADDING.length; ++i) {
            int padding = HEXPADDING.length - i;
            buf = new StringBuilder(padding * 3);
            for (j = 0; j < padding; ++j) {
                buf.append("   ");
            }
            HexUtil.HEXPADDING[i] = buf.toString();
        }
        for (i = 0; i < HEXDUMP_ROWPREFIXES.length; ++i) {
            StringBuilder buf2 = new StringBuilder(12);
            buf2.append(NEWLINE);
            buf2.append(Long.toHexString((long)(i << 4) & 0xFFFFFFFFL | 0x100000000L));
            buf2.setCharAt(buf2.length() - 9, '|');
            buf2.append('|');
            HexUtil.HEXDUMP_ROWPREFIXES[i] = buf2.toString();
        }
        for (i = 0; i < BYTE2HEX.length; ++i) {
            HexUtil.BYTE2HEX[i] = ' ' + BYTE2HEX_PAD[i & 0xFF];
        }
        for (i = 0; i < BYTEPADDING.length; ++i) {
            int padding = BYTEPADDING.length - i;
            buf = new StringBuilder(padding);
            for (j = 0; j < padding; ++j) {
                buf.append(' ');
            }
            HexUtil.BYTEPADDING[i] = buf.toString();
        }
        for (i = 0; i < BYTE2CHAR.length; ++i) {
            HexUtil.BYTE2CHAR[i] = i <= 31 || i >= 127 ? 46 : (char)i;
        }
    }
}

