/*
 * Decompiled with CFR 0.152.
 */
package file;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import config.WurstProjectConfigData;
import file.YamlHelper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lfile/YamlHelper;", "", "()V", "log", "Lmu/KLogger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "dumpProjectConfig", "", "configData", "Lconfig/WurstProjectConfigData;", "loadProjectConfig", "path", "Ljava/nio/file/Path;", "YamlException", "WurstSetup"})
public final class YamlHelper {
    @NotNull
    public static final YamlHelper INSTANCE = new YamlHelper();
    @NotNull
    private static ObjectMapper mapper;
    @NotNull
    private static final KLogger log;

    private YamlHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final WurstProjectConfigData loadProjectConfig(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Closeable closeable = Files.newBufferedReader(path);
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            try {
                Object object = mapper.readValue((Reader)it, WurstProjectConfigData.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                WurstProjectConfigData wurstProjectConfigData = (WurstProjectConfigData)object;
                return wurstProjectConfigData;
            }
            catch (Exception e) {
                try {
                    log.error("The project's wurst.build file could not be read. Input malformed or corrupt.");
                    log.trace("Exception: ", (Throwable)e);
                    throw new YamlException("The project's wurst.build file could not be read. Input malformed or corrupt.");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final String dumpProjectConfig(@NotNull WurstProjectConfigData configData) {
        Intrinsics.checkNotNullParameter((Object)configData, (String)"configData");
        String string = mapper.writeValueAsString((Object)configData);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    static {
        log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
        YAMLFactory yamlFactory = new YAMLFactory();
        yamlFactory.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        yamlFactory.enable(JsonParser.Feature.ALLOW_MISSING_VALUES);
        mapper = new ObjectMapper((JsonFactory)yamlFactory);
        mapper.registerModule((Module)new KotlinModule(0, false, false, false, null, false, 63, null));
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lfile/YamlHelper$YamlException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "msg", "", "(Ljava/lang/String;)V", "WurstSetup"})
    public static final class YamlException
    extends RuntimeException {
        public YamlException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
        }
    }
}

