/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprs;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImLExpr;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStatementExpr;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeVar;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVars;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imoptimizer.Replacer;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.imtranslation.StackTraceInjector2;
import de.peeeq.wurstscript.types.TypesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiArrayEliminator {
    private final ImProg prog;
    private final HashMap<ImVar, GetSetPair> getSetMap = Maps.newHashMap();
    private final ImTranslator translator;
    private final boolean generateStacktraces;
    private final Replacer replacer = new Replacer();

    public MultiArrayEliminator(ImProg imProg, ImTranslator tr, boolean generateStacktraces) {
        this.prog = imProg;
        this.translator = tr;
        this.generateStacktraces = generateStacktraces;
    }

    public void run() {
        ArrayList oldVars = Lists.newArrayList();
        ArrayList newVars = Lists.newArrayList();
        for (ImVar v : this.prog.getGlobals()) {
            if (!(v.getType() instanceof ImArrayTypeMulti)) continue;
            ImArrayTypeMulti type = (ImArrayTypeMulti)v.getType();
            List<Integer> arraySize = type.getArraySize();
            if (arraySize.size() == 2) {
                oldVars.add(v);
                int size0 = arraySize.get(0);
                ArrayList newArrays = Lists.newArrayList();
                for (int i = 0; i < size0; ++i) {
                    ImVar newVar = JassIm.ImVar(v.getTrace(), JassIm.ImArrayType(type.getEntryType()), v.getName() + "_" + i, false);
                    newArrays.add(newVar);
                }
                ImFunction setFunc = this.generateSetFunc(v, newArrays);
                ImFunction getFunc = this.generateGetFunc(v, newArrays);
                this.prog.getFunctions().add(setFunc);
                this.prog.getFunctions().add(getFunc);
                this.getSetMap.put(v, new GetSetPair(getFunc, setFunc));
                newVars.addAll(newArrays);
                continue;
            }
            if (arraySize.size() == 1) {
                v.setType(JassIm.ImArrayType(type.getEntryType()));
                continue;
            }
            throw new CompileError(v, "Unsupported array sizes " + arraySize);
        }
        for (ImFunction function : this.prog.getFunctions()) {
            for (ImVar v : function.getLocals()) {
                if (!(v.getType() instanceof ImArrayTypeMulti)) continue;
                ImArrayTypeMulti type = (ImArrayTypeMulti)v.getType();
                List<Integer> arraySize = type.getArraySize();
                if (arraySize.size() == 1) {
                    v.setType(JassIm.ImArrayType(type.getEntryType()));
                    continue;
                }
                throw new CompileError(v, "Unsupported array sizes " + arraySize);
            }
        }
        this.replaceVars(this.prog, this.getSetMap);
        this.prog.getGlobals().removeAll((Collection)oldVars);
        this.prog.getGlobals().addAll((Collection)newVars);
    }

    private void replaceVars(Element e, Map<ImVar, GetSetPair> oldToNewVar) {
        ImVarArrayAccess am;
        if (e instanceof ImSet) {
            ImVarArrayAccess va;
            ImSet set = (ImSet)e;
            ImStmts stmts = JassIm.ImStmts(new ImStmt[0]);
            ImLExpr left = set.getLeft();
            while (left instanceof ImStatementExpr) {
                ImStatementExpr se = (ImStatementExpr)left;
                stmts.addAll((Collection)se.getStatements().removeAll());
                left = (ImLExpr)se.getExpr();
                left.setParent(null);
            }
            if (left != set.getLeft()) {
                set.setLeft(left);
                for (ImStmt s : stmts) {
                    this.replaceVars(s, oldToNewVar);
                }
                Element setParent = set.getParent();
                set.setParent(null);
                stmts.add(set);
                this.replacer.replaceInParent(setParent, set, ImHelper.statementExprVoid(stmts));
            }
            if (left instanceof ImVarArrayAccess && (va = (ImVarArrayAccess)left).getIndexes().size() > 1 && this.getSetMap.containsKey(va.getVar())) {
                this.replaceVars(va.getIndexes(), oldToNewVar);
                this.replaceVars(set.getRight(), oldToNewVar);
                ImExprs args = JassIm.ImExprs(new ImExpr[0]);
                for (ImExpr val : va.getIndexes()) {
                    args.add(val.copy());
                }
                args.add(set.getRight().copy());
                if (this.generateStacktraces) {
                    args.add(JassIm.ImStringVal("when writing array " + va.getVar().getName() + StackTraceInjector2.getCallPos(va.getTrace().attrSource())));
                }
                this.replacer.replace(set, JassIm.ImFunctionCall(set.getTrace(), this.getSetMap.get((Object)va.getVar()).setter, JassIm.ImTypeArguments(new ImTypeArgument[0]), args, false, CallType.NORMAL));
                return;
            }
        }
        for (int i = 0; i < e.size(); ++i) {
            this.replaceVars(e.get(i), oldToNewVar);
        }
        if (e instanceof ImVarArrayAccess && (am = (ImVarArrayAccess)e).getIndexes().size() > 1) {
            if (am.isUsedAsLValue()) {
                throw new CompileError(am.attrTrace().attrSource(), "Invalid multi array access " + e);
            }
            ImExprs args = JassIm.ImExprs(new ImExpr[0]);
            for (ImExpr val : am.getIndexes()) {
                args.add(val.copy());
            }
            if (this.generateStacktraces) {
                args.add(JassIm.ImStringVal("when reading array " + am.getVar().getName() + " in " + StackTraceInjector2.getCallPos(am.getTrace().attrSource())));
            }
            if (this.getSetMap.containsKey(am.getVar())) {
                this.replacer.replace(am, JassIm.ImFunctionCall(am.attrTrace(), this.getSetMap.get((Object)am.getVar()).getter, JassIm.ImTypeArguments(new ImTypeArgument[0]), args, false, CallType.NORMAL));
            }
        }
    }

    private ImFunction generateSetFunc(ImVar aVar, List<ImVar> newArrays) {
        ImArrayTypeMulti mtype = (ImArrayTypeMulti)aVar.getType();
        ImVars locals = JassIm.ImVars(new ImVar[0]);
        ImVar instanceId = JassIm.ImVar(aVar.getTrace(), TypesHelper.imInt(), "instanceId", false);
        ImVar arrayIndex = JassIm.ImVar(aVar.getTrace(), TypesHelper.imInt(), "arrayIndex", false);
        ImVar value = JassIm.ImVar(aVar.getTrace(), mtype.getEntryType(), "value", false);
        ImFunctionCall error = this.imError(aVar, "Index out of Bounds");
        ImStmts thenBlock = JassIm.ImStmts(error);
        ImStmts elseBlock = JassIm.ImStmts(new ImStmt[0]);
        this.generateBinSearchSet(elseBlock, instanceId, arrayIndex, value, newArrays, 0, newArrays.size() - 1, aVar.getTrace());
        ImOperatorCall highCond = JassIm.ImOperatorCall(WurstOperator.GREATER_EQ, JassIm.ImExprs(JassIm.ImVarAccess(arrayIndex), JassIm.ImIntVal(mtype.getArraySize().get(0))));
        ImOperatorCall lowCond = JassIm.ImOperatorCall(WurstOperator.LESS, JassIm.ImExprs(JassIm.ImVarAccess(arrayIndex), JassIm.ImIntVal(0)));
        ImOperatorCall condition = JassIm.ImOperatorCall(WurstOperator.OR, JassIm.ImExprs(lowCond, highCond));
        ImStmts body = JassIm.ImStmts(JassIm.ImIf(aVar.getTrace(), condition, thenBlock, elseBlock));
        ImFunction setFunc = JassIm.ImFunction(aVar.getTrace(), aVar.getName() + "_set", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(instanceId, arrayIndex, value), JassIm.ImVoid(), locals, body, Lists.newArrayList());
        if (this.generateStacktraces) {
            ImVar stackPos = JassIm.ImVar(aVar.getTrace(), TypesHelper.imString(), "stackPos", false);
            setFunc.getParameters().add(stackPos);
            if (error.getFunc().getParameters().size() == 2) {
                error.getArguments().add(JassIm.ImVarAccess(stackPos));
            }
        }
        return setFunc;
    }

    private ImFunctionCall imError(ImVar aVar, String msg) {
        return this.translator.imError(aVar.getTrace(), JassIm.ImStringVal(msg));
    }

    private void generateBinSearchSet(ImStmts stmts, ImVar indexVar1, ImVar indexVar2, ImVar value, List<ImVar> newArrays, int start, int end, de.peeeq.wurstscript.ast.Element trace) {
        if (start == end) {
            stmts.add(JassIm.ImSet(value.getTrace(), JassIm.ImVarArrayAccess(trace, newArrays.get(start), JassIm.ImExprs(JassIm.ImVarAccess(indexVar1))), JassIm.ImVarAccess(value)));
        } else {
            int mid = (start + end) / 2;
            ImStmts thenBlock = JassIm.ImStmts(new ImStmt[0]);
            ImStmts elseBlock = JassIm.ImStmts(new ImStmt[0]);
            ImOperatorCall condition = JassIm.ImOperatorCall(WurstOperator.LESS_EQ, JassIm.ImExprs(JassIm.ImVarAccess(indexVar2), JassIm.ImIntVal(mid)));
            stmts.add(JassIm.ImIf(value.getTrace(), condition, thenBlock, elseBlock));
            this.generateBinSearchSet(thenBlock, indexVar1, indexVar2, value, newArrays, start, mid, trace);
            this.generateBinSearchSet(elseBlock, indexVar1, indexVar2, value, newArrays, mid + 1, end, trace);
        }
    }

    private ImFunction generateGetFunc(ImVar aVar, List<ImVar> newArrays) {
        ImArrayTypeMulti mtype = (ImArrayTypeMulti)aVar.getType();
        ImVar returnVal = JassIm.ImVar(aVar.getTrace(), mtype.getEntryType(), "returnVal", false);
        ImVars locals = JassIm.ImVars(returnVal);
        ImVar instanceId = JassIm.ImVar(aVar.getTrace(), TypesHelper.imInt(), "index1", false);
        ImVar arrayIndex = JassIm.ImVar(aVar.getTrace(), TypesHelper.imInt(), "index2", false);
        ImFunctionCall error = this.imError(aVar, "Index out of Bounds");
        ImStmts thenBlock = JassIm.ImStmts(error);
        ImStmts elseBlock = JassIm.ImStmts(new ImStmt[0]);
        this.generateBinSearchGet(elseBlock, instanceId, arrayIndex, returnVal, newArrays, 0, newArrays.size() - 1, aVar.getTrace());
        ImOperatorCall highCond = JassIm.ImOperatorCall(WurstOperator.GREATER_EQ, JassIm.ImExprs(JassIm.ImVarAccess(arrayIndex), JassIm.ImIntVal(mtype.getArraySize().get(0))));
        ImOperatorCall lowCond = JassIm.ImOperatorCall(WurstOperator.LESS, JassIm.ImExprs(JassIm.ImVarAccess(arrayIndex), JassIm.ImIntVal(0)));
        ImOperatorCall condition = JassIm.ImOperatorCall(WurstOperator.OR, JassIm.ImExprs(lowCond, highCond));
        ImStmts body = JassIm.ImStmts(JassIm.ImIf(aVar.getTrace(), condition, thenBlock, elseBlock), JassIm.ImReturn(returnVal.getTrace(), JassIm.ImVarAccess(returnVal)));
        ImFunction getFunc = JassIm.ImFunction(aVar.getTrace(), aVar.getName() + "_get", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(instanceId, arrayIndex), mtype.getEntryType(), locals, body, Lists.newArrayList());
        if (this.generateStacktraces) {
            ImVar stackPos = JassIm.ImVar(aVar.getTrace(), TypesHelper.imString(), "stackPos", false);
            getFunc.getParameters().add(stackPos);
            if (error.getFunc().getParameters().size() == 2) {
                error.getArguments().add(JassIm.ImVarAccess(stackPos));
            }
        }
        return getFunc;
    }

    private void generateBinSearchGet(ImStmts stmts, ImVar indexVar1, ImVar indexVar2, ImVar resultVar, List<ImVar> newArrays, int start, int end, de.peeeq.wurstscript.ast.Element trace) {
        if (start == end) {
            stmts.add(JassIm.ImSet(resultVar.getTrace(), JassIm.ImVarAccess(resultVar), JassIm.ImVarArrayAccess(trace, newArrays.get(start), JassIm.ImExprs(JassIm.ImVarAccess(indexVar1)))));
        } else {
            int mid = (start + end) / 2;
            ImStmts thenBlock = JassIm.ImStmts(new ImStmt[0]);
            ImStmts elseBlock = JassIm.ImStmts(new ImStmt[0]);
            ImOperatorCall condition = JassIm.ImOperatorCall(WurstOperator.LESS_EQ, JassIm.ImExprs(JassIm.ImVarAccess(indexVar2), JassIm.ImIntVal(mid)));
            stmts.add(JassIm.ImIf(resultVar.getTrace(), condition, thenBlock, elseBlock));
            this.generateBinSearchGet(thenBlock, indexVar1, indexVar2, resultVar, newArrays, start, mid, trace);
            this.generateBinSearchGet(elseBlock, indexVar1, indexVar2, resultVar, newArrays, mid + 1, end, trace);
        }
    }

    private static class GetSetPair {
        ImFunction getter;
        ImFunction setter;

        public GetSetPair(ImFunction get, ImFunction set) {
            this.getter = get;
            this.setter = set;
        }
    }
}

