/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.Lists;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImFuncRef;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.WurstTypeCode;
import java.util.ArrayList;
import java.util.HashMap;

public class FuncRefRemover {
    private final ImProg prog;
    private final ImTranslator tr;

    public FuncRefRemover(ImProg imProg, ImTranslator tr) {
        this.prog = imProg;
        this.tr = tr;
    }

    public void run() {
        final ArrayList funcRefs = Lists.newArrayList();
        this.prog.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImFuncRef imFuncRef) {
                super.visit(imFuncRef);
                funcRefs.add(imFuncRef);
            }
        });
        HashMap<ImFunction, ImVar> refs = new HashMap<ImFunction, ImVar>();
        for (ImFuncRef fr : funcRefs) {
            ImVar g;
            ImFunction func = fr.getFunc();
            if (func.isBj()) continue;
            if (refs.containsKey(func)) {
                g = (ImVar)refs.get(func);
            } else {
                g = JassIm.ImVar(fr.attrTrace(), WurstTypeCode.instance().imTranslateType(this.tr), "ref_function_" + func.getName(), false);
                refs.put(func, g);
                this.tr.addGlobalWithInitalizer(g, fr.copy());
            }
            fr.replaceBy(JassIm.ImVarAccess(g));
        }
    }
}

