/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.jass;

import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.antlr.JassParser;
import de.peeeq.wurstscript.ast.Arguments;
import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprEmpty;
import de.peeeq.wurstscript.ast.ExprFuncRef;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.Identifier;
import de.peeeq.wurstscript.ast.Indexes;
import de.peeeq.wurstscript.ast.JassGlobalBlock;
import de.peeeq.wurstscript.ast.JassToplevelDeclaration;
import de.peeeq.wurstscript.ast.JassToplevelDeclarations;
import de.peeeq.wurstscript.ast.Modifier;
import de.peeeq.wurstscript.ast.Modifiers;
import de.peeeq.wurstscript.ast.NameRef;
import de.peeeq.wurstscript.ast.OptExpr;
import de.peeeq.wurstscript.ast.OptTypeExpr;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.TypeParamDefs;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WParameters;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.ast.WStatements;
import de.peeeq.wurstscript.attributes.CompilationUnitInfo;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.utils.LineOffsets;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.jdt.annotation.Nullable;

public class AntlrJassParseTreeTransformer {
    private final String file;
    private final ErrorHandler cuErrorHandler;
    private final LineOffsets lineOffsets;

    public AntlrJassParseTreeTransformer(String file, ErrorHandler cuErrorHandler, LineOffsets lineOffsets) {
        this.file = file;
        this.cuErrorHandler = cuErrorHandler;
        this.lineOffsets = lineOffsets;
    }

    public CompilationUnit transform(JassParser.CompilationUnitContext cu) {
        JassToplevelDeclarations jassDecls = Ast.JassToplevelDeclarations(new JassToplevelDeclaration[0]);
        try {
            for (JassParser.JassTopLevelDeclarationContext decl : cu.decls) {
                jassDecls.add(this.transformJassToplevelDecl(decl));
            }
        }
        catch (CompileError e) {
            this.cuErrorHandler.sendError(e);
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return Ast.CompilationUnit(new CompilationUnitInfo(this.cuErrorHandler), jassDecls, Ast.WPackages(new WPackage[0]));
    }

    private JassToplevelDeclaration transformJassToplevelDecl(JassParser.JassTopLevelDeclarationContext d) {
        if (d.jassFuncDef() != null) {
            return this.transformJassFuncDef(d.jassFuncDef());
        }
        if (d.jassGlobalsBlock() != null) {
            return this.transformJassGlobalsBlock(d.jassGlobalsBlock());
        }
        if (d.jassNativeDecl() != null) {
            return this.transformJassNativeDecl(d.jassNativeDecl());
        }
        if (d.jassTypeDecl() != null) {
            return this.transformJassTypeDecl(d.jassTypeDecl());
        }
        throw this.error(d, "unhandled case: " + this.text(d));
    }

    private String text(@Nullable Token t) {
        if (t == null) {
            return "";
        }
        return t.getText();
    }

    private Identifier text(@Nullable ParserRuleContext c) {
        if (c == null) {
            return Ast.Identifier(new WPos(this.file, this.lineOffsets, 1, 0), "");
        }
        return Ast.Identifier(this.source(c), c.getText());
    }

    private JassToplevelDeclaration transformJassTypeDecl(JassParser.JassTypeDeclContext t) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        Identifier name = Ast.Identifier(this.source(t.name), t.name.getText());
        OptTypeExpr optTyp = this.transformOptionalType(t.jassTypeExpr());
        return Ast.NativeType(this.source(t), modifiers, name, optTyp);
    }

    private JassToplevelDeclaration transformJassNativeDecl(JassParser.JassNativeDeclContext n) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        FuncSig sig = this.transformFuncSig(n.jassFuncSignature());
        return Ast.NativeFunc(this.source(n), modifiers, sig.name, sig.formalParameters, sig.returnType);
    }

    private JassToplevelDeclaration transformJassGlobalsBlock(JassParser.JassGlobalsBlockContext g) {
        JassGlobalBlock result = Ast.JassGlobalBlock(new GlobalVarDef[0]);
        for (JassParser.JassGlobalDeclContext v : g.jassGlobalDecl()) {
            Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
            if (v.constant != null) {
                modifiers.add(Ast.ModConstant(this.source(v.constant)));
            }
            OptTypeExpr optTyp = this.transformOptionalType(v.jassTypeExpr());
            Identifier name = Ast.Identifier(this.source(v.name), v.name.getText());
            OptExpr initialExpr = this.transformOptionalExpr(v.initial);
            result.add(Ast.GlobalVarDef(this.source(v), modifiers, optTyp, name, initialExpr));
        }
        return result;
    }

    private JassToplevelDeclaration transformJassFuncDef(JassParser.JassFuncDefContext f) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        FuncSig sig = this.transformFuncSig(f.jassFuncSignature());
        WStatements body = this.transformJassLocals(f.jassLocals);
        body.addAll((Collection)this.transformJassStatements(f.jassStatements()).removeAll());
        return Ast.FuncDef(this.source(f), modifiers, sig.name, sig.typeParams, sig.formalParameters, sig.returnType, body);
    }

    private WStatements transformJassLocals(List<JassParser.JassLocalContext> jassLocals) {
        WStatements result = Ast.WStatements(new WStatement[0]);
        for (JassParser.JassLocalContext l : jassLocals) {
            Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
            OptTypeExpr optTyp = this.transformOptionalType(l.jassTypeExpr());
            Identifier name = Ast.Identifier(this.source(l.name), l.name.getText());
            OptExpr initialExpr = this.transformOptionalExpr(l.initial);
            result.add(Ast.LocalVarDef(this.source(l), modifiers, optTyp, name, initialExpr));
        }
        return result;
    }

    private WStatements transformJassStatements(JassParser.JassStatementsContext stmts) {
        WStatements result = Ast.WStatements(new WStatement[0]);
        for (JassParser.JassStatementContext s : stmts.jassStatement()) {
            result.add(this.transformJassStatement(s));
        }
        return result;
    }

    private WStatement transformJassStatement(JassParser.JassStatementContext s) {
        if (s.jassStatementCall() != null) {
            return this.transformJassStatementCall(s.jassStatementCall());
        }
        if (s.jassStatementExithwhen() != null) {
            return this.transformJassStatementExitwhen(s.jassStatementExithwhen());
        }
        if (s.jassStatementIf() != null) {
            return this.transformJassStatementIf(s.jassStatementIf());
        }
        if (s.jassStatementLoop() != null) {
            return this.transformJassStatementLoop(s.jassStatementLoop());
        }
        if (s.jassStatementReturn() != null) {
            return this.transformJassStatementReturn(s.jassStatementReturn());
        }
        if (s.jassStatementSet() != null) {
            return this.transformJassStatementSet(s.jassStatementSet());
        }
        throw this.error(s, "unhandled case: " + this.text(s));
    }

    private WStatement transformJassStatementSet(JassParser.JassStatementSetContext s) {
        return Ast.StmtSet(this.source(s), this.transformExprVarAccess(s.left), this.transformExpr(s.right));
    }

    private WStatement transformJassStatementReturn(JassParser.JassStatementReturnContext s) {
        return Ast.StmtReturn(this.source(s), this.transformOptionalExpr(s.jassExpr()));
    }

    private WStatement transformJassStatementLoop(JassParser.JassStatementLoopContext s) {
        return Ast.StmtLoop(this.source(s), this.transformJassStatements(s.jassStatements()));
    }

    private WStatement transformJassStatementIf(JassParser.JassStatementIfContext s) {
        WStatements thenBlock = this.transformJassStatements(s.thenStatements);
        WStatements elseBlock = this.transformJassElseIfs(s.jassElseIfs());
        return Ast.StmtIf(this.source(s), this.transformExpr(s.cond), thenBlock, elseBlock, !this.isEndif(s.jassElseIfs()));
    }

    private boolean isEndif(JassParser.JassElseIfsContext s) {
        return s.ENDIF() != null;
    }

    private WStatements transformJassElseIfs(JassParser.JassElseIfsContext s) {
        if (s == null) {
            return Ast.WStatements(new WStatement[0]);
        }
        if (s.cond != null) {
            return Ast.WStatements(Ast.StmtIf(this.source(s), this.transformExpr(s.cond), this.transformJassStatements(s.thenStatements), this.transformJassElseIfs(s.jassElseIfs()), !this.isEndif(s.jassElseIfs())));
        }
        if (s.elseStmts != null) {
            return this.transformJassStatements(s.elseStmts);
        }
        return Ast.WStatements(new WStatement[0]);
    }

    private WStatement transformJassStatementExitwhen(JassParser.JassStatementExithwhenContext s) {
        return Ast.StmtExitwhen(this.source(s), this.transformExpr(s.cond));
    }

    private WStatement transformJassStatementCall(JassParser.JassStatementCallContext s) {
        return this.transformFunctionCall(s.exprFunctionCall());
    }

    private Indexes transformIndexes(JassParser.IndexesContext i) {
        Indexes result = Ast.Indexes(new Expr[0]);
        result.add(this.transformExpr(i.jassExpr()));
        return result;
    }

    private NameRef transformExprVarAccess(JassParser.ExprVarAccessContext e) {
        if (e.indexes() == null || e.indexes().isEmpty()) {
            return Ast.ExprVarAccess(this.source(e), Ast.Identifier(this.source(e.varname), e.varname.getText()));
        }
        return Ast.ExprVarArrayAccess(this.source(e), Ast.Identifier(this.source(e.varname), e.varname.getText()), this.transformIndexes(e.indexes()));
    }

    private ExprFunctionCall transformFunctionCall(JassParser.ExprFunctionCallContext c) {
        return Ast.ExprFunctionCall(this.source(c), Ast.Identifier(this.source(c.funcName), c.funcName.getText()), Ast.TypeExprList(new TypeExpr[0]), this.transformExprs(c.argumentList().exprList()));
    }

    private OptExpr transformOptionalExpr(JassParser.JassExprContext e) {
        if (e == null) {
            return Ast.NoExpr();
        }
        Expr r = this.transformExpr(e);
        if (r instanceof ExprEmpty) {
            return Ast.NoExpr();
        }
        return r;
    }

    private Arguments transformExprs(JassParser.ExprListContext es) {
        Arguments result = Ast.Arguments(new Expr[0]);
        if (es != null) {
            for (JassParser.JassExprContext e : es.exprs) {
                result.add(this.transformExpr(e));
            }
        }
        if (result.size() == 1 && result.get(0) instanceof ExprEmpty) {
            result.clear();
        }
        return result;
    }

    private Expr transformExpr(JassParser.JassExprContext e) {
        ParseTree right;
        WPos source = this.source(e);
        if (e.jassExprPrimary() != null) {
            return this.transformExprPrimary(e.jassExprPrimary());
        }
        if (e.left != null && e.right != null && e.op != null) {
            return Ast.ExprBinary(source, this.transformExpr(e.left), this.transformOp(e.op), this.transformExpr(e.right));
        }
        if (e.op != null && e.op.getType() == 14) {
            return Ast.ExprUnary(source, WurstOperator.NOT, this.transformExpr(e.right));
        }
        if (e.op != null && e.op.getType() == 31) {
            return Ast.ExprUnary(source, WurstOperator.UNARY_MINUS, this.transformExpr(e.right));
        }
        ParseTree left = this.getLeftParseTree(e);
        if (left != null) {
            source = source.withLeftPos(1 + this.stopPos(left));
        }
        if ((right = this.getRightParseTree(e)) != null) {
            source = source.withRightPos(this.beginPos(right));
        }
        return Ast.ExprEmpty(source);
    }

    private int beginPos(ParseTree left) {
        if (left instanceof ParserRuleContext) {
            ParserRuleContext left2 = (ParserRuleContext)left;
            return left2.getStart().getStartIndex();
        }
        if (left instanceof TerminalNode) {
            TerminalNode left2 = (TerminalNode)left;
            return left2.getSymbol().getStartIndex();
        }
        throw new Error("unhandled case: " + left.getClass() + "  // " + left);
    }

    private int stopPos(ParseTree left) {
        if (left instanceof ParserRuleContext) {
            ParserRuleContext left2 = (ParserRuleContext)left;
            return left2.getStop().getStopIndex();
        }
        if (left instanceof TerminalNode) {
            TerminalNode left2 = (TerminalNode)left;
            return left2.getSymbol().getStopIndex();
        }
        throw new Error("unhandled case: " + left.getClass() + "  // " + left);
    }

    private @Nullable ParseTree getLeftParseTree(@Nullable ParserRuleContext e) {
        if (e == null || e.getParent() == null) {
            return null;
        }
        ParserRuleContext parent = e.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChild(i) != e) continue;
            if (i > 0) {
                return parent.getChild(i - 1);
            }
            return this.getLeftParseTree(parent);
        }
        return null;
    }

    private @Nullable ParseTree getRightParseTree(@Nullable ParserRuleContext e) {
        if (e == null || e.getParent() == null) {
            return null;
        }
        ParserRuleContext parent = e.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChild(i) != e) continue;
            if (i < parent.getChildCount() - 1) {
                return parent.getChild(i + 1);
            }
            return this.getRightParseTree(parent);
        }
        return null;
    }

    private WurstOperator transformOp(Token op) {
        switch (op.getType()) {
            case 13: {
                return WurstOperator.OR;
            }
            case 12: {
                return WurstOperator.AND;
            }
            case 40: {
                return WurstOperator.EQ;
            }
            case 41: {
                return WurstOperator.NOTEQ;
            }
            case 43: {
                return WurstOperator.LESS_EQ;
            }
            case 42: {
                return WurstOperator.LESS;
            }
            case 45: {
                return WurstOperator.GREATER_EQ;
            }
            case 44: {
                return WurstOperator.GREATER;
            }
            case 30: {
                return WurstOperator.PLUS;
            }
            case 31: {
                return WurstOperator.MINUS;
            }
            case 32: {
                return WurstOperator.MULT;
            }
            case 33: {
                return WurstOperator.DIV_REAL;
            }
            case 34: {
                return WurstOperator.MOD_REAL;
            }
            case 14: {
                return WurstOperator.NOT;
            }
        }
        throw this.error(this.source(op), "operator not implemented: " + this.text(op));
    }

    private Expr transformExprPrimary(JassParser.JassExprPrimaryContext e) {
        if (e.atom != null) {
            return this.transformAtom(e.atom);
        }
        if (e.varname != null) {
            if (e.indexes() != null && !e.indexes().isEmpty()) {
                Indexes index = this.transformIndexes(e.indexes());
                return Ast.ExprVarArrayAccess(this.source(e), Ast.Identifier(this.source(e.varname), e.varname.getText()), index);
            }
            return Ast.ExprVarAccess(this.source(e), Ast.Identifier(this.source(e.varname), e.varname.getText()));
        }
        if (e.jassExpr() != null) {
            return this.transformExpr(e.jassExpr());
        }
        if (e.exprFunctionCall() != null) {
            return this.transformFunctionCall(e.exprFunctionCall());
        }
        if (e.exprFuncRef() != null) {
            return this.transformExprFuncRef(e.exprFuncRef());
        }
        throw this.error(e, "primary expr not implemented " + this.text(e));
    }

    private ExprFuncRef transformExprFuncRef(JassParser.ExprFuncRefContext e) {
        String scopeName = e.scopeName == null ? "" : e.scopeName.getText();
        Identifier funcName = Ast.Identifier(this.source(e.funcName), e.funcName.getText());
        return Ast.ExprFuncRef(this.source(e), scopeName, funcName);
    }

    private Expr transformAtom(Token a) {
        WPos source = this.source(a);
        switch (a.getType()) {
            case 57: {
                return Ast.ExprIntVal(source, this.text(a));
            }
            case 56: {
                return Ast.ExprRealVal(source, this.text(a));
            }
            case 55: {
                return Ast.ExprStringVal(source, this.getStringVal(source, this.text(a)));
            }
            case 6: {
                return Ast.ExprNull(source);
            }
            case 19: {
                return Ast.ExprBoolVal(source, true);
            }
            case 20: {
                return Ast.ExprBoolVal(source, false);
            }
        }
        throw this.error(this.source(a), "atom not implemented: " + this.text(a));
    }

    private String getStringVal(WPos source, String text) {
        StringBuilder res = new StringBuilder();
        AntlrJassParseTreeTransformer.buildStringVal(source, text, res);
        return res.toString();
    }

    public static void buildStringVal(WPos source, String text, StringBuilder res) {
        block10: for (int i = 1; i < text.length() - 1; ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                switch (text.charAt(++i)) {
                    case '\\': {
                        res.append('\\');
                        continue block10;
                    }
                    case 'n': {
                        res.append('\n');
                        continue block10;
                    }
                    case 'r': {
                        res.append('\r');
                        continue block10;
                    }
                    case 't': {
                        res.append('\t');
                        continue block10;
                    }
                    case 'b': {
                        res.append('\b');
                        continue block10;
                    }
                    case 'f': {
                        res.append('\f');
                        continue block10;
                    }
                    case '\"': {
                        res.append('\"');
                        continue block10;
                    }
                    case '\'': {
                        res.append('\'');
                        continue block10;
                    }
                    default: {
                        throw new CompileError(source, "Invalid escape sequence: " + text.charAt(i));
                    }
                }
            }
            res.append(c);
        }
    }

    private FuncSig transformFuncSig(JassParser.JassFuncSignatureContext s) {
        TypeParamDefs typeParams = Ast.TypeParamDefs(new TypeParamDef[0]);
        WParameters formalParameters = Ast.WParameters(new WParameter[0]);
        for (JassParser.FormalParamContext p : s.args) {
            formalParameters.add(this.transformFormalParameter(p, false));
        }
        OptTypeExpr returnType = this.transformOptionalType(s.returnType);
        return new FuncSig(Ast.Identifier(this.source(s.name), s.name.getText()), typeParams, formalParameters, returnType);
    }

    private OptTypeExpr transformOptionalType(JassParser.JassTypeExprContext t) {
        if (t == null) {
            return Ast.NoTypeExpr();
        }
        return this.transformTypeExpr(t);
    }

    private TypeExpr transformTypeExpr(JassParser.JassTypeExprContext t) throws Error {
        OptTypeExpr scopeType = t.jassTypeExpr() != null ? this.transformTypeExpr(t.jassTypeExpr()) : Ast.NoTypeExpr();
        if (t.jassTypeExpr() != null) {
            JassParser.JassExprContext arrSize = null;
            return Ast.TypeExprArray(this.source(t), (TypeExpr)scopeType, this.transformOptionalExpr(arrSize));
        }
        return Ast.TypeExprSimple(this.source(t), scopeType, t.typeName.getText(), Ast.TypeExprList(new TypeExpr[0]));
    }

    private CompileError error(WPos source, String msg) {
        return new CompileError(source, msg);
    }

    private CompileError error(ParserRuleContext source, String msg) {
        return new CompileError(this.source(source), msg);
    }

    private WParameter transformFormalParameter(JassParser.FormalParamContext p, boolean makeConstant) {
        Modifiers modifiers = Ast.Modifiers(new Modifier[0]);
        if (makeConstant) {
            modifiers.add(Ast.ModConstant(this.source(p).artificial()));
        }
        return Ast.WParameter(this.source(p), modifiers, this.transformTypeExpr(p.jassTypeExpr()), Ast.Identifier(this.source(p.name), p.name.getText()));
    }

    private WPos source(ParserRuleContext p) {
        return new WPos(this.file, this.lineOffsets, p.start.getStartIndex(), p.stop.getStopIndex() + 1);
    }

    private WPos source(Token p) {
        return new WPos(this.file, this.lineOffsets, p.getStartIndex(), p.getStopIndex() + 1);
    }

    static class FuncSig {
        Identifier name;
        TypeParamDefs typeParams;
        WParameters formalParameters;
        OptTypeExpr returnType;

        public FuncSig(Identifier name, TypeParamDefs typeParams, WParameters formalParameters, OptTypeExpr returnType) {
            this.name = name;
            this.typeParams = typeParams;
            this.formalParameters = formalParameters;
            this.returnType = returnType;
        }
    }
}

