/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imoptimizer;

import com.google.common.collect.Sets;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImBoolVal;
import de.peeeq.wurstscript.jassIm.ImConst;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImIntVal;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImRealVal;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImStringVal;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarRead;
import de.peeeq.wurstscript.jassIm.ImVarWrite;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imoptimizer.OptimizerPass;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.utils.Utils;
import de.peeeq.wurstscript.validation.TRVEHelper;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class GlobalsInliner
implements OptimizerPass {
    @Override
    public int optimize(ImTranslator trans) {
        int obsoleteCount = 0;
        ImProg prog = trans.getImProg();
        prog.clearAttributes();
        LinkedHashSet obsoleteVars = Sets.newLinkedHashSet();
        for (ImVar v : prog.getGlobals()) {
            List initWrites;
            if (trans.isUnitTestMode() && v.getName().equals("MagicFunctions_compiletime") || v.getType() instanceof ImArrayType || v.getType() instanceof ImArrayTypeMulti || TRVEHelper.protectedVariables.contains(v.getName())) continue;
            if (v.attrWrites().size() == 1) {
                ImExpr right = null;
                ImVarWrite obs = null;
                for (ImVarWrite imVarWrite : v.attrWrites()) {
                    ImFunction func = imVarWrite.getNearestFunc();
                    if (!GlobalsInliner.isInInit(func)) continue;
                    right = imVarWrite.getRight();
                    obs = imVarWrite;
                    break;
                }
                if (obs == null) continue;
                ImExpr replacement = this.findReplacement(right, obs);
                if (replacement != null) {
                    for (ImVarRead v3 : v.attrReads()) {
                        v3.replaceBy(replacement.copy());
                    }
                }
                if (replacement == null && v.attrReads().size() != 0) continue;
                obsoleteVars.add(v);
                continue;
            }
            if (v.attrWrites().size() <= 1 || v.getType() instanceof ImTupleType || (initWrites = v.attrWrites().stream().filter(write -> {
                ImFunction nearestFunc = write.getNearestFunc();
                return GlobalsInliner.isInInit(nearestFunc);
            }).collect(Collectors.toList())).size() != 1 || !(v.getType() instanceof ImSimpleType)) continue;
            ImExpr write3 = v.attrWrites().iterator().next().getRight();
            try {
                ImExpr defaultValue = ImHelper.defaultValueForType((ImSimpleType)v.getType());
                boolean bl = defaultValue.structuralEquals(write3);
                if (!bl) continue;
                v.attrWrites().iterator().next().replaceBy(ImHelper.nullExpr());
            }
            catch (Exception e) {
                throw new CompileError(write3.attrTrace().attrErrorPos(), "Could not inline " + Utils.printElementWithSource(Optional.of(v.getTrace())), CompileError.ErrorType.ERROR, e);
            }
        }
        obsoleteCount += obsoleteVars.size();
        for (ImVar i : obsoleteVars) {
            ImVarWrite write4;
            if (i.attrWrites().size() <= 0 || (write4 = Utils.getFirstAndOnly(i.attrWrites())).getParent() == null) continue;
            write4.replaceBy(write4.getRight().copy());
        }
        prog.getGlobals().removeAll((Collection)obsoleteVars);
        return obsoleteCount;
    }

    @Nullable
    private ImExpr findReplacement(ImExpr right, ImVarWrite obs) {
        ImConst replacement;
        if (right instanceof ImIntVal) {
            ImIntVal val = (ImIntVal)right;
            replacement = JassIm.ImIntVal(val.getValI());
            if (obs.getParent() != null) {
                obs.replaceBy(ImHelper.nullExpr());
            }
        } else if (right instanceof ImRealVal) {
            ImRealVal val = (ImRealVal)right;
            replacement = JassIm.ImRealVal(val.getValR());
            if (obs.getParent() != null) {
                obs.replaceBy(ImHelper.nullExpr());
            }
        } else if (right instanceof ImStringVal) {
            ImStringVal val = (ImStringVal)right;
            replacement = JassIm.ImStringVal(val.getValS());
            if (obs.getParent() != null) {
                obs.replaceBy(ImHelper.nullExpr());
            }
        } else if (right instanceof ImBoolVal) {
            ImBoolVal val = (ImBoolVal)right;
            replacement = JassIm.ImBoolVal(val.getValB());
            if (obs.getParent() != null) {
                obs.replaceBy(ImHelper.nullExpr());
            }
        } else {
            replacement = null;
        }
        return replacement;
    }

    @Override
    public String getName() {
        return "Globals Inlined";
    }

    private static boolean isInInit(ImFunction func) {
        return func != null && (func.getName().startsWith("init_") || func.getName().equals("main") || func.getName().startsWith("InitTrig_") || func.getName().equals("initGlobals"));
    }
}

