/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.jassprinter;

import de.peeeq.wurstscript.jassAst.JassExpr;
import de.peeeq.wurstscript.jassAst.JassStatement;
import de.peeeq.wurstscript.jassAst.JassStmtCall;
import de.peeeq.wurstscript.jassAst.JassStmtExitwhen;
import de.peeeq.wurstscript.jassAst.JassStmtIf;
import de.peeeq.wurstscript.jassAst.JassStmtLoop;
import de.peeeq.wurstscript.jassAst.JassStmtReturn;
import de.peeeq.wurstscript.jassAst.JassStmtReturnVoid;
import de.peeeq.wurstscript.jassAst.JassStmtSet;
import de.peeeq.wurstscript.jassAst.JassStmtSetArray;
import de.peeeq.wurstscript.jassprinter.JassPrinter;

public class StatementPrinter {
    public static void print(JassStmtCall s, StringBuilder sb, int indent, boolean withSpace) {
        sb.append("call ");
        sb.append(s.getFuncName());
        sb.append("(");
        boolean first = true;
        for (JassExpr e : s.getArguments()) {
            if (!first) {
                sb.append(JassPrinter.comma(withSpace));
            }
            e.print(sb, withSpace);
            first = false;
        }
        sb.append(")");
    }

    public static void print(JassStmtExitwhen s, StringBuilder sb, int indent, boolean withSpace) {
        sb.append("exitwhen ");
        s.getCond().print(sb, withSpace);
    }

    public static void print(JassStmtIf s, StringBuilder sb, int indent, boolean withSpace) {
        sb.append("if ");
        s.getCond().print(sb, withSpace);
        if (withSpace) {
            sb.append(" then\n");
        } else {
            String lastChar = "" + sb.charAt(sb.length() - 1);
            if (lastChar.equals("]")) {
                sb.append("then\n");
            } else {
                sb.append(" then\n");
            }
        }
        JassPrinter.printStatements(sb, indent + 1, s.getThenBlock(), withSpace);
        if (s.getElseBlock().size() > 0) {
            JassPrinter.printIndent(sb, indent, withSpace);
            if (s.getElseBlock().size() == 1 && s.getElseBlock().get(0) instanceof JassStmtIf) {
                sb.append("else");
                ((JassStatement)s.getElseBlock().get(0)).print(sb, indent, withSpace);
                return;
            }
            sb.append("else\n");
            JassPrinter.printStatements(sb, indent + 1, s.getElseBlock(), withSpace);
        }
        JassPrinter.printIndent(sb, indent, withSpace);
        sb.append("endif");
    }

    public static void print(JassStmtLoop s, StringBuilder sb, int indent, boolean withSpace) {
        sb.append("loop\n");
        JassPrinter.printStatements(sb, indent + 1, s.getBody(), withSpace);
        JassPrinter.printIndent(sb, indent, withSpace);
        sb.append("endloop");
    }

    public static void print(JassStmtReturn s, StringBuilder sb, int indent, boolean withSpace) {
        sb.append("return ");
        s.getReturnValue().print(sb, withSpace);
    }

    public static void print(JassStmtReturnVoid s, StringBuilder sb, int indent, boolean withSpace) {
        sb.append("return");
    }

    public static void print(JassStmtSet s, StringBuilder sb, int indent, boolean withSpace) {
        sb.append("set ");
        sb.append(s.getLeft());
        sb.append(JassPrinter.assign(withSpace));
        s.getRight().print(sb, withSpace);
    }

    public static void print(JassStmtSetArray s, StringBuilder sb, int indent, boolean withSpace) {
        sb.append("set ");
        sb.append(s.getLeft());
        sb.append("[");
        s.getIndex().print(sb, withSpace);
        sb.append("]");
        sb.append(JassPrinter.assign(withSpace));
        s.getRight().print(sb, withSpace);
    }
}

