/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.names;

import de.peeeq.wurstscript.ast.AstElementWithTypeParameters;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.NameLinkType;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;

public abstract class DefLink
extends NameLink {
    private final @Nullable WurstType receiverType;

    public DefLink(Visibility visibility, WScope definedIn, List<TypeParamDef> typeParams, @Nullable WurstType receiverType) {
        super(visibility, definedIn, typeParams);
        this.receiverType = receiverType;
    }

    @Deprecated
    public abstract NameLinkType getType();

    protected static @Nullable WurstType getReceiverType(WScope definedIn) {
        if (definedIn instanceof ClassDef) {
            ClassDef classDef = (ClassDef)definedIn;
            return classDef.attrTyp();
        }
        if (definedIn instanceof InterfaceDef) {
            InterfaceDef interfaceDef = (InterfaceDef)definedIn;
            return interfaceDef.attrTyp();
        }
        if (definedIn instanceof ModuleInstanciation) {
            ModuleInstanciation moduleInstanciation = (ModuleInstanciation)definedIn;
            return moduleInstanciation.attrTyp();
        }
        if (definedIn instanceof ModuleDef) {
            ModuleDef moduleDef = (ModuleDef)definedIn;
            return moduleDef.attrTyp();
        }
        return null;
    }

    protected static Stream<TypeParamDef> typeParams(Element scope) {
        if (scope instanceof AstElementWithTypeParameters) {
            return ((AstElementWithTypeParameters)scope).getTypeParameters().stream();
        }
        return Stream.of(new TypeParamDef[0]);
    }

    public @Nullable WurstType getReceiverType() {
        return this.receiverType;
    }

    @Override
    public DefLink hidingPrivate() {
        return (DefLink)super.hidingPrivate();
    }

    @Override
    public DefLink hidingPrivateAndProtected() {
        return (DefLink)super.hidingPrivateAndProtected();
    }

    @Override
    public boolean receiverCompatibleWith(WurstType receiverType, Element location) {
        if (this.receiverType == null) {
            return receiverType == null;
        }
        if (receiverType == null) {
            return false;
        }
        return receiverType.isSubtypeOf(this.receiverType, location);
    }

    public @Nullable DefLink adaptToReceiverType(WurstType receiverType) {
        if (this.receiverType == null) {
            if (receiverType == null) {
                return this;
            }
            return null;
        }
        NameDef def = this.getDef();
        VariableBinding match = this.receiverType.matchAgainstSupertype(receiverType, def, VariableBinding.emptyMapping().withTypeVariables(this.typeParams), VariablePosition.LEFT);
        if (match == null) {
            return null;
        }
        return this.withTypeArgBinding(def, match);
    }

    @Override
    public abstract DefLink withTypeArgBinding(Element var1, VariableBinding var2);

    public abstract DefLink withGenericTypeParams(List<TypeParamDef> var1);
}

