/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.validation;

import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ExprVarAccess;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.JassGlobalBlock;
import de.peeeq.wurstscript.ast.JassToplevelDeclaration;
import de.peeeq.wurstscript.ast.JassToplevelDeclarations;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.WPackage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ValidateGlobalsUsage {
    public static void checkGlobalsUsage(Collection<CompilationUnit> toCheck) {
        HashMap<NameDef, Element> usedGlobals = new HashMap<NameDef, Element>();
        for (CompilationUnit cu : toCheck) {
            ValidateGlobalsUsage.checkJassGlobals(cu.getJassDecls(), usedGlobals);
            for (WPackage p : cu.getPackages()) {
                ValidateGlobalsUsage.checkGlobalsUsage(p);
            }
        }
    }

    private static void checkJassGlobals(JassToplevelDeclarations jassDecls, final Map<NameDef, Element> usedGlobals) {
        for (JassToplevelDeclaration jassDecl : jassDecls) {
            if (!(jassDecl instanceof JassGlobalBlock)) continue;
            JassGlobalBlock globals = (JassGlobalBlock)jassDecl;
            for (GlobalVarDef glob : globals) {
                if (glob.getSource().getFile().endsWith("common.j") || glob.getSource().getFile().endsWith("blizzard.j") || glob.getSource().getFile().endsWith("war3map.j")) continue;
                glob.getInitialExpr().accept(new Element.DefaultVisitor(){

                    @Override
                    public void visit(ExprVarAccess e) {
                        usedGlobals.put(e.attrNameDef(), e);
                    }
                });
                Element use = usedGlobals.get(glob);
                if (use == null) continue;
                use.addWarning("Global variable " + glob.getName() + " used before it is declared.");
            }
        }
    }

    private static void checkGlobalsUsage(final WPackage p) {
        final HashSet definedVars = new HashSet();
        p.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(GlobalVarDef g) {
                super.visit(g);
                definedVars.add(g);
            }

            @Override
            public void visit(ExprVarAccess e) {
                GlobalVarDef g;
                super.visit(e);
                NameDef nameDef = e.attrNameDef();
                if (nameDef instanceof GlobalVarDef && !definedVars.contains(g = (GlobalVarDef)nameDef) && !g.attrIsDynamicClassMember() && g.attrNearestNamedScope() == p) {
                    e.addError("Global variable <" + e.getVarName() + "> must be declared before it is used.");
                    definedVars.add(g);
                }
            }
        });
    }
}

