/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.moonlightflower.wc3libs.misc.Size;
import net.moonlightflower.wc3libs.misc.image.FxImg;
import net.moonlightflower.wc3libs.misc.image.Wc3RasterImg;

public class JPG
extends Wc3RasterImg {
    private void read(@Nonnull InputStream stream) throws IOException {
        BufferedImage img = ImageIO.read(stream);
        BufferedImage writeImg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                Color color = new Color(img.getRGB(x, y));
                int red = color.getBlue();
                int green = color.getGreen();
                int blue = color.getRed();
                int alpha = color.getAlpha();
                color = new Color(red, green, blue, alpha);
                writeImg.setRGB(x, y, color.getRGB());
            }
        }
        this.setFXImg(new FxImg(writeImg));
    }

    public JPG(@Nonnull InputStream stream) throws IOException {
        this.read(stream);
    }

    public JPG(@Nonnull File file) throws IOException {
        this(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public JPG(@Nonnull Size size) {
        super(size);
    }
}

