/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.optimizer;

import com.google.common.base.Preconditions;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.intermediatelang.optimizer.ConstantAndCopyPropagation;
import de.peeeq.wurstscript.intermediatelang.optimizer.LocalMerger;
import de.peeeq.wurstscript.intermediatelang.optimizer.TempMerger;
import de.peeeq.wurstscript.jassIm.ImAlloc;
import de.peeeq.wurstscript.jassIm.ImBoolVal;
import de.peeeq.wurstscript.jassIm.ImCast;
import de.peeeq.wurstscript.jassIm.ImCompiletimeExpr;
import de.peeeq.wurstscript.jassIm.ImDealloc;
import de.peeeq.wurstscript.jassIm.ImExitwhen;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.ImFuncRef;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImGetStackTrace;
import de.peeeq.wurstscript.jassIm.ImIf;
import de.peeeq.wurstscript.jassIm.ImInstanceof;
import de.peeeq.wurstscript.jassIm.ImIntVal;
import de.peeeq.wurstscript.jassIm.ImLoop;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImMethodCall;
import de.peeeq.wurstscript.jassIm.ImNull;
import de.peeeq.wurstscript.jassIm.ImOperatorCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImRealVal;
import de.peeeq.wurstscript.jassIm.ImReturn;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStatementExpr;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStringVal;
import de.peeeq.wurstscript.jassIm.ImTupleExpr;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfClass;
import de.peeeq.wurstscript.jassIm.ImTypeIdOfObj;
import de.peeeq.wurstscript.jassIm.ImTypeVar;
import de.peeeq.wurstscript.jassIm.ImTypeVarDispatch;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVarargLoop;
import de.peeeq.wurstscript.jassIm.ImVoid;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.imtranslation.UsedVariables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FunctionSplitter {
    private final int op_limit;
    private final ImTranslator tr;
    private final ImFunction func;
    private final Map<ImFunction, Integer> fuelVisited;

    private FunctionSplitter(int op_limit, ImTranslator tr, ImFunction func) {
        this.op_limit = op_limit;
        this.tr = tr;
        this.func = func;
        this.fuelVisited = new LinkedHashMap<ImFunction, Integer>();
        this.fuelVisited.put(func, null);
    }

    public static void splitFunc(ImTranslator tr, ImFunction func) {
        new FunctionSplitter(tr.getRunArgs().getFunctionSplitLimit(), tr, func).optimize();
    }

    private void optimize() {
        Preconditions.checkArgument((boolean)this.func.getTypeVariables().isEmpty(), (Object)"func must not be generic");
        Preconditions.checkArgument((boolean)this.func.getParameters().isEmpty(), (Object)"func parameters must be empty");
        Preconditions.checkArgument((boolean)(this.func.getReturnType() instanceof ImVoid), (Object)"func must return void");
        this.func.flatten(this.tr);
        new ConstantAndCopyPropagation().optimizeFunc(this.func);
        new TempMerger().optimizeFunc(this.func);
        new LocalMerger().optimizeFunc(this.func);
        Set<ImVar> usedVars = UsedVariables.calculate(this.func);
        this.func.getLocals().removeIf(v -> !usedVars.contains(v));
        this.func.flatten(this.tr);
        List<List<ImStmt>> splitResult = this.split(this.func.getBody().removeAll());
        ImProg prog = this.tr.getImProg();
        prog.getGlobals().addAll((Collection)this.func.getLocals().removeAll());
        ArrayList<ImFunction> helperFuncs = new ArrayList<ImFunction>();
        for (int i = 0; i < splitResult.size(); ++i) {
            List<ImStmt> stmts = splitResult.get(i);
            ImFunction helperFunc = JassIm.ImFunction(this.func.getTrace(), this.func.getName() + "_" + i, JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(stmts), Collections.emptyList());
            helperFuncs.add(helperFunc);
        }
        prog.getFunctions().addAll(helperFuncs);
        for (ImFunction helperFunc : helperFuncs) {
            this.func.getBody().add(JassIm.ImFunctionCall(this.func.getTrace(), helperFunc, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(new ImExpr[0]), false, CallType.EXECUTE));
        }
    }

    private List<List<ImStmt>> split(List<ImStmt> body) {
        ArrayList<List<ImStmt>> result = new ArrayList<List<ImStmt>>();
        int fuel = 0;
        for (ImStmt s : body) {
            if (result.isEmpty() || (fuel += this.estimateFuel(s)) > this.op_limit) {
                result.add(new ArrayList());
                fuel = 0;
            }
            ((List)result.get(result.size() - 1)).add(s);
        }
        return result;
    }

    private int estimateFuel(ImStmt s) {
        return s.match(new ImStmt.Matcher<Integer>(){

            @Override
            public Integer case_ImTypeVarDispatch(ImTypeVarDispatch s) {
                return FunctionSplitter.this.estimateFuel(s.getArguments()) + 100;
            }

            @Override
            public Integer case_ImDealloc(ImDealloc s) {
                return 10 + FunctionSplitter.this.estimateFuel(s.getObj());
            }

            @Override
            public Integer case_ImBoolVal(ImBoolVal s) {
                return 1;
            }

            @Override
            public Integer case_ImTypeIdOfClass(ImTypeIdOfClass s) {
                return 1;
            }

            @Override
            public Integer case_ImVarAccess(ImVarAccess s) {
                return 1;
            }

            @Override
            public Integer case_ImStringVal(ImStringVal s) {
                return 1;
            }

            @Override
            public Integer case_ImMethodCall(ImMethodCall s) {
                return FunctionSplitter.this.estimateFuel(s.getArguments()) + FunctionSplitter.this.estimateFuelMethod(s.getMethod()) + 10;
            }

            @Override
            public Integer case_ImRealVal(ImRealVal s) {
                return 1;
            }

            @Override
            public Integer case_ImFunctionCall(ImFunctionCall s) {
                return FunctionSplitter.this.estimateFuel(s.getArguments()) + 10 + FunctionSplitter.this.estimateFuelFunc(s.getFunc());
            }

            @Override
            public Integer case_ImReturn(ImReturn s) {
                return 3 + FunctionSplitter.this.estimateFuelOpt(s.getReturnValue());
            }

            @Override
            public Integer case_ImTupleSelection(ImTupleSelection s) {
                return FunctionSplitter.this.estimateFuel(s.getTupleExpr()) + 10;
            }

            @Override
            public Integer case_ImOperatorCall(ImOperatorCall s) {
                return 5 + FunctionSplitter.this.estimateFuel(s.getArguments());
            }

            @Override
            public Integer case_ImVarArrayAccess(ImVarArrayAccess s) {
                return 3 + FunctionSplitter.this.estimateFuel(s.getIndexes());
            }

            @Override
            public Integer case_ImAlloc(ImAlloc s) {
                return 30;
            }

            @Override
            public Integer case_ImIntVal(ImIntVal s) {
                return 1;
            }

            @Override
            public Integer case_ImExitwhen(ImExitwhen s) {
                return 5 + FunctionSplitter.this.estimateFuel(s.getCondition());
            }

            @Override
            public Integer case_ImVarargLoop(ImVarargLoop s) {
                throw new CompileError(s, "Cannot estimate size of function " + FunctionSplitter.this.func.getBody() + " as it contains looops.");
            }

            @Override
            public Integer case_ImNull(ImNull s) {
                return 1;
            }

            @Override
            public Integer case_ImLoop(ImLoop s) {
                throw new CompileError(s, "Cannot estimate size of function " + FunctionSplitter.this.func.getBody() + " as it contains looops.");
            }

            @Override
            public Integer case_ImMemberAccess(ImMemberAccess s) {
                return 1 + FunctionSplitter.this.estimateFuel(s.getReceiver()) + FunctionSplitter.this.estimateFuel(s.getIndexes());
            }

            @Override
            public Integer case_ImGetStackTrace(ImGetStackTrace s) {
                return 50;
            }

            @Override
            public Integer case_ImTupleExpr(ImTupleExpr s) {
                return 1 + FunctionSplitter.this.estimateFuel(s.getExprs());
            }

            @Override
            public Integer case_ImTypeIdOfObj(ImTypeIdOfObj s) {
                return 1 + FunctionSplitter.this.estimateFuel(s.getObj());
            }

            @Override
            public Integer case_ImSet(ImSet s) {
                return 3 + FunctionSplitter.this.estimateFuel(s.getLeft()) + FunctionSplitter.this.estimateFuel(s.getRight());
            }

            @Override
            public Integer case_ImStatementExpr(ImStatementExpr s) {
                return 1 + FunctionSplitter.this.estimateFuel(s.getStatements()) + FunctionSplitter.this.estimateFuel(s.getExpr());
            }

            @Override
            public Integer case_ImCompiletimeExpr(ImCompiletimeExpr s) {
                return 1;
            }

            @Override
            public Integer case_ImIf(ImIf s) {
                return 1 + FunctionSplitter.this.estimateFuel(s.getCondition()) + Math.max(FunctionSplitter.this.estimateFuel(s.getThenBlock()), FunctionSplitter.this.estimateFuel(s.getElseBlock()));
            }

            @Override
            public Integer case_ImCast(ImCast s) {
                return FunctionSplitter.this.estimateFuel(s.getExpr());
            }

            @Override
            public Integer case_ImFuncRef(ImFuncRef s) {
                return 1;
            }

            @Override
            public Integer case_ImInstanceof(ImInstanceof s) {
                return 1 + FunctionSplitter.this.estimateFuel(s.getObj()) + 10 * FunctionSplitter.this.tr.getImProg().getClasses().size();
            }
        });
    }

    private int estimateFuelMethod(ImMethod method) {
        return Math.max(this.estimateFuelFunc(method.getImplementation()), method.getSubMethods().stream().mapToInt(m -> this.estimateFuelMethod(method)).sum());
    }

    private int estimateFuelFunc(ImFunction f) {
        if (f.isNative()) {
            return 10;
        }
        if (this.fuelVisited.containsKey(f)) {
            Integer v = this.fuelVisited.get(f);
            if (v == null) {
                throw new CompileError(this.func, "Cannot split recursive method " + this.func.getName() + " calling funcs: " + this.fuelVisited.entrySet().stream().filter(e -> e.getValue() == null).map(e -> ((ImFunction)e.getKey()).getName()).collect(Collectors.joining(", ")));
            }
            return v;
        }
        this.fuelVisited.put(f, null);
        int v = this.estimateFuel(f.getBody());
        this.fuelVisited.put(f, v);
        return v;
    }

    private int estimateFuelOpt(ImExprOpt returnValue) {
        if (returnValue instanceof ImExpr) {
            return this.estimateFuel((ImExpr)returnValue);
        }
        return 0;
    }

    private int estimateFuel(List<? extends ImStmt> stmts) {
        return stmts.stream().mapToInt(this::estimateFuel).sum();
    }
}

