/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.Lists;
import de.peeeq.wurstscript.ast.ArrayInitializer;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.EnumMember;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprList;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.GlobalOrLocalVarDef;
import de.peeeq.wurstscript.ast.GlobalVarDef;
import de.peeeq.wurstscript.ast.InitBlock;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.LocalVarDef;
import de.peeeq.wurstscript.ast.ModuleDef;
import de.peeeq.wurstscript.ast.ModuleInstanciation;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.NativeType;
import de.peeeq.wurstscript.ast.OnDestroyDef;
import de.peeeq.wurstscript.ast.OptTypeExpr;
import de.peeeq.wurstscript.ast.StmtForEach;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.VarInitialization;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.ast.WShortParameter;
import de.peeeq.wurstscript.attributes.AttrClosureAbstractMethod;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.types.FunctionSignature;
import de.peeeq.wurstscript.types.WurstNativeType;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeArray;
import de.peeeq.wurstscript.types.WurstTypeBoundTypeParam;
import de.peeeq.wurstscript.types.WurstTypeClass;
import de.peeeq.wurstscript.types.WurstTypeEnum;
import de.peeeq.wurstscript.types.WurstTypeInfer;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeIntLiteral;
import de.peeeq.wurstscript.types.WurstTypeInterface;
import de.peeeq.wurstscript.types.WurstTypeModule;
import de.peeeq.wurstscript.types.WurstTypeModuleInstanciation;
import de.peeeq.wurstscript.types.WurstTypePackage;
import de.peeeq.wurstscript.types.WurstTypeStaticTypeRef;
import de.peeeq.wurstscript.types.WurstTypeTuple;
import de.peeeq.wurstscript.types.WurstTypeTypeParam;
import de.peeeq.wurstscript.types.WurstTypeUnion;
import de.peeeq.wurstscript.types.WurstTypeUnknown;
import de.peeeq.wurstscript.types.WurstTypeVararg;
import de.peeeq.wurstscript.types.WurstTypeVoid;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;

public class AttrVarDefType {
    public static WurstType calculate(GlobalVarDef node) {
        return AttrVarDefType.defaultCase(node);
    }

    public static WurstType calculate(LocalVarDef node) {
        return AttrVarDefType.defaultCase(node);
    }

    public static WurstType calculate(WParameter node) {
        if (node.attrIsVararg()) {
            return new WurstTypeVararg(node.getTyp().attrTyp().dynamic());
        }
        return node.getTyp().attrTyp().dynamic();
    }

    public static WurstType calculate(WShortParameter p) {
        if (p.getTypOpt() instanceof TypeExpr) {
            return p.getTypOpt().attrTyp().dynamic();
        }
        ExprClosure parentClosure = (ExprClosure)p.getParent().getParent();
        int paramIndex = parentClosure.getShortParameters().indexOf(p);
        WurstType expectedTyp = parentClosure.attrExpectedTyp();
        return AttrVarDefType.getParameterTypeFromClosureType(p, paramIndex, expectedTyp, true);
    }

    public static WurstType getParameterTypeFromClosureType(WShortParameter p, int paramIndex, WurstType expectedTyp, boolean addError) {
        if (expectedTyp instanceof WurstTypeUnion) {
            WurstTypeUnion union = (WurstTypeUnion)expectedTyp;
            WurstType t1 = AttrVarDefType.getParameterTypeFromClosureType(p, paramIndex, union.getTypeA(), addError);
            if (t1 instanceof WurstTypeInfer) {
                return t1;
            }
            WurstType t2 = AttrVarDefType.getParameterTypeFromClosureType(p, paramIndex, union.getTypeB(), addError);
            return WurstTypeUnion.create(t1, t2, p);
        }
        FunctionSignature sig = AttrClosureAbstractMethod.getAbstractMethodSignature(expectedTyp);
        if (sig == null) {
            if (addError) {
                p.addError("Could not infer type for parameter " + p.getName() + ". The target type could not be uniquely determined for expected type " + expectedTyp + ".");
            }
            return WurstTypeInfer.instance();
        }
        if (sig.getParamTypes().size() <= paramIndex) {
            if (addError) {
                p.addError("Could not infer type for parameter " + p.getName() + ". Closure type " + expectedTyp + " does not take so many parameters.");
            }
            return WurstTypeInfer.instance();
        }
        return sig.getParamTypes().get(paramIndex).normalize();
    }

    public static WurstTypeClass calculate(ClassDef c) {
        ArrayList typeArgs = Lists.newArrayList();
        for (TypeParamDef tp : c.getTypeParameters()) {
            WurstTypeTypeParam typParam = new WurstTypeTypeParam(tp);
            typeArgs.add(new WurstTypeBoundTypeParam(tp, typParam, tp));
        }
        return new WurstTypeClass(c, typeArgs, true);
    }

    private static WurstType defaultCase(GlobalOrLocalVarDef v) {
        OptTypeExpr typ = v.getOptTyp();
        VarInitialization initialExpr = v.getInitialExpr();
        if (typ instanceof TypeExpr) {
            return typ.attrTyp().dynamic();
        }
        if (initialExpr instanceof Expr) {
            WurstType result = ((Expr)initialExpr).attrTyp();
            if (result instanceof WurstTypeIntLiteral) {
                return WurstTypeInt.instance();
            }
            return result.normalize();
        }
        if (initialExpr instanceof ArrayInitializer) {
            ArrayInitializer ai = (ArrayInitializer)initialExpr;
            ExprList values = ai.getValues();
            if (values.isEmpty()) {
                v.addError("Could not infer the type of variable '" + v.getName() + "' because the array is empty.");
                return new WurstTypeArray(WurstTypeUnknown.instance());
            }
            WurstType valueType = ((Expr)values.get(0)).attrTyp();
            if (valueType instanceof WurstTypeIntLiteral) {
                valueType = WurstTypeInt.instance();
            } else if (valueType instanceof WurstTypeArray) {
                v.addError("Array parameters are not permitted. Remember that initialized arrays do not have an identity nor length.");
                return new WurstTypeArray(WurstTypeUnknown.instance());
            }
            return new WurstTypeArray(valueType, ai.getValues().size());
        }
        if (v.getParent() instanceof StmtForEach) {
            StmtForEach forEach = (StmtForEach)v.getParent();
            @Nullable NameDef nameDef = forEach.getIn().tryGetNameDef();
            if (nameDef instanceof WParameter && nameDef.attrTyp() instanceof WurstTypeVararg) {
                return ((WurstTypeVararg)nameDef.attrTyp()).getBaseType();
            }
            Optional<FuncLink> nameLink = forEach.attrGetNextFunc();
            if (nameLink.isPresent()) {
                return nameLink.get().getReturnType().normalize();
            }
            return WurstTypeUnknown.instance();
        }
        v.addError("Could not infer the type of variable '" + v.getName() + "' because it does not have an initial expression.\nFix this error by providing a type (e.g. 'int " + v.getName() + "' or 'string " + v.getName() + "').");
        return WurstTypeUnknown.instance();
    }

    public static WurstType calculate(ModuleDef moduleDef) {
        return new WurstTypeModule(moduleDef, true);
    }

    public static WurstType calculate(ModuleInstanciation m) {
        return new WurstTypeModuleInstanciation(m, true);
    }

    public static WurstType calculate(NativeType n) {
        WurstNativeType base = WurstNativeType.instance(n.getName(), n.getOptTyp().attrTyp());
        return new WurstTypeStaticTypeRef(base);
    }

    public static WurstType calculate(FunctionDefinition f) {
        return f.attrReturnTyp();
    }

    public static WurstType calculate(TypeParamDef t) {
        return new WurstTypeTypeParam(t);
    }

    public static WurstTypeInterface calculate(InterfaceDef i) {
        ArrayList typeArgs = Lists.newArrayList();
        for (TypeParamDef tp : i.getTypeParameters()) {
            WurstTypeTypeParam tpType = new WurstTypeTypeParam(tp);
            typeArgs.add(new WurstTypeBoundTypeParam(tp, tpType, tp));
        }
        return new WurstTypeInterface(i, typeArgs, true);
    }

    public static WurstType calculate(TupleDef t) {
        return new WurstTypeTuple(t);
    }

    public static WurstType calculate(WPackage p) {
        return new WurstTypePackage(p);
    }

    public static WurstType calculate(EnumDef enumDef) {
        return new WurstTypeEnum(true, enumDef);
    }

    public static WurstType calculate(EnumMember enumMember) {
        return new WurstTypeEnum(false, (EnumDef)enumMember.getParent().getParent());
    }

    public static WurstType calculate(ConstructorDef constructorDef) {
        return WurstTypeVoid.instance();
    }

    public static WurstType calculate(InitBlock constructorDef) {
        return WurstTypeVoid.instance();
    }

    public static WurstType calculate(OnDestroyDef constructorDef) {
        return WurstTypeVoid.instance();
    }
}

