/*
 * Decompiled with CFR 0.152.
 */
package ui;

import file.Download;
import global.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tablelayout.Table;
import ui.MainWindow;
import ui.SetupButton;
import ui.SetupUpdateDialog;
import ui.UiStyle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lui/SetupUpdateDialog;", "Ljavax/swing/JDialog;", "message", "", "(Ljava/lang/String;)V", "buttonDeny", "Lui/SetupButton;", "buttonNow", "buttonVisit", "contentPane", "Ljavax/swing/JPanel;", "contentTable", "Ltablelayout/Table;", "openWebpage", "", "uri", "Ljava/net/URI;", "url", "Ljava/net/URL;", "uiLayout", "uiStyle", "WurstSetup"})
public final class SetupUpdateDialog
extends JDialog {
    @NotNull
    private final JPanel contentPane;
    @NotNull
    private final Table contentTable;
    @NotNull
    private final SetupButton buttonVisit;
    @NotNull
    private final SetupButton buttonNow;
    @NotNull
    private final SetupButton buttonDeny;

    public SetupUpdateDialog(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.contentPane = new JPanel(new GridBagLayout());
        this.contentTable = new Table();
        this.buttonVisit = new SetupButton("Open Website");
        this.buttonNow = new SetupButton("Download Now");
        this.buttonDeny = new SetupButton("Continue");
        this.setTitle("Notification");
        this.contentTable.setSize(340, 140);
        this.setSize(340, 140);
        this.setContentPane(this.contentPane);
        this.contentPane.add((Component)this.contentTable);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        try {
            this.setIconImage(ImageIO.read(this.getClass().getClassLoader().getResource("icon.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.uiLayout(message);
        this.uiStyle();
        this.getRootPane().setDefaultButton((JButton)this.buttonVisit);
        this.buttonDeny.addActionListener(arg_0 -> SetupUpdateDialog._init_$lambda$0(this, arg_0));
        this.buttonNow.addActionListener(arg_0 -> SetupUpdateDialog._init_$lambda$1(this, arg_0));
        this.buttonVisit.addActionListener(arg_0 -> SetupUpdateDialog._init_$lambda$2(this, arg_0));
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    private final void uiLayout(String message) {
        JLabel welcomeLabel = new JLabel("<html><div style='text-align: center;'>" + message + "</div></html>");
        welcomeLabel.setAlignmentX(0.5f);
        welcomeLabel.setForeground(Color.WHITE);
        this.contentTable.top();
        this.contentTable.addCell((Component)welcomeLabel).width(300.0f).top().pad(-2.0f, 5.0f, 5.0f, 5.0f);
        this.contentTable.row();
        Table buttonTable = new Table();
        buttonTable.addCell((Component)this.buttonVisit).pad(0.0f, 6.0f, 0.0f, 6.0f);
        buttonTable.addCell((Component)this.buttonNow).pad(0.0f, 6.0f, 0.0f, 6.0f);
        buttonTable.addCell((Component)this.buttonDeny).pad(0.0f, 6.0f, 0.0f, 6.0f);
        this.contentTable.addCell((Component)buttonTable).growX().padTop(6.0f);
    }

    private final void uiStyle() {
        this.contentPane.setBackground(new Color(36, 36, 36));
        UiStyle.INSTANCE.setStyle(this.contentTable);
    }

    private final void openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private final void openWebpage(URL url) {
        try {
            URI uRI = url.toURI();
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
            this.openWebpage(uRI);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static final void _init_$lambda$0(SetupUpdateDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.dispose();
    }

    private static final void _init_$lambda$1(SetupUpdateDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Log.INSTANCE.print("Updating setup..");
        MainWindow.INSTANCE.getUi().disableButtons();
        Download.INSTANCE.downloadSetup((Function1<? super Path, Unit>)((Function1)2.1.INSTANCE));
        this$0.dispose();
    }

    private static final void _init_$lambda$2(SetupUpdateDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openWebpage(new URL("https://wurstlang.org/"));
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }
}

