/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.ZipArchiveExtractor;
import global.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lfile/ZipArchiveExtractor;", "", "()V", "log", "Lmu/KLogger;", "buildDirectoryHierarchyFor", "Ljava/io/File;", "entryName", "", "destDir", "extractArchive", "", "archive", "Ljava/nio/file/Path;", "WurstSetup"})
public final class ZipArchiveExtractor {
    @NotNull
    public static final ZipArchiveExtractor INSTANCE = new ZipArchiveExtractor();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);

    private ZipArchiveExtractor() {
    }

    public final boolean extractArchive(@NotNull Path archive, @NotNull Path destDir) throws Exception {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        if (!Files.exists(destDir, new LinkOption[0])) {
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        ZipFile zipFile = new ZipFile(archive.toFile());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        byte[] buffer = new byte[16384];
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryFileName = entry.getName();
            Intrinsics.checkNotNull((Object)entryFileName);
            File file = destDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            File dir = this.buildDirectoryHierarchyFor(entryFileName, file);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (entry.isDirectory()) continue;
            File targetFile = new File(destDir.toFile(), entryFileName);
            if (targetFile.exists() && !targetFile.canWrite()) {
                zipFile.close();
                return false;
            }
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(targetFile));
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                int len = bis.read(buffer);
                while (len > 0) {
                    bos.write(buffer, 0, len);
                    len = bis.read(buffer);
                }
                bos.flush();
                bos.close();
                bis.close();
            }
            catch (FileNotFoundException e) {
                log.warn("Warning: <" + entryFileName + "> could not be extracted (might be in use)");
                Log.INSTANCE.print("\nWarning: <" + entryFileName + "> could not be extracted (might be in use)!\n");
            }
        }
        zipFile.close();
        return true;
    }

    private final File buildDirectoryHierarchyFor(String entryName, File destDir) {
        int lastIndex = StringsKt.lastIndexOf$default((CharSequence)entryName, (char)'/', (int)0, (boolean)false, (int)6, null);
        String string = entryName.substring(0, lastIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String internalPathToEntry = string;
        return new File(destDir, internalPathToEntry);
    }
}

