/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver;

import de.peeeq.wurstio.languageserver.WurstCommands;
import de.peeeq.wurstio.languageserver.WurstLanguageServer;
import de.peeeq.wurstio.languageserver.requests.SymbolInformationRequest;
import de.peeeq.wurstscript.WLogger;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.WorkspaceService;

public class WurstWorkspaceService
implements WorkspaceService {
    private final WurstLanguageServer server;

    public WurstWorkspaceService(WurstLanguageServer server) {
        this.server = server;
    }

    public CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> symbol(WorkspaceSymbolParams params) {
        WLogger.info("symbol");
        return this.server.worker().handle(new SymbolInformationRequest(params));
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        WLogger.trace("didChangeConfiguration");
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        WLogger.trace("didChangeWatchedFiles");
        this.server.worker().handleFileChanged(params);
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        return WurstCommands.execute(this.server, params);
    }
}

