/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.peParser.headers.resources;

import dorkbox.peParser.ByteArray;
import dorkbox.peParser.headers.Header;
import dorkbox.peParser.headers.SectionTableEntry;
import dorkbox.peParser.types.DWORD;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldorkbox/peParser/headers/resources/ResourceDataEntry;", "Ldorkbox/peParser/headers/Header;", "bytes", "Ldorkbox/peParser/ByteArray;", "section", "Ldorkbox/peParser/headers/SectionTableEntry;", "(Ldorkbox/peParser/ByteArray;Ldorkbox/peParser/headers/SectionTableEntry;)V", "CODE_PAGE", "Ldorkbox/peParser/types/DWORD;", "getCODE_PAGE", "()Ldorkbox/peParser/types/DWORD;", "OFFSET_TO_DATA", "getOFFSET_TO_DATA", "RESERVED", "getRESERVED", "SIZE", "getSIZE", "getData", "", "PeParser"})
public final class ResourceDataEntry
extends Header {
    @NotNull
    private final SectionTableEntry section;
    @NotNull
    private final DWORD OFFSET_TO_DATA;
    @NotNull
    private final DWORD SIZE;
    @NotNull
    private final DWORD CODE_PAGE;
    @NotNull
    private final DWORD RESERVED;

    public ResourceDataEntry(@NotNull ByteArray bytes, @NotNull SectionTableEntry section) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        this.section = section;
        this.OFFSET_TO_DATA = new DWORD(bytes.readUInt-OGnWXxg(4), "offsetToData", null);
        this.SIZE = new DWORD(bytes.readUInt-OGnWXxg(4), "Size", null);
        this.CODE_PAGE = new DWORD(bytes.readUInt-OGnWXxg(4), "CodePage", null);
        this.RESERVED = new DWORD(bytes.readUInt-OGnWXxg(4), "Reserved", null);
    }

    @NotNull
    public final DWORD getOFFSET_TO_DATA() {
        return this.OFFSET_TO_DATA;
    }

    @NotNull
    public final DWORD getSIZE() {
        return this.SIZE;
    }

    @NotNull
    public final DWORD getCODE_PAGE() {
        return this.CODE_PAGE;
    }

    @NotNull
    public final DWORD getRESERVED() {
        return this.RESERVED;
    }

    @NotNull
    public final byte[] getData(@NotNull ByteArray bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        long dataOffset = ((long)this.section.getPOINTER_TO_RAW_DATA().get-pVg5ArA() & 0xFFFFFFFFL) + ((long)this.OFFSET_TO_DATA.get-pVg5ArA() & 0xFFFFFFFFL) - ((long)this.section.getVIRTUAL_ADDRESS().get-pVg5ArA() & 0xFFFFFFFFL);
        if (dataOffset > Integer.MAX_VALUE) {
            throw new RuntimeException("Unable to set offset to more than 2gb!");
        }
        int saved = bytes.position();
        bytes.seek((int)dataOffset);
        long bytesToCopyLong = (long)this.SIZE.get-pVg5ArA() & 0xFFFFFFFFL;
        if (bytesToCopyLong > Integer.MAX_VALUE) {
            throw new RuntimeException("Unable to copy more than 2gb of bytes!");
        }
        byte[] copyBytes = bytes.copyBytes((int)bytesToCopyLong);
        bytes.seek(saved);
        return copyBytes;
    }
}

