/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.objs;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.BuffCode;
import net.moonlightflower.wc3libs.dataTypes.app.BuffId;
import net.moonlightflower.wc3libs.dataTypes.app.UnitRace;
import net.moonlightflower.wc3libs.dataTypes.app.War3Bool;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.SLK;

public class BuffSLK
extends ObjSLK<BuffSLK, BuffId, Obj> {
    public static final File GAME_PATH = new File("Units\\AbilityBuffData.slk");

    @Override
    @Nonnull
    public Map<BuffId, Obj> getObjs() {
        return this._objs;
    }

    @Override
    public void addObj(@Nonnull Obj val) {
        this._objs.put((BuffId)val.getId(), val);
    }

    @Override
    @Nonnull
    public Obj addObj(@Nonnull BuffId id) {
        if (this._objs.containsKey(id)) {
            return (Obj)this._objs.get(id);
        }
        Obj obj = new Obj(id);
        this.addObj(obj);
        return obj;
    }

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
        for (Map.Entry<? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slkEntry : slk.getObjs().entrySet()) {
            ObjId id = slkEntry.getKey();
            SLK.Obj<? extends ObjId> slkObj = slkEntry.getValue();
            Obj obj = new Obj(slkObj);
            this.addObj(obj);
        }
    }

    @Override
    public void read(@Nonnull File file) throws IOException {
        super.read(file);
    }

    @Override
    public void write(@Nonnull File file) throws IOException {
        super.write(file);
    }

    public BuffSLK(SLK slk) {
        this.read(slk);
    }

    public BuffSLK() {
        this.addField(State.OBJ_ID);
        for (State state : State.values(State.class)) {
            this.addField(state);
        }
    }

    public BuffSLK(File file) throws IOException {
        this();
        this.read(file);
    }

    @Override
    @Nonnull
    public Obj createObj(@Nonnull ObjId id) {
        return new Obj(BuffId.valueOf(id));
    }

    @Override
    public void merge(@Nonnull BuffSLK other, boolean overwrite) {
        for (Map.Entry<BuffId, Obj> objEntry : other.getObjs().entrySet()) {
            BuffId objId = objEntry.getKey();
            Obj otherObj = objEntry.getValue();
            Obj obj = this.addObj(objId);
            obj.merge(otherObj);
        }
    }

    public static class Obj
    extends SLK.Obj<BuffId> {
        private final Map<State, DataType> _stateVals = new LinkedHashMap<State, DataType>();

        @Override
        public Map<State, DataType> getStateVals() {
            return new LinkedHashMap<State, DataType>(this._stateVals);
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.put(state, val);
            }
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.remove(state);
            }
        }

        @Override
        protected void on_clear() {
            this._stateVals.clear();
        }

        public <T extends DataType> T get(State<T> state) throws DataTypeInfo.CastException {
            if (!super.contains((FieldId)state.getFieldId())) {
                return state.getDefVal();
            }
            return state.tryCastVal(super.get(state));
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set(state, val);
        }

        private void read(SLK.Obj<? extends ObjId> slkObj) {
            this.merge(slkObj, true);
        }

        public Obj(SLK.Obj<? extends ObjId> slkObj) {
            super(BuffId.valueOf(slkObj.getId()));
            this.read(slkObj);
        }

        public Obj(BuffId id) {
            super(id);
        }

        @Override
        public void reduce() {
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<BuffId> OBJ_ID = new State<BuffId>("alias", BuffId.class);
        public static final State<BuffCode> DATA_CODE = new State<BuffCode>("code", BuffCode.class);
        public static final State<War3String> EDITOR_COMMENTS = new State<War3String>("comments", War3String.class);
        public static final State<War3Bool> DATA_IS_EFFECT = new State<War3Bool>("isEffect", War3Bool.class);
        public static final State<War3Int> EDITOR_VERSION = new State<War3Int>("version", War3Int.class);
        public static final State<War3Bool> EDITOR_IN_EDITOR = new State<War3Bool>("useInEditor", War3Bool.class);
        public static final State<War3String> EDITOR_SORT = new State<War3String>("sort", War3String.class);
        public static final State<UnitRace> DATA_RACE = new State<UnitRace>("race", UnitRace.class);
        public static final State<War3Bool> EDITOR_IN_BETA = new State<War3Bool>("InBeta", War3Bool.class);

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type) {
            super(idString, type);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
            super(idString, type, defVal);
        }
    }
}

