/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.peParser.headers;

import dorkbox.peParser.ByteArray;
import dorkbox.peParser.headers.Header;
import dorkbox.peParser.headers.SectionTableEntry;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldorkbox/peParser/headers/SectionTable;", "Ldorkbox/peParser/headers/Header;", "bytes", "Ldorkbox/peParser/ByteArray;", "numberOfEntries", "", "(Ldorkbox/peParser/ByteArray;I)V", "sections", "", "Ldorkbox/peParser/headers/SectionTableEntry;", "getSections", "()Ljava/util/List;", "setSections", "(Ljava/util/List;)V", "PeParser"})
public final class SectionTable
extends Header {
    @NotNull
    private List<SectionTableEntry> sections;

    public SectionTable(@NotNull ByteArray bytes, int numberOfEntries) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.sections = new ArrayList(numberOfEntries);
        bytes.mark();
        for (int i = 0; i < numberOfEntries; ++i) {
            int offset = i * 40;
            bytes.skip(offset);
            SectionTableEntry sectionTableEntry = new SectionTableEntry(bytes, i + 1, offset, 40);
            this.sections.add(sectionTableEntry);
            bytes.reset();
        }
    }

    @NotNull
    public final List<SectionTableEntry> getSections() {
        return this.sections;
    }

    public final void setSections(@NotNull List<SectionTableEntry> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.sections = list;
    }
}

