/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.luaAst;

import de.peeeq.wurstscript.luaAst.Element;
import de.peeeq.wurstscript.luaAst.LuaExpr;
import de.peeeq.wurstscript.luaAst.LuaExprFuncRef;
import de.peeeq.wurstscript.luaAst.LuaExprFunctionCall;
import de.peeeq.wurstscript.luaAst.LuaExprMethodCall;
import de.peeeq.wurstscript.luaAst.LuaExprOpt;
import de.peeeq.wurstscript.luaAst.LuaExprUnary;
import de.peeeq.wurstscript.luaAst.LuaExprVarAccess;
import de.peeeq.wurstscript.luaAst.LuaFunction;
import de.peeeq.wurstscript.luaAst.LuaMethod;
import de.peeeq.wurstscript.luaAst.LuaOpUnary;
import de.peeeq.wurstscript.luaAst.LuaStatement;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.translation.lua.printing.LuaPrinter;
import java.util.function.Consumer;

class LuaExprUnaryImpl
implements LuaExprUnary {
    private Element parent;
    private LuaOpUnary opU;
    private LuaExpr right;

    LuaExprUnaryImpl(LuaOpUnary opU, LuaExpr right) {
        if (opU == null) {
            throw new IllegalArgumentException("Element opU must not be null.");
        }
        if (right == null) {
            throw new IllegalArgumentException("Element right must not be null.");
        }
        this.opU = opU;
        this.right = right;
        opU.setParent(this);
        right.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setOpU(LuaOpUnary opU) {
        if (opU == null) {
            throw new IllegalArgumentException();
        }
        this.opU.setParent(null);
        opU.setParent(this);
        this.opU = opU;
    }

    @Override
    public LuaOpUnary getOpU() {
        return this.opU;
    }

    @Override
    public void setRight(LuaExpr right) {
        if (right == null) {
            throw new IllegalArgumentException();
        }
        this.right.setParent(null);
        right.setParent(this);
        this.right = right;
    }

    @Override
    public LuaExpr getRight() {
        return this.right;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.opU;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                LuaOpUnary oldElem = this.opU;
                this.setOpU((LuaOpUnary)newElem);
                return oldElem;
            }
            case 1: {
                LuaExpr oldElem = this.right;
                this.setRight((LuaExpr)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.opU);
        action.accept(this.right);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public LuaExprUnary copy() {
        LuaExprUnaryImpl result = new LuaExprUnaryImpl(this.opU.copy(), this.right.copy());
        return result;
    }

    @Override
    public LuaExprUnary copyWithRefs() {
        final LuaExprUnary res = this.copy();
        final LuaExprUnaryImpl self = this;
        res.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(LuaExprMethodCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getMethod(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setMethod((LuaMethod)res.followPath(self.pathTo(e.getMethod())));
                }
            }

            @Override
            public void visit(LuaExprFunctionCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }

            @Override
            public void visit(LuaExprVarAccess e) {
                Element elem;
                super.visit(e);
                for (elem = e.getVar(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setVar((LuaVariable)res.followPath(self.pathTo(e.getVar())));
                }
            }

            @Override
            public void visit(LuaExprFuncRef e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }
        });
        return res;
    }

    @Override
    public void clearAttributes() {
        this.opU.clearAttributes();
        this.right.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaExprUnary(this);
    }

    @Override
    public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaExprUnary(this);
    }

    @Override
    public <T> T match(LuaExpr.Matcher<T> matcher) {
        return matcher.case_LuaExprUnary(this);
    }

    @Override
    public void match(LuaExpr.MatcherVoid matcher) {
        matcher.case_LuaExprUnary(this);
    }

    @Override
    public <T> T match(LuaExprOpt.Matcher<T> matcher) {
        return matcher.case_LuaExprUnary(this);
    }

    @Override
    public void match(LuaExprOpt.MatcherVoid matcher) {
        matcher.case_LuaExprUnary(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaExprUnary(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaExprUnary(this);
    }

    public String toString() {
        return "LuaExprUnary(" + this.opU + ", " + this.right + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaExprUnary) {
            LuaExprUnary o = (LuaExprUnary)e;
            return this.opU.structuralEquals(o.getOpU()) && this.right.structuralEquals(o.getRight());
        }
        return false;
    }

    @Override
    public void print(StringBuilder sb, int indent) {
        LuaPrinter.print(this, sb, indent);
    }
}

