/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.txt.app.jass.expr.num;

import java.io.StringWriter;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.antlr.JassParser;
import net.moonlightflower.wc3libs.txt.app.jass.expr.Op;
import net.moonlightflower.wc3libs.txt.app.jass.expr.num.NumExpr;
import net.moonlightflower.wc3libs.txt.app.jass.expr.num.Prod;
import net.moonlightflower.wc3libs.txt.app.jass.expr.num.Sum;

public abstract class UnaryNumExpr
implements NumExpr {
    private Sign _sign;
    private NumExpr _expr;

    public UnaryNumExpr(@Nonnull Sign sign, @Nonnull NumExpr expr) {
        this._sign = sign;
        this._expr = expr;
    }

    public static Sign createOp(@Nonnull JassParser.Num_unary_opContext num_unary_opContext) {
        return ((Function<JassParser.Num_unary_opContext, Sign>)num_unary_opContext1 -> {
            if (num_unary_opContext1.ADD() != null) {
                return Sign.PLUS;
            }
            if (num_unary_opContext1.SUB() != null) {
                return Sign.MINUS;
            }
            throw new AssertionError((Object)("no option for " + num_unary_opContext1.getText()));
        }).apply(num_unary_opContext);
    }

    @Override
    public void write(@Nonnull StringWriter sw) {
        this._sign.write(sw);
        if (this._expr instanceof Sum || this._expr instanceof Prod) {
            sw.write("(");
        }
        this._expr.write(sw);
        if (this._expr instanceof Sum || this._expr instanceof Prod) {
            sw.write(")");
        }
    }

    public static enum Sign implements IUnaryOp
    {
        PLUS{

            @Override
            public void write(@Nonnull StringWriter sw) {
                sw.write("+");
            }
        }
        ,
        MINUS{

            @Override
            public void write(@Nonnull StringWriter sw) {
                sw.write("-");
            }
        };

    }

    public static interface IUnaryOp
    extends Op {
    }
}

