/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Format;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.dataTypes.app.Coords3DF;
import net.moonlightflower.wc3libs.dataTypes.app.Coords3DI;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObjId;

public class DOO {
    public static final File GAME_PATH = new File("war3map.doo");
    private List<Dood> _doods = new ArrayList<Dood>();
    private final List<SpecialDood> _specialDoods = new ArrayList<SpecialDood>();

    public List<Dood> getDoods() {
        return new ArrayList<Dood>(this._doods);
    }

    public void addDood(@Nonnull Dood val) {
        this._doods.add(val);
    }

    public void removeDood(@Nonnull Dood val) {
        this._doods.remove(val);
    }

    public void clearDoods() {
        this._doods.clear();
    }

    @Nonnull
    public Dood addDood() {
        Dood dood = new Dood();
        this.addDood(dood);
        return dood;
    }

    public List<SpecialDood> getSpecialDoods() {
        return new ArrayList<SpecialDood>(this._specialDoods);
    }

    public void addSpecialDood(@Nonnull SpecialDood val) {
        this._specialDoods.add(val);
    }

    public void removeSpecialDood(@Nonnull SpecialDood val) {
        this._specialDoods.remove(val);
    }

    public void clearSpecialDoods() {
        this._specialDoods.clear();
    }

    @Nonnull
    public SpecialDood addSpecialDood() {
        SpecialDood dood = new SpecialDood();
        this.addSpecialDood(dood);
        return dood;
    }

    private void read_0x8(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id startToken = stream.readId("startToken");
        int version = stream.readInt32("version");
        stream.checkFormatVersion(EncodingFormat.DOO_0x8.getVersion(), version);
        int subVersion = stream.readInt32("subVersion");
        int doodsCount = stream.readInt32("doodsCount");
        for (int i = 0; i < doodsCount; ++i) {
            this.addDood(new Dood(stream, EncodingFormat.DOO_0x8));
        }
    }

    private void write_0x8(@Nonnull Wc3BinOutputStream stream) {
        stream.writeId(Id.valueOf("W3do"));
        stream.writeInt32(EncodingFormat.DOO_0x8.getVersion());
        stream.writeInt32(11);
        stream.writeInt32(this._doods.size());
        for (Dood dood : this._doods) {
            dood.write(stream, EncodingFormat.DOO_0x8);
        }
    }

    private void read_auto(@Nonnull Wc3BinInputStream stream) throws IOException {
        Id startToken = stream.readId("startToken");
        int version = stream.readInt32("version");
        stream.rewind();
        EncodingFormat format = EncodingFormat.valueOf(version);
        if (format == null) {
            throw new IOException(String.format("unknown format %x", version));
        }
        this.read(stream, format, null);
    }

    private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format, @Nullable Special.EncodingFormat specialFormat) throws IOException {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case AUTO: {
                this.read_auto(stream);
                break;
            }
            case DOO_0x8: {
                this.read_0x8(stream);
            }
        }
        if (specialFormat == null) {
            return;
        }
        new Special(this).read(stream, specialFormat);
    }

    private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format, @Nullable Special.EncodingFormat specialFormat) {
        switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
            case DOO_0x8: 
            case AUTO: {
                this.write_0x8(stream);
            }
        }
        if (specialFormat == null) {
            return;
        }
        new Special(this).write(stream, specialFormat);
    }

    private void read(@Nonnull Wc3BinInputStream stream) throws IOException {
        this.read(stream, EncodingFormat.AUTO, Special.EncodingFormat.AUTO);
    }

    public void write(@Nonnull Wc3BinOutputStream stream) {
        this.write(stream, EncodingFormat.AUTO, Special.EncodingFormat.AUTO);
    }

    public void write(@Nonnull File file) throws IOException {
        Wc3BinOutputStream outStream = new Wc3BinOutputStream(file);
        this.write(outStream);
        outStream.close();
    }

    public DOO(@Nonnull Wc3BinInputStream stream) throws Exception {
        this.read(stream);
    }

    public DOO(@Nonnull File file) throws IOException {
        Wc3BinInputStream inStream = new Wc3BinInputStream(file);
        this.read(inStream);
        inStream.close();
    }

    public DOO() {
    }

    public static class EncodingFormat
    extends Format<Enum> {
        public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
        public static final EncodingFormat DOO_0x8 = new EncodingFormat(Enum.DOO_0x8, 8);

        @Nullable
        public static EncodingFormat valueOf(@Nonnull Integer version) {
            return EncodingFormat.get(EncodingFormat.class, version);
        }

        private EncodingFormat(@Nonnull Enum enumVal, int version) {
            super(enumVal, version);
        }

        public static enum Enum {
            AUTO,
            DOO_0x8;

        }
    }

    public static class Special {
        private final DOO _parent;

        private void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            int specialVersion = stream.readInt32("specialVersion");
            if (specialVersion != 0) {
                throw new IllegalArgumentException("unknown special format " + specialVersion + " (should be 0)");
            }
            int specialDoodsCount = stream.readInt32("specialDoodsCount");
            for (int i = 0; i < specialDoodsCount; ++i) {
                this._parent.addSpecialDood(new SpecialDood(stream, EncodingFormat.DOO_SPECIAL_0x0));
            }
        }

        private void write_0x0(@Nonnull Wc3BinOutputStream stream) {
            stream.writeInt32(EncodingFormat.DOO_SPECIAL_0x0.getVersion());
            stream.writeInt32(this._parent._specialDoods.size());
            for (SpecialDood dood : this._parent._specialDoods) {
                dood.write(stream, EncodingFormat.DOO_SPECIAL_0x0);
            }
        }

        private void read_auto(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            int specialVersion = stream.readInt32("specialVersion");
            stream.rewind(4L);
            EncodingFormat format = EncodingFormat.valueOf(specialVersion);
            if (format == null) {
                throw new IllegalArgumentException("unknown format " + specialVersion);
            }
            this.read(stream, format);
        }

        private void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case AUTO: {
                    this.read_auto(stream);
                    break;
                }
                case DOO_SPECIAL_0x0: {
                    this.read_0x0(stream);
                }
            }
        }

        private void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case DOO_SPECIAL_0x0: 
                case AUTO: {
                    this.write_0x0(stream);
                }
            }
        }

        private Special(@Nonnull DOO parent) {
            this._parent = parent;
        }

        public static class EncodingFormat
        extends Format<Enum> {
            private static final Map<Integer, EncodingFormat> _map = new LinkedHashMap<Integer, EncodingFormat>();
            public static final EncodingFormat AUTO = new EncodingFormat(Enum.AUTO, -1);
            public static final EncodingFormat DOO_SPECIAL_0x0 = new EncodingFormat(Enum.DOO_SPECIAL_0x0, 0);

            @Nullable
            public static EncodingFormat valueOf(int version) {
                return _map.get(version);
            }

            private EncodingFormat(@Nonnull Enum enumVal, int version) {
                super(enumVal, version);
                _map.put(version, this);
            }

            public static enum Enum {
                AUTO,
                DOO_SPECIAL_0x0;

            }
        }
    }

    public static class SpecialDood {
        private ObjId _typeId;
        private Coords3DI _pos = new Coords3DI(0, 0, 0);

        @Nonnull
        public ObjId getTypeId() {
            return this._typeId;
        }

        public void setTypeId(@Nonnull ObjId val) {
            this._typeId = val;
        }

        @Nonnull
        public Coords3DI getPos() {
            return this._pos;
        }

        public void setPos(@Nonnull Coords3DI val) {
            this._pos = val;
        }

        private void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this._typeId = ObjId.valueOf(stream.readId("typeId"));
            int z = stream.readInt32("z");
            int x = stream.readInt32("x");
            int y = stream.readInt32("y");
            this._pos = new Coords3DI(x, y, z);
        }

        private void write_0x0(@Nonnull Wc3BinOutputStream stream) {
            stream.writeId(this.getTypeId());
            Coords3DI pos = this.getPos();
            stream.writeInt32(pos.getZ());
            stream.writeInt32(pos.getX());
            stream.writeInt32(pos.getY());
        }

        public void read(@Nonnull Wc3BinInputStream stream, @Nonnull Special.EncodingFormat format) throws BinStream.StreamException {
            switch ((Special.EncodingFormat.Enum)((Object)format.toEnum())) {
                case DOO_SPECIAL_0x0: {
                    this.read_0x0(stream);
                }
            }
        }

        public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull Special.EncodingFormat format) {
            switch ((Special.EncodingFormat.Enum)((Object)format.toEnum())) {
                case DOO_SPECIAL_0x0: 
                case AUTO: {
                    this.write_0x0(stream);
                }
            }
        }

        public SpecialDood(@Nonnull Wc3BinInputStream stream, @Nonnull Special.EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public SpecialDood() {
        }
    }

    public static class Dood {
        private ObjId _typeId;
        private int _variation = 0;
        private Coords3DF _pos = new Coords3DF(0.0f, 0.0f, 0.0f);
        private float _angle = 0.0f;
        private Coords3DF _scale = new Coords3DF(0.0f, 0.0f, 0.0f);
        private ObjId _skinId = null;
        private byte _lifePerc = 1;
        private int _flags = 0;
        private int _itemTablePtr = 0;
        private List<ItemSet> _itemSets = new ArrayList<ItemSet>();
        private int _editorId = 0;

        public ObjId getTypeId() {
            return this._typeId;
        }

        public void setTypeId(ObjId val) {
            this._typeId = val;
        }

        public int getVariation() {
            return this._variation;
        }

        public void setVariation(int val) {
            this._variation = val;
        }

        public Coords3DF getPos() {
            return this._pos;
        }

        public void setPos(Coords3DF val) {
            this._pos = val;
        }

        public float getAngle() {
            return this._angle;
        }

        public void setAngle(float val) {
            this._angle = val;
        }

        public Coords3DF getScale() {
            return this._scale;
        }

        public void setScale(Coords3DF val) {
            this._scale = val;
        }

        public ObjId getSkinId() {
            return this._skinId;
        }

        public void setSkinId(ObjId val) {
            this._skinId = val;
        }

        public int getLifePerc() {
            return this._lifePerc;
        }

        public void setLifePerc(int val) {
            this._lifePerc = (byte)val;
        }

        public int getFlags() {
            return this._flags;
        }

        public void setFlags(int val) {
            this._flags = val;
        }

        public int getItemTablePtr() {
            return this._itemTablePtr;
        }

        public void setItemTablePtr(int val) {
            this._itemTablePtr = val;
        }

        private void addItemSet(ItemSet val) {
            this._itemSets.add(val);
        }

        public ItemSet addItemSet() {
            ItemSet set = new ItemSet();
            this.addItemSet(set);
            return set;
        }

        public int getEditorId() {
            return this._editorId;
        }

        public void setEditorId(int val) {
            this._editorId = val;
        }

        public void read_0x8(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
            this.setTypeId(ObjId.valueOf(stream.readId("typeId")));
            this.setVariation(stream.readInt32("variation"));
            this.setPos(new Coords3DF(stream.readFloat32("posX").floatValue(), stream.readFloat32("posY").floatValue(), stream.readFloat32("posZ").floatValue()));
            this.setAngle(stream.readFloat32("angle").floatValue());
            this.setScale(new Coords3DF(stream.readFloat32("scaleX").floatValue(), stream.readFloat32("scaleY").floatValue(), stream.readFloat32("scaleZ").floatValue()));
            short skinIdDiscriminator = stream.readUByte("skinIdDiscriminator");
            stream.rewind(1L);
            if (skinIdDiscriminator > 7) {
                this.setSkinId(ObjId.valueOf(stream.readId("skinId")));
            }
            this.setFlags(stream.readUByte("flags").shortValue());
            this.setLifePerc(stream.readUByte("lifePerc").shortValue());
            this.setItemTablePtr(stream.readInt32("itemTablePtr"));
            int itemSetsDroppedCount = stream.readInt32("itemSetsDroppedCount");
            for (int i = 0; i < itemSetsDroppedCount; ++i) {
                this.addItemSet(new ItemSet(stream, EncodingFormat.DOO_0x8));
            }
            this.setEditorId(stream.readInt32("editorId"));
        }

        public void write_0x8(@Nonnull Wc3BinOutputStream stream) {
            stream.writeId(this.getTypeId());
            stream.writeInt32(this.getVariation());
            Coords3DF pos = this.getPos();
            stream.writeFloat32(pos.getX());
            stream.writeFloat32(pos.getY());
            stream.writeFloat32(pos.getZ());
            stream.writeFloat32(this.getAngle());
            Coords3DF scale = this.getScale();
            stream.writeFloat32(scale.getX());
            stream.writeFloat32(scale.getY());
            stream.writeFloat32(scale.getZ());
            if (this.getSkinId() != null) {
                stream.writeId(this.getSkinId());
            }
            stream.writeUByte(this.getFlags());
            stream.writeUByte(this.getLifePerc());
            stream.writeInt32(this.getItemTablePtr());
            stream.writeInt32(this._itemSets.size());
            for (ItemSet set : this._itemSets) {
                set.write(stream, EncodingFormat.DOO_0x8);
            }
            stream.writeInt32(this._editorId);
        }

        public void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case DOO_0x8: {
                    this.read_0x8(stream);
                }
            }
        }

        public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
            switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                case DOO_0x8: 
                case AUTO: {
                    this.write_0x8(stream);
                }
            }
        }

        public Dood(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
            this.read(stream, format);
        }

        public Dood() {
        }

        public static class ItemSet {
            private final List<Item> _items = new ArrayList<Item>();

            @Nonnull
            public Item addItem(@Nonnull ObjId typeId, int chance) {
                Item item = new Item();
                this._items.add(item);
                item.setTypeId(typeId);
                item.setChance(chance);
                return item;
            }

            private void read_0x8(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
                int itemsCount = stream.readInt32("itemsCount");
                for (int i = 0; i < itemsCount && !stream.eof(); ++i) {
                    ObjId typeId = ObjId.valueOf(stream.readId("typeId"));
                    if (stream.eof()) break;
                    int chance = stream.readInt32("chance");
                    Item item = this.addItem(typeId, chance);
                }
            }

            private void write_0x8(@Nonnull Wc3BinOutputStream stream) {
                stream.writeInt32(this._items.size());
                for (Item item : this._items) {
                    stream.writeId(item.getTypeId());
                    stream.writeInt32(item.getChance());
                }
            }

            public void read(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case DOO_0x8: {
                        this.read_0x8(stream);
                    }
                }
            }

            public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull EncodingFormat format) {
                switch ((EncodingFormat.Enum)((Object)format.toEnum())) {
                    case DOO_0x8: 
                    case AUTO: {
                        this.write_0x8(stream);
                    }
                }
            }

            public ItemSet(@Nonnull Wc3BinInputStream stream, @Nonnull EncodingFormat format) throws BinStream.StreamException {
                this.read(stream, format);
            }

            public ItemSet() {
            }

            public static class Item {
                private ObjId _typeId;
                private int _chance = 100;

                @Nonnull
                public ObjId getTypeId() {
                    return this._typeId;
                }

                public void setTypeId(@Nonnull ObjId val) {
                    this._typeId = val;
                }

                public int getChance() {
                    return this._chance;
                }

                public void setChance(int val) {
                    this._chance = val;
                }
            }
        }
    }
}

