/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.parseq.grammars.ast;

import de.peeeq.parseq.grammars.ast.ProdType;
import de.peeeq.parseq.grammars.ast.Production;
import de.peeeq.parseq.grammars.ast.RepeatType;
import org.antlr.v4.runtime.Token;

public class ProdRepeat
extends Production {
    public final Production prod;
    public final RepeatType repType;

    public ProdRepeat(Production prod, RepeatType repType) {
        this.prod = prod;
        this.repType = repType;
        prod.setParent(this);
    }

    public static Production create(Production p, Token mod) {
        RepeatType repType;
        if (mod == null) {
            return p;
        }
        switch (mod.getText()) {
            case "+": {
                repType = RepeatType.AT_LEAST_ONCE;
                break;
            }
            case "*": {
                repType = RepeatType.ARBITRARY;
                break;
            }
            case "?": {
                repType = RepeatType.ZERO_OR_ONCE;
                break;
            }
            default: {
                throw new Error(mod.getText());
            }
        }
        return new ProdRepeat(p, repType);
    }

    @Override
    public void print(StringBuilder tr) {
        tr.append("(");
        this.prod.print(tr);
        tr.append(")");
        switch (this.repType) {
            case ARBITRARY: {
                tr.append("*");
                break;
            }
            case AT_LEAST_ONCE: {
                tr.append("+");
                break;
            }
            case ZERO_OR_ONCE: {
                tr.append("+");
            }
        }
    }

    @Override
    public ProdType getType() {
        return this.prod.getType();
    }
}

