/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.parseq.grammars.ast;

import com.google.common.collect.Lists;
import de.peeeq.parseq.asts.ast.AstEntityDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GrammarReturnType {
    private final List<NamedType> returnedTypes;

    public GrammarReturnType(String name, AstEntityDefinition entity) {
        this.returnedTypes = Collections.singletonList(new NamedType(name, entity));
    }

    public GrammarReturnType(List<NamedType> returnedTypes) {
        this.returnedTypes = returnedTypes;
    }

    public static GrammarReturnType or(List<GrammarReturnType> ts) {
        ArrayList<NamedType> r = Lists.newArrayList();
        int i = 0;
        while (i < ts.get(0).getReturnedTypes().size()) {
            ++i;
        }
        return new GrammarReturnType(r);
    }

    public static GrammarReturnType sequence(List<GrammarReturnType> ts) {
        ArrayList<NamedType> r = Lists.newArrayList();
        return new GrammarReturnType(r);
    }

    public List<NamedType> getReturnedTypes() {
        return this.returnedTypes;
    }

    public static class NamedType {
        public final String name;
        public final AstEntityDefinition entity;

        public NamedType(String name, AstEntityDefinition entity) {
            this.name = name;
            this.entity = entity;
        }
    }
}

