/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.parseq.grammars;

import de.peeeq.parseq.asts.FileGenerator;
import de.peeeq.parseq.asts.ast.Program;
import de.peeeq.parseq.grammars.ast.GrammarFile;
import de.peeeq.parseq.grammars.ast.Rule;

public class GrammarTranslation {
    private final GrammarFile grammar;
    private final StringBuilder sb = new StringBuilder();
    private final Program prog;
    private FileGenerator fileGenerator;

    public GrammarTranslation(FileGenerator fileGenerator, GrammarFile g, Program prog) {
        this.fileGenerator = fileGenerator;
        this.grammar = g;
        this.prog = prog;
    }

    public void translate() {
        this.sb.append("//generated by parseq\n\n");
        this.sb.append("grammar " + this.prog.getLastPackagePart() + ";\n\n");
        for (Rule r : this.grammar.rules) {
            this.translateRule(r);
        }
        this.fileGenerator.createFile("grammar.g4", this.sb);
        System.out.println(this.sb.toString());
    }

    private void translateRule(Rule r) {
        if (r.production.getParent() == null) {
            throw new Error("wtf " + r);
        }
        this.sb.append(r.name);
        if (!r.returnType.equals("void")) {
            this.sb.append(" returns [" + r.returnType + " result] ");
        }
        this.sb.append(":\n");
        r.production.print(this.sb);
        this.sb.append(r.production.getType());
        this.sb.append(";\n\n");
    }

    public void print(String s) {
        this.sb.append(s);
    }
}

