/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.parseq.asts.ast;

import de.peeeq.parseq.asts.ast.AstEntityDefinition;
import de.peeeq.parseq.asts.ast.AttributeDef;
import de.peeeq.parseq.asts.ast.CaseDef;
import de.peeeq.parseq.asts.ast.ConstructorDef;
import de.peeeq.parseq.asts.ast.ListDef;
import de.peeeq.parseq.asts.ast.Parameter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Program {
    public final List<ListDef> listDefs = new LinkedList<ListDef>();
    public final List<CaseDef> caseDefs = new LinkedList<CaseDef>();
    public final List<ConstructorDef> constructorDefs = new LinkedList<ConstructorDef>();
    public final List<AttributeDef> attrDefs = new LinkedList<AttributeDef>();
    public final Map<String, AstEntityDefinition> definitions = new HashMap<String, AstEntityDefinition>();
    private String packageName;

    public Program(String packageName) {
        this.packageName = packageName;
    }

    private void addDefinition(String name, AstEntityDefinition def) {
        if (this.definitions.containsKey(name)) {
            throw new Error("Name " + name + " redefined.");
        }
        this.definitions.put(name, def);
    }

    public void addConstructorDef(ConstructorDef c) {
        this.addDefinition(c.name, c);
        this.constructorDefs.add(c);
    }

    public void addListDef(ListDef listDef) {
        this.addDefinition(listDef.name, listDef);
        this.listDefs.add(listDef);
    }

    public void addCaseDef(CaseDef caseDef) {
        this.addDefinition(caseDef.name, caseDef);
        this.caseDefs.add(caseDef);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void addAttribute(List<Parameter> parameters, String typ, String attr, String returnType, String implementedBy, String doc, String circular) {
        String docStr = doc != null ? doc : "";
        this.attrDefs.add(new AttributeDef(parameters, typ, attr, docStr, returnType, implementedBy, circular));
    }

    public AstEntityDefinition getElement(String sub) {
        return this.definitions.get(sub);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nCase Types: \n");
        for (CaseDef caseDef : this.caseDefs) {
            sb.append(caseDef + "\n");
        }
        sb.append("\nConstructors: \n");
        for (ConstructorDef constructorDef : this.constructorDefs) {
            sb.append(constructorDef + "\n");
        }
        sb.append("\nLists: \n");
        for (ListDef listDef : this.listDefs) {
            sb.append(listDef + "\n");
        }
        return sb.toString();
    }

    public String getLastPackagePart() {
        int pos = this.packageName.lastIndexOf(46);
        if (pos >= 0) {
            return this.packageName.substring(pos + 1);
        }
        return this.packageName;
    }

    public boolean hasElement(String e) {
        return this.definitions.containsKey(e);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}

