/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.parseq.asts;

public class TemplateParseqList {
    public static void writeTo(StringBuilder sb) {
        sb.append("import java.util.Collection;\n");
        sb.append("import java.util.Iterator;\n");
        sb.append("import java.util.ArrayList;\n");
        sb.append("import java.util.List;\n");
        sb.append("import java.util.ListIterator;\n");
        sb.append("\n");
        sb.append("abstract class ParseqList<T> implements List<T> {\n");
        sb.append("\t\n");
        sb.append("\tprivate List<T> list = new ArrayList<T>();\n");
        sb.append("\t\n");
        sb.append("\tabstract protected void other_setParentToThis(T t);\n");
        sb.append("\tabstract protected void other_clearParent(T t);\n");
        sb.append("\t\n");
        sb.append("\tpublic boolean add(T t) {\n");
        sb.append("\t\tother_setParentToThis(t);\n");
        sb.append("\t\treturn list.add(t);\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\tpublic void addFront(T t) { add(0, t); }\n");
        sb.append("\tpublic List<T> removeAll() {\n");
        sb.append("\t\tList<T> result = new ArrayList<T>();\n");
        sb.append("\t\twhile (!isEmpty()) {\n");
        sb.append("\t\t\tresult.add(remove(0));\n");
        sb.append("\t\t}\n");
        sb.append("\t\treturn result;\n");
        sb.append("\t}\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic void add(int index, T elem) {\n");
        sb.append("\t\tother_setParentToThis(elem);\n");
        sb.append("\t\tlist.add(index, elem);\t\t\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic boolean addAll(Collection<? extends T> c) {\n");
        sb.append("\t\tfor (T t: c) {\n");
        sb.append("\t\t\tother_setParentToThis(t);\n");
        sb.append("\t\t}\n");
        sb.append("\t\treturn list.addAll(c);\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic boolean addAll(int pos, Collection<? extends T> c) {\n");
        sb.append("\t\tfor (T t: c) {\n");
        sb.append("\t\t\tother_setParentToThis(t);\n");
        sb.append("\t\t}\n");
        sb.append("\t\treturn list.addAll(pos, c);\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic void clear() {\n");
        sb.append("\t\tfor (T t : list) {\n");
        sb.append("\t\t\tother_clearParent(t);\n");
        sb.append("\t\t}\n");
        sb.append("\t\tlist.clear();\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic boolean contains(Object arg0) {\n");
        sb.append("\t\treturn list.contains(arg0);\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic boolean containsAll(Collection<?> c) {\n");
        sb.append("\t\treturn list.containsAll(c);\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic T get(int index) {\n");
        sb.append("\t\treturn list.get(index);\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic int indexOf(Object o) {\n");
        sb.append("\t\treturn list.indexOf(o);\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic boolean isEmpty() {\n");
        sb.append("\t\treturn list.isEmpty();\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic Iterator<T> iterator() {\n");
        sb.append("\t\treturn list.iterator();\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic int lastIndexOf(Object o) {\n");
        sb.append("\t\treturn list.lastIndexOf(o);\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic ListIterator<T> listIterator(int index) {\n");
        sb.append("\t\treturn new ParseqListIterator(list.listIterator(index));\n");
        sb.append("\t}\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic ListIterator<T> listIterator() {\n");
        sb.append("\t\treturn new ParseqListIterator(list.listIterator());\n");
        sb.append("\t}\n");
        sb.append("\t\n");
        sb.append("\tclass ParseqListIterator implements ListIterator<T> {\n");
        sb.append("\n");
        sb.append("\t\tprivate ListIterator<T> it;\n");
        sb.append("\t\tprivate T lastElement;\n");
        sb.append("\n");
        sb.append("\t\tpublic ParseqListIterator(ListIterator<T> listIterator) {\n");
        sb.append("\t\t\tthis.it = listIterator;\n");
        sb.append("\t\t}\n");
        sb.append("\n");
        sb.append("\t\t@Override\n");
        sb.append("\t\tpublic void add(T e) {\n");
        sb.append("\t\t\tother_setParentToThis(e);\n");
        sb.append("\t\t\tit.add(e);\n");
        sb.append("\t\t}\n");
        sb.append("\n");
        sb.append("\t\t@Override\n");
        sb.append("\t\tpublic boolean hasNext() {\n");
        sb.append("\t\t\treturn it.hasNext();\n");
        sb.append("\t\t}\n");
        sb.append("\n");
        sb.append("\t\t@Override\n");
        sb.append("\t\tpublic boolean hasPrevious() {\n");
        sb.append("\t\t\treturn it.hasPrevious();\n");
        sb.append("\t\t}\n");
        sb.append("\n");
        sb.append("\t\t@Override\n");
        sb.append("\t\tpublic T next() {\n");
        sb.append("\t\t\tlastElement = it.next();\n");
        sb.append("\t\t\treturn lastElement;\n");
        sb.append("\t\t}\n");
        sb.append("\n");
        sb.append("\t\t@Override\n");
        sb.append("\t\tpublic int nextIndex() {\n");
        sb.append("\t\t\treturn it.nextIndex();\n");
        sb.append("\t\t}\n");
        sb.append("\n");
        sb.append("\t\t@Override\n");
        sb.append("\t\tpublic T previous() {\n");
        sb.append("\t\t\tlastElement = it.previous();\n");
        sb.append("\t\t\treturn lastElement;\n");
        sb.append("\t\t}\n");
        sb.append("\n");
        sb.append("\t\t@Override\n");
        sb.append("\t\tpublic int previousIndex() {\n");
        sb.append("\t\t\treturn it.previousIndex();\n");
        sb.append("\t\t}\n");
        sb.append("\n");
        sb.append("\t\t@Override\n");
        sb.append("\t\tpublic void remove() {\n");
        sb.append("\t\t\tif (lastElement == null) throw new Error();\n");
        sb.append("\t\t\tother_clearParent(lastElement);\n");
        sb.append("\t\t\tlastElement = null;\n");
        sb.append("\t\t\tit.remove();\n");
        sb.append("\t\t}\n");
        sb.append("\n");
        sb.append("\t\t@Override\n");
        sb.append("\t\tpublic void set(T e) {\n");
        sb.append("\t\t\tif (lastElement == null) throw new Error();\n");
        sb.append("\t\t\tother_clearParent(lastElement);\n");
        sb.append("\t\t\tlastElement = null;\n");
        sb.append("\t\t\tother_setParentToThis(e);\n");
        sb.append("\t\t\tit.set(e);\n");
        sb.append("\t\t}\n");
        sb.append("\t\t\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append(" @SuppressWarnings(\"unchecked\")\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic boolean remove(Object o) {\n");
        sb.append("\t\tif (list.remove(o)) {\n");
        sb.append("\t\t\tother_clearParent((T) o);\n");
        sb.append("\t\t\treturn true;\n");
        sb.append("\t\t}\n");
        sb.append("\t\treturn false;\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic T remove(int index) {\n");
        sb.append("\t\tT t = list.remove(index);\n");
        sb.append("\t\tother_clearParent(t);\n");
        sb.append("\t\treturn t;\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic boolean removeAll(Collection<?> c) {\n");
        sb.append("\t\tboolean changed = false;\n");
        sb.append("\t\tfor (Object o : c) {\n");
        sb.append("\t\t\tchanged = remove(o) || changed; // order important here\n");
        sb.append("\t\t}\n");
        sb.append("\t\treturn true;\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic boolean retainAll(Collection<?> c) {\n");
        sb.append("\t\tListIterator<T> li = list.listIterator();\n");
        sb.append("\t\tboolean changed = false;\n");
        sb.append("\t\twhile (li.hasNext()) {\n");
        sb.append("\t\t\tT t = li.next();\n");
        sb.append("\t\t\tif (!c.contains(t)) {\n");
        sb.append("\t\t\t\tli.remove();\n");
        sb.append("\t\t\t\tother_clearParent(t);\n");
        sb.append("\t\t\t\tchanged  = true;\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t}\n");
        sb.append("\t\treturn changed;\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic T set(int index, T element) {\n");
        sb.append("\t\tother_setParentToThis(element);\n");
        sb.append("\t\tT t = list.set(index, element);\t\t\n");
        sb.append("\t\tother_clearParent(t);\n");
        sb.append("\t\treturn t;\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic int size() {\n");
        sb.append("\t\treturn list.size();\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic List<T> subList(int fromIndex, int toIndex) {\n");
        sb.append("\t\treturn list.subList(fromIndex, toIndex);\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic Object[] toArray() {\n");
        sb.append("\t\treturn list.toArray();\n");
        sb.append("\t}\n");
        sb.append("\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic <S> S[] toArray(S[] a) {\n");
        sb.append("\t\treturn list.toArray(a);\n");
        sb.append("\t}\n");
        sb.append("\t\n");
        sb.append("\t\n");
        sb.append("\t\n");
        sb.append("}\n");
    }
}

