/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.parseq.grammars.ast;

import com.google.common.collect.Lists;
import de.peeeq.parseq.grammars.ast.ProdType;
import de.peeeq.parseq.grammars.ast.Production;
import de.peeeq.parseq.grammars.parser.GrammarsParserParser;
import java.util.List;

public class ProdAlternative
extends Production {
    public final List<Production> alternatives = Lists.newArrayList();

    public ProdAlternative(List<GrammarsParserParser.GExprPartsContext> alts) {
        for (GrammarsParserParser.GExprPartsContext g : alts) {
            this.alternatives.add(g.result);
            g.result.setParent(this);
        }
    }

    @Override
    public void print(StringBuilder tr) {
        boolean first = true;
        tr.append("(");
        for (Production a : this.alternatives) {
            if (!first) {
                tr.append(") | (");
            }
            a.print(tr);
            first = false;
        }
        tr.append(")");
    }

    @Override
    public ProdType getType() {
        ProdType result = new ProdType();
        for (Production p : this.alternatives) {
            result = result.alternative(p.getType());
        }
        return result;
    }
}

