/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.parseq.asts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.peeeq.parseq.asts.FileGenerator;
import de.peeeq.parseq.asts.JavaTypes;
import de.peeeq.parseq.asts.TemplateCyclicDependencyError;
import de.peeeq.parseq.asts.TemplateParseqList;
import de.peeeq.parseq.asts.ast.Alternative;
import de.peeeq.parseq.asts.ast.AstBaseTypeDefinition;
import de.peeeq.parseq.asts.ast.AstEntityDefinition;
import de.peeeq.parseq.asts.ast.AttributeDef;
import de.peeeq.parseq.asts.ast.CaseDef;
import de.peeeq.parseq.asts.ast.ConstructorDef;
import de.peeeq.parseq.asts.ast.ListDef;
import de.peeeq.parseq.asts.ast.Parameter;
import de.peeeq.parseq.asts.ast.Program;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Generator {
    private Multimap<CaseDef, AstBaseTypeDefinition> baseTypes = HashMultimap.create();
    private Multimap<AstEntityDefinition, AstEntityDefinition> directChildTypes = HashMultimap.create();
    private Multimap<AstEntityDefinition, AstEntityDefinition> directParentType = HashMultimap.create();
    private Multimap<AstEntityDefinition, AstEntityDefinition> directSubTypes = HashMultimap.create();
    private Multimap<AstEntityDefinition, AstEntityDefinition> directSuperTypes = HashMultimap.create();
    private Multimap<AstBaseTypeDefinition, CaseDef> interfaceTypes = HashMultimap.create();
    private String mainName;
    private String packageName;
    private Program prog;
    private Multimap<AstEntityDefinition, AstEntityDefinition> transientChildTypes = HashMultimap.create();
    private Multimap<AstEntityDefinition, AstEntityDefinition> transientSubTypes;
    private Multimap<AstEntityDefinition, AstEntityDefinition> transientSuperTypes;
    private Map<String, Parameter> parameters = Maps.newLinkedHashMap();
    private final FileGenerator fileGenerator;

    public Generator(FileGenerator fileGenerator, Program prog, String p_outputFolder) {
        System.out.println(prog);
        this.fileGenerator = fileGenerator;
        this.prog = prog;
        this.packageName = prog.getPackageName();
        this.mainName = prog.getLastPackagePart();
    }

    private void caclulateCaseDefBaseTypes(CaseDef caseDef) {
        if (this.baseTypes.containsKey(caseDef)) {
            return;
        }
        for (AstEntityDefinition sub : this.directSubTypes.get(caseDef)) {
            if (sub instanceof AstBaseTypeDefinition) {
                this.baseTypes.put(caseDef, (AstBaseTypeDefinition)sub);
                continue;
            }
            if (!(sub instanceof CaseDef)) continue;
            CaseDef caseDef2 = (CaseDef)sub;
            this.caclulateCaseDefBaseTypes(caseDef2);
            for (AstBaseTypeDefinition sub2 : this.baseTypes.get(caseDef2)) {
                this.baseTypes.put(caseDef, sub2);
            }
        }
    }

    private Set<Parameter> calculateAttributes(CaseDef c) {
        AbstractSet commonAttributes = null;
        for (AstBaseTypeDefinition base : this.baseTypes.get(c)) {
            if (base instanceof ConstructorDef) {
                ConstructorDef baseClass = (ConstructorDef)base;
                LinkedHashSet<Parameter> attributes = Sets.newLinkedHashSet();
                for (Parameter p : baseClass.parameters) {
                    attributes.add(p);
                }
                if (commonAttributes == null) {
                    commonAttributes = attributes;
                    continue;
                }
                commonAttributes = Sets.intersection(commonAttributes, attributes);
                continue;
            }
            if (base instanceof ListDef) {
                return Sets.newLinkedHashSet();
            }
            throw new Error("Case not possible.");
        }
        if (commonAttributes == null) {
            commonAttributes = Sets.newLinkedHashSet();
        }
        return commonAttributes;
    }

    private void calculateContainments() {
        for (ConstructorDef c : this.prog.constructorDefs) {
            for (Parameter a : c.parameters) {
                this.addContainmentInfo(c, this.prog.getElement(a.typ));
            }
        }
        for (ListDef l : this.prog.listDefs) {
            this.addContainmentInfo(l, this.prog.getElement(l.itemType));
        }
        this.calculateTransientChildTypes();
    }

    private void calculateTransientChildTypes() {
        HashMultimap newTransitions;
        boolean changed;
        this.transientChildTypes = HashMultimap.create();
        this.transientChildTypes.putAll(this.directChildTypes);
        do {
            newTransitions = HashMultimap.create();
            for (Map.Entry<AstEntityDefinition, AstEntityDefinition> e : this.transientChildTypes.entries()) {
                AstEntityDefinition parent = e.getKey();
                AstEntityDefinition child = e.getValue();
                newTransitions.put(parent, parent);
                newTransitions.put(child, child);
                for (AstEntityDefinition trChild : this.transientChildTypes.get(child)) {
                    newTransitions.put(parent, trChild);
                }
                for (AstEntityDefinition sub : this.transientSubTypes.get(child)) {
                    newTransitions.put(parent, sub);
                }
                for (AstEntityDefinition sup : this.transientSuperTypes.get(parent)) {
                    newTransitions.put(sup, child);
                }
            }
        } while (changed = this.transientChildTypes.putAll(newTransitions));
    }

    private void addContainmentInfo(AstEntityDefinition parent, AstEntityDefinition child) {
        this.directParentType.put(child, parent);
        this.directChildTypes.put(parent, child);
    }

    private void calculateSubTypes() {
        for (CaseDef caseDef : this.prog.caseDefs) {
            for (Alternative alt : caseDef.alternatives) {
                AstEntityDefinition subType = this.prog.getElement(alt.name);
                this.directSubTypes.put(caseDef, subType);
                this.directSuperTypes.put(subType, caseDef);
            }
        }
        for (CaseDef caseDef : this.prog.caseDefs) {
            this.caclulateCaseDefBaseTypes(caseDef);
        }
        for (CaseDef caseDef : this.prog.caseDefs) {
            for (AstBaseTypeDefinition base : this.baseTypes.get(caseDef)) {
                this.interfaceTypes.put(base, caseDef);
            }
        }
        this.transientSubTypes = this.transientClosure(this.directSubTypes);
        this.transientSuperTypes = this.transientClosure(this.directSuperTypes);
    }

    private void createMatchMethods(AstBaseTypeDefinition c, StringBuilder sb) {
        for (CaseDef superType : this.interfaceTypes.get(c)) {
            sb.append("\t@Override public <T> T match(" + superType.name + ".Matcher<T> matcher) {\n");
            sb.append("\t\treturn matcher.case_" + c.getName() + "(this);\n");
            sb.append("\t}\n");
            sb.append("\t@Override public void match(" + superType.name + ".MatcherVoid matcher) {\n");
            sb.append("\t\tmatcher.case_" + c.getName() + "(this);\n");
            sb.append("\t}\n\n");
        }
    }

    public void generate() {
        System.out.println("calculating types ... ");
        this.calculateProperties();
        this.calculateSubTypes();
        this.calculateContainments();
        this.generatePackageInfo();
        this.generateStandardClasses();
        this.generateStandardList();
        this.generateCyclicDependencyError();
        System.out.println("generating property interfaces ... ");
        this.generatePropertyInterfaces();
        System.out.println("generating interfaces ... ");
        this.generateInterfaceTypes();
        System.out.println("generating base classes ... ");
        this.generateBaseClasses();
        System.out.println("generating list classes ...");
        this.generateLists();
        this.generateFactoryClass();
        System.out.println("Done.");
    }

    private void generatePackageInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("//generated by parseq\n");
        sb.append("@org.eclipse.jdt.annotation.NonNullByDefault\n");
        sb.append("package " + this.packageName + ";\n\n");
        this.fileGenerator.createFile("package-info.java", sb);
    }

    private void generatePropertyInterfaces() {
        for (Parameter p : this.parameters.values()) {
            String interfaceName = this.getPropertyInterfaceName(p);
            StringBuilder sb = new StringBuilder();
            this.printProlog(sb);
            sb.append("public interface ");
            sb.append(interfaceName);
            sb.append(" extends ");
            sb.append(this.getCommonSupertypeType());
            sb.append(" { ");
            sb.append("\tvoid set" + this.toFirstUpper(p.name) + "(" + p.typ + " " + p.name + ");\n");
            sb.append("\t" + p.typ + " get" + this.toFirstUpper(p.name) + "();\n");
            sb.append("}\n");
            this.fileGenerator.createFile(String.valueOf(interfaceName) + ".java", sb);
        }
    }

    private void calculateProperties() {
        for (ConstructorDef c : this.prog.constructorDefs) {
            for (Parameter p : c.parameters) {
                Parameter oldP = this.parameters.put(p.name, p);
                if (oldP == null || oldP.typ.equals(p.typ)) continue;
                throw new Error("The property " + p.name + " has not the same type for each element: " + oldP.typ + " and " + p.typ);
            }
        }
    }

    private void generateBaseClass_Impl(ConstructorDef c) {
        StringBuilder sb = new StringBuilder();
        this.printProlog(sb);
        this.addSuppressWarningAnnotations(sb);
        sb.append("class " + c.name + "Impl implements ");
        sb.append(String.valueOf(c.name) + ", " + this.getCommonSupertypeType() + "Intern {\n");
        this.createConstructor(c, sb);
        this.createGetSetParentMethods(sb);
        this.createGetterAndSetterMethods(c, sb);
        int childCount = this.createGetMethod(c, sb);
        this.createSetMethod(c, sb);
        this.createSizeMethod(sb, childCount);
        this.createCopyMethod(c, sb);
        this.createClearMethod(c, sb);
        this.createAcceptMethods(c, sb);
        this.createMatchMethods(c, sb);
        this.createToString(c, sb);
        this.createAttributeImpl(c, sb);
        sb.append("}\n");
        this.fileGenerator.createFile(String.valueOf(c.name) + "Impl.java", sb);
    }

    private void createAttributeImpl(AstBaseTypeDefinition c, StringBuilder sb) {
        for (AttributeDef attr : this.prog.attrDefs) {
            if (!this.hasAttribute(c, attr)) continue;
            if (attr.parameters == null) {
                sb.append("// circular = " + attr.circular + "\n");
                if (attr.circular == null) {
                    sb.append("\tprivate int zzattr_" + attr.attr + "_state = 0;\n");
                    sb.append("\tprivate " + attr.returns + " zzattr_" + attr.attr + "_cache;\n");
                    sb.append("/** " + attr.comment + "*/\n");
                    sb.append("\tpublic " + attr.returns + " " + attr.attr + "() {\n");
                    sb.append("\t\tif (zzattr_" + attr.attr + "_state == 0) {\n");
                    sb.append("\t\t\tzzattr_" + attr.attr + "_state = 1;\n");
                    sb.append("\t\t\tzzattr_" + attr.attr + "_cache = " + attr.implementedBy + "((" + c.getName() + ")this);\n");
                    sb.append("\t\t\tzzattr_" + attr.attr + "_state = 2;\n");
                    sb.append("\t\t} else if (zzattr_" + attr.attr + "_state == 1) {\n");
                    sb.append("\t\t\tthrow new CyclicDependencyError(this, \"" + attr.attr + "\");\n");
                    sb.append("\t\t}\n");
                    sb.append("\t\treturn zzattr_" + attr.attr + "_cache;\n");
                    sb.append("\t}\n");
                    continue;
                }
                sb.append("\tprivate int zzattr_" + attr.attr + "_state = 0;\n");
                sb.append("\tprivate " + attr.returns + " zzattr_" + attr.attr + "_cache;\n");
                sb.append("/** " + attr.comment + "*/\n");
                sb.append("\tpublic " + attr.returns + " " + attr.attr + "() {\n");
                sb.append("\t\tif (zzattr_" + attr.attr + "_state == 0) {\n");
                sb.append("\t\t\tzzattr_" + attr.attr + "_state = 1;\n");
                sb.append("\t\t\tzzattr_" + attr.attr + "_cache = " + attr.circular + "();\n");
                sb.append("\t\t\twhile (true) {\n");
                sb.append("\t\t\t\t" + attr.returns + " r = " + attr.implementedBy + "((" + c.getName() + ")this);\n");
                sb.append("\t\t\t\tif (zzattr_" + attr.attr + "_state == 3) {\n");
                sb.append("\t\t\t\t\tif (!zzattr_" + attr.attr + "_cache.equals(r)) {\n");
                sb.append("\t\t\t\t\t\tzzattr_" + attr.attr + "_cache = r;\n");
                sb.append("\t\t\t\t\t\tcontinue;\n");
                sb.append("\t\t\t\t\t}\n");
                sb.append("\t\t\t\t}\n");
                sb.append("\t\t\t\tzzattr_" + attr.attr + "_cache = r;\n");
                sb.append("\t\t\t\tbreak;\n");
                sb.append("\t\t\t}\n");
                sb.append("\t\t\tzzattr_" + attr.attr + "_state = 2;\n");
                sb.append("\t\t} else if (zzattr_" + attr.attr + "_state == 1) {\n");
                sb.append("\t\t\tzzattr_" + attr.attr + "_state = 3;\n");
                sb.append("\t\t}\n");
                sb.append("\t\treturn zzattr_" + attr.attr + "_cache;\n");
                sb.append("\t}\n");
                continue;
            }
            sb.append("/** " + attr.comment + "*/\n");
            sb.append("\tpublic " + attr.returns + " " + attr.attr + "(" + this.printParams(attr.parameters) + ") {\n");
            if (attr.returns.equals("void")) {
                sb.append("\t\t" + attr.implementedBy + "((" + c.getName() + ")this" + this.printArgs(attr.parameters) + ");\n");
            } else {
                sb.append("\t\treturn " + attr.implementedBy + "((" + c.getName() + ")this" + this.printArgs(attr.parameters) + ");\n");
            }
            sb.append("\t}\n");
        }
    }

    private String printArgs(List<Parameter> parameters2) {
        String result = "";
        for (Parameter p : parameters2) {
            result = String.valueOf(result) + ", " + p.name;
        }
        return result;
    }

    private String printParams(List<Parameter> parameters2) {
        if (parameters2 == null) {
            return "";
        }
        String result = "";
        boolean first = true;
        for (Parameter p : parameters2) {
            if (!first) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + p.typ + " " + p.name;
            first = false;
        }
        return result;
    }

    private void createConstructor(ConstructorDef c, StringBuilder sb) {
        sb.append("\t" + c.name + "Impl(");
        boolean first = true;
        for (Parameter p : c.parameters) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(String.valueOf(p.typ) + " " + p.name);
            first = false;
        }
        sb.append(") {\n");
        for (Parameter p : c.parameters) {
            if (!JavaTypes.primitiveTypes.contains(p.typ)) {
                sb.append("\t\tif (" + p.name + " == null) throw new IllegalArgumentException();\n");
                if (this.isGeneratedTyp(p.typ) && !p.isRef) {
                    sb.append("\t\t((" + this.getCommonSupertypeType() + "Intern)" + p.name + ").setParent(this);\n");
                }
            }
            sb.append("\t\tthis." + p.name + " = " + p.name + ";\n");
        }
        sb.append("\t}\n\n");
    }

    private boolean isGeneratedTyp(String typ) {
        for (CaseDef caseDef : this.prog.caseDefs) {
            if (!caseDef.getName().equals(typ)) continue;
            return true;
        }
        for (ConstructorDef constructorDef : this.prog.constructorDefs) {
            if (!constructorDef.getName().equals(typ)) continue;
            return true;
        }
        for (ListDef listDef : this.prog.listDefs) {
            if (!listDef.getName().equals(typ)) continue;
            return true;
        }
        return false;
    }

    private void createGetSetParentMethods(StringBuilder sb) {
        sb.append("\tprivate " + this.getCommonSupertypeType() + " parent;\n");
        sb.append("\tpublic @org.eclipse.jdt.annotation.Nullable " + this.getCommonSupertypeType() + " getParent() { return parent; }\n");
        sb.append("\tpublic void setParent(@org.eclipse.jdt.annotation.Nullable " + this.getCommonSupertypeType() + " parent) {\n" + "\t\tif (parent != null && this.parent != null) { " + "\t\t\tthrow new Error(\"Parent of \" + this + \" already set: \" + this.parent + \"\\ntried to change to \" + parent); " + "\t\t}\n" + "\t\tthis.parent = parent;\n" + "\t}\n\n");
    }

    private void createGetterAndSetterMethods(ConstructorDef c, StringBuilder sb) {
        for (Parameter p : c.parameters) {
            sb.append("\tprivate " + p.typ + " " + p.name + ";\n");
            sb.append("\tpublic void set" + this.toFirstUpper(p.name) + "(" + p.typ + " " + p.name + ") {\n");
            if (!JavaTypes.primitiveTypes.contains(p.typ)) {
                sb.append("\t\tif (" + p.name + " == null) throw new IllegalArgumentException();\n");
                if (this.isGeneratedTyp(p.typ) && !p.isRef) {
                    sb.append("\t\t((" + this.getCommonSupertypeType() + "Intern)this." + p.name + ").setParent(null);\n");
                    sb.append("\t\t((" + this.getCommonSupertypeType() + "Intern)" + p.name + ").setParent(this);\n");
                }
            }
            sb.append("\t\tthis." + p.name + " = " + p.name + ";\n" + "\t} \n");
            sb.append("\tpublic " + p.typ + " get" + this.toFirstUpper(p.name) + "() { return " + p.name + "; }\n\n");
        }
    }

    private int createGetMethod(ConstructorDef c, StringBuilder sb) {
        sb.append("\tpublic " + this.getCommonSupertypeType() + " get(int i) {\n");
        sb.append("\t\tswitch (i) {\n");
        int childCount = 0;
        for (Parameter p : c.parameters) {
            if (!this.prog.hasElement(p.typ) || p.isRef) continue;
            sb.append("\t\t\tcase " + childCount + ": return " + p.name + ";\n");
            ++childCount;
        }
        sb.append("\t\t\tdefault: throw new IllegalArgumentException(\"Index out of range: \" + i);\n");
        sb.append("\t\t}\n");
        sb.append("\t}\n");
        return childCount;
    }

    private void createSetMethod(ConstructorDef c, StringBuilder sb) {
        sb.append("\tpublic " + this.getCommonSupertypeType() + " set(int i, " + this.getCommonSupertypeType() + " newElem) {\n");
        sb.append("\t\t" + this.getCommonSupertypeType() + " oldElem;\n");
        sb.append("\t\tswitch (i) {\n");
        int childCount = 0;
        for (Parameter p : c.parameters) {
            if (!this.prog.hasElement(p.typ) || p.isRef) continue;
            sb.append("\t\t\tcase " + childCount + ": oldElem = " + p.name + "; set" + this.toFirstUpper(p.name) + "((" + p.typ + ") newElem); return oldElem;\n");
            ++childCount;
        }
        sb.append("\t\t\tdefault: throw new IllegalArgumentException(\"Index out of range: \" + i);\n");
        sb.append("\t\t}\n");
        sb.append("\t}\n");
    }

    private void createSizeMethod(StringBuilder sb, int childCount) {
        sb.append("\tpublic int size() {\n");
        sb.append("\t\treturn " + childCount + ";\n");
        sb.append("\t}\n");
    }

    private void createCopyMethod(ConstructorDef c, StringBuilder sb) {
        sb.append("\t@Override public " + c.name + " copy() {\n");
        sb.append("\t\treturn new " + c.name + "Impl(");
        boolean first = true;
        for (Parameter p : c.parameters) {
            if (!first) {
                sb.append(", ");
            }
            if (!p.isRef && this.prog.hasElement(p.typ)) {
                sb.append("(" + p.typ + ") " + p.name + ".copy()");
            } else {
                sb.append(p.name);
            }
            first = false;
        }
        sb.append(");\n");
        sb.append("\t}\n");
    }

    private void createClearMethod(ConstructorDef c, StringBuilder sb) {
        sb.append("\t@Override public void clearAttributes() {\n");
        for (Parameter p : c.parameters) {
            if (p.isRef || !this.prog.hasElement(p.typ)) continue;
            sb.append("\t\t" + p.name + ".clearAttributes();\n");
        }
        sb.append("\t\tclearAttributesLocal();\n");
        sb.append("\t}\n");
        sb.append("\t@Override public void clearAttributesLocal() {\n");
        for (AttributeDef attr : this.prog.attrDefs) {
            if (!this.hasAttribute(c, attr) || attr.parameters != null) continue;
            sb.append("\t\tzzattr_" + attr.attr + "_state = 0;\n");
        }
        sb.append("\t}\n");
    }

    private void createClearMethod(ListDef c, StringBuilder sb) {
        sb.append("\t@Override public void clearAttributes() {\n");
        sb.append("\t\tfor (" + c.itemType + " child : this) {\n");
        sb.append("\t\t\tchild.clearAttributes();\n");
        sb.append("\t\t}\n");
        sb.append("\t\tclearAttributesLocal();\n");
        sb.append("\t}\n");
        sb.append("\t@Override public void clearAttributesLocal() {\n");
        for (AttributeDef attr : this.prog.attrDefs) {
            if (!this.hasAttribute(c, attr) || attr.parameters != null) continue;
            sb.append("\t\tzzattr_" + attr.attr + "_state = 0;\n");
        }
        sb.append("\t}\n");
    }

    private boolean hasAttribute(AstBaseTypeDefinition c, AttributeDef attr) {
        boolean hasAttribute = attr.typ.equals(c.getName());
        for (AstEntityDefinition sup : this.transientSuperTypes.get(c)) {
            hasAttribute |= attr.typ.equals(sup.getName());
        }
        return hasAttribute |= attr.typ.equals(this.getCommonSupertypeType());
    }

    private void createAcceptMethods(ConstructorDef c, StringBuilder sb) {
        for (AstEntityDefinition parent : this.transientChildTypes.keySet()) {
            if (!this.transientChildTypes.get(parent).contains(c)) continue;
            sb.append("\t@Override public void accept(" + parent.getName() + ".Visitor v) {\n");
            for (Parameter p : c.parameters) {
                if (!this.prog.hasElement(p.typ) || p.isRef) continue;
                sb.append("\t\t" + p.name + ".accept(v);\n");
            }
            sb.append("\t\tv.visit(this);\n");
            sb.append("\t}\n");
        }
    }

    private void createToString(ConstructorDef c, StringBuilder sb) {
        for (AttributeDef attr : this.prog.attrDefs) {
            if (!attr.attr.equals("toString") || !this.hasAttribute(c, attr)) continue;
            return;
        }
        sb.append("\t@Override public String toString() {\n");
        sb.append("\t\treturn \"" + c.name);
        if (c.parameters.size() > 0) {
            sb.append("(\" + ");
            boolean first = true;
            for (Parameter p : c.parameters) {
                if (!first) {
                    sb.append(" + \", \" +");
                }
                sb.append(p.name);
                first = false;
            }
            sb.append("+\")\"");
        } else {
            sb.append("\"");
        }
        sb.append(";\n");
        sb.append("\t}\n");
    }

    private void generateBaseClass_Interface(ConstructorDef c) {
        StringBuilder sb = new StringBuilder();
        this.printProlog(sb);
        sb.append("public interface " + c.name + " extends ");
        sb.append(this.getCommonSupertypeType());
        for (AstEntityDefinition supertype : this.directSuperTypes.get(c)) {
            sb.append(", ");
            sb.append(supertype.getName());
        }
        for (Parameter p : c.parameters) {
            sb.append(", ");
            sb.append(this.getPropertyInterfaceName(p));
        }
        sb.append(" {\n");
        sb.append("\t@org.eclipse.jdt.annotation.Nullable " + this.getCommonSupertypeType() + " getParent();\n");
        sb.append("\t" + c.name + " copy();\n");
        sb.append("\tvoid clearAttributes();\n");
        sb.append("\tvoid clearAttributesLocal();\n");
        this.generateVisitorInterface(c, sb);
        this.createAttributeStubs(c, sb);
        sb.append("}\n");
        this.fileGenerator.createFile(String.valueOf(c.name) + ".java", sb);
    }

    private String getPropertyInterfaceName(Parameter p) {
        return String.valueOf(this.getCommonSupertypeType()) + "With" + this.toFirstUpper(p.name);
    }

    private void generateVisitorInterface(AstEntityDefinition d, StringBuilder sb) {
        AstBaseTypeDefinition c;
        for (AstEntityDefinition parent : this.transientChildTypes.keySet()) {
            if (!this.transientChildTypes.get(parent).contains(d)) continue;
            sb.append("\tpublic abstract void accept(" + parent.getName() + ".Visitor v);\n");
        }
        Collection<AstEntityDefinition> childTypes = this.transientChildTypes.get(d);
        sb.append("\tpublic interface Visitor");
        sb.append(" {\n");
        sb.append("");
        for (AstEntityDefinition contained : childTypes) {
            if (!(contained instanceof AstBaseTypeDefinition)) continue;
            c = (AstBaseTypeDefinition)contained;
            sb.append("\t\tvoid visit(" + c.getName() + " " + this.toFirstLower(c.getName()) + ");\n");
        }
        sb.append("\t}\n");
        sb.append("\tpublic static abstract class DefaultVisitor implements Visitor {\n");
        for (AstEntityDefinition contained : childTypes) {
            if (!(contained instanceof AstBaseTypeDefinition)) continue;
            c = (AstBaseTypeDefinition)contained;
            sb.append("\t\t@Override public void visit(" + c.getName() + " " + this.toFirstLower(c.getName()) + ") {}\n");
        }
        sb.append("\t}\n");
    }

    private void generateBaseClasses() {
        for (ConstructorDef c : this.prog.constructorDefs) {
            this.generateBaseClass_Interface(c);
            this.generateBaseClass_Impl(c);
        }
    }

    private void generateFactoryClass() {
        StringBuilder sb = new StringBuilder();
        this.printProlog(sb);
        this.addSuppressWarningAnnotations(sb);
        sb.append("public class " + this.toFirstUpper(this.prog.getLastPackagePart()) + " {\n");
        for (ConstructorDef c : this.prog.constructorDefs) {
            sb.append("\tpublic static " + c.name + " " + c.name + "(");
            boolean first = true;
            for (Parameter a : c.parameters) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(a.typ) + " " + a.name);
                first = false;
            }
            sb.append(") {\n");
            sb.append("\t\treturn new " + c.name + "Impl(");
            first = true;
            for (Parameter a : c.parameters) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(a.name);
                first = false;
            }
            sb.append(");\n");
            sb.append("\t}\n");
        }
        for (ListDef l : this.prog.listDefs) {
            sb.append("\tpublic static " + l.name + " " + l.name + "(" + l.itemType + " ... elements ) {\n");
            sb.append("\t\t" + l.name + " l = new " + l.name + "Impl();\n");
            sb.append("\t\tfor (" + l.itemType + " e : elements) { l.add(e); }\n");
            sb.append("\t\treturn l;\n");
            sb.append("\t}\n");
            sb.append("\tpublic static " + l.name + " " + l.name + "(Iterable<" + l.itemType + "> elements ) {\n");
            sb.append("\t\t" + l.name + " l = new " + l.name + "Impl();\n");
            sb.append("\t\tfor (" + l.itemType + " e : elements) { l.add(e); }\n");
            sb.append("\t\treturn l;\n");
            sb.append("\t}\n");
        }
        sb.append("}");
        this.fileGenerator.createFile(String.valueOf(this.toFirstUpper(this.prog.getLastPackagePart())) + ".java", sb);
    }

    private void generateInterfaceType(CaseDef c) {
        StringBuilder sb = new StringBuilder();
        this.printProlog(sb);
        sb.append("public interface " + c.name + " extends ");
        sb.append(this.getCommonSupertypeType());
        for (AstEntityDefinition supertype : this.directSuperTypes.get(c)) {
            sb.append(", ");
            sb.append(supertype.getName());
        }
        Set<Parameter> attributes = this.calculateAttributes(c);
        for (Parameter p : attributes) {
            sb.append(", ");
            sb.append(this.getPropertyInterfaceName(p));
        }
        sb.append("{\n");
        sb.append("\t@org.eclipse.jdt.annotation.Nullable " + this.getCommonSupertypeType() + " getParent();\n");
        sb.append("\t<T> T match(Matcher<T> s);\n");
        sb.append("\tvoid match(MatcherVoid s);\n");
        sb.append("\tpublic interface Matcher<T> {\n");
        for (AstBaseTypeDefinition baseType : this.baseTypes.get(c)) {
            sb.append("\t\tT case_" + baseType.getName() + "(" + baseType.getName() + " " + this.toFirstLower(baseType.getName()) + ");\n");
        }
        sb.append("\t}\n\n");
        sb.append("\tpublic interface MatcherVoid {\n");
        for (AstBaseTypeDefinition baseType : this.baseTypes.get(c)) {
            sb.append("\t\tvoid case_" + baseType.getName() + "(" + baseType.getName() + " " + this.toFirstLower(baseType.getName()) + ");\n");
        }
        sb.append("\t}\n\n");
        sb.append("\t" + this.getCommonSupertypeType() + " copy();\n");
        this.generateVisitorInterface(c, sb);
        this.createAttributeStubs(c, sb);
        sb.append("}\n");
        this.fileGenerator.createFile(String.valueOf(c.name) + ".java", sb);
    }

    private void createAttributeStubs(AstEntityDefinition c, StringBuilder sb) {
        for (AttributeDef attr : this.prog.attrDefs) {
            if (!attr.typ.equals(c.getName())) continue;
            sb.append("/** " + attr.comment + "*/\n");
            sb.append("\tpublic abstract " + attr.returns + " " + attr.attr + "(" + this.printParams(attr.parameters) + ");\n");
        }
    }

    public static String join(List<String> list, String sep) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (!first) {
                sb.append(sep);
            }
            sb.append(s);
            first = false;
        }
        return sb.toString();
    }

    private void generateInterfaceTypes() {
        for (CaseDef caseDef : this.prog.caseDefs) {
            this.generateInterfaceType(caseDef);
        }
    }

    private void generateList(ListDef l) {
        this.generateList_interface(l);
        this.generateList_impl(l);
    }

    private void generateList_impl(ListDef l) {
        StringBuilder sb = new StringBuilder();
        this.printProlog(sb);
        this.addSuppressWarningAnnotations(sb);
        sb.append("class " + l.name + "Impl extends " + l.name + " implements " + this.getCommonSupertypeType() + "Intern {\n ");
        this.createGetSetParentMethods(sb);
        sb.append("\tprotected void other_setParentToThis(" + l.itemType + " t) {\n");
        if (this.isGeneratedTyp(l.itemType)) {
            sb.append("\t\t((" + this.getCommonSupertypeType() + "Intern) t).setParent(this);\n");
        }
        sb.append("\t}\n\n");
        sb.append("\tprotected void other_clearParent(" + l.itemType + " t) {\n");
        if (this.isGeneratedTyp(l.itemType)) {
            sb.append("\t\t((" + this.getCommonSupertypeType() + "Intern) t).setParent(null);\n");
        }
        sb.append("\t}\n\n");
        sb.append("\t@Override\n");
        sb.append("\tpublic " + this.getCommonSupertypeType() + " set(int i, " + this.getCommonSupertypeType() + " newElement) {\n");
        sb.append("\t\treturn ((ParseqList<" + l.itemType + ">) this).set(i, (" + l.itemType + ") newElement);\n");
        sb.append("\t}\n\n");
        this.createMatchMethods(l, sb);
        for (AstEntityDefinition parent : this.transientChildTypes.keySet()) {
            if (!this.transientChildTypes.get(parent).contains(l)) continue;
            sb.append("\t@Override public void accept(" + parent.getName() + ".Visitor v) {\n");
            sb.append("\t\tfor (" + l.itemType + " i : this ) {\n");
            sb.append("\t\t\ti.accept(v);\n");
            sb.append("\t\t}\n");
            sb.append("\t\tv.visit(this);\n");
            sb.append("\t}\n");
        }
        this.createClearMethod(l, sb);
        this.createAttributeImpl(l, sb);
        this.createToString(l, sb);
        sb.append("}\n");
        this.fileGenerator.createFile(String.valueOf(l.name) + "Impl.java", sb);
    }

    private void createToString(ListDef l, StringBuilder sb) {
        for (AttributeDef attr : this.prog.attrDefs) {
            if (!attr.attr.equals("toString") || !this.hasAttribute(l, attr)) continue;
            return;
        }
        sb.append("\t@Override public String toString() {\n");
        sb.append("\t\tString result =  \"" + l.getName() + "(\";\n");
        sb.append("\t\tboolean first = true;\n");
        sb.append("\t\tfor (" + l.itemType + " i : this ) {\n");
        sb.append("\t\t\tif (!first) { result +=\", \"; }\n");
        sb.append("\t\t\tif (result.length() > 1000) { result +=\"...\"; break; }\n");
        sb.append("\t\t\tresult += i;\n");
        sb.append("\t\t\tfirst = false;\n");
        sb.append("\t\t}\n");
        sb.append("\t\tresult +=  \")\";\n");
        sb.append("\t\treturn result;\n");
        sb.append("\t}\n");
    }

    private void generateList_interface(ListDef l) {
        StringBuilder sb = new StringBuilder();
        this.printProlog(sb);
        this.addSuppressWarningAnnotations(sb);
        sb.append("public abstract class " + l.name + " extends ParseqList<" + l.itemType + "> implements ");
        sb.append(this.getCommonSupertypeType());
        for (AstEntityDefinition supertype : this.directSuperTypes.get(l)) {
            sb.append(", ");
            sb.append(supertype.getName());
        }
        sb.append("{\n");
        sb.append("\tpublic " + l.name + " copy() {\n");
        sb.append("\t\t" + l.name + " result = new " + l.name + "Impl();\n");
        sb.append("\t\tfor (" + l.itemType + " elem : this) {\n");
        sb.append("\t\t\tresult.add((" + l.itemType + ") elem.copy());\n");
        sb.append("\t\t}\n");
        sb.append("\t\treturn result;\n");
        sb.append("\t}\n");
        this.generateVisitorInterface(l, sb);
        this.createAttributeStubs(l, sb);
        sb.append("}\n");
        this.fileGenerator.createFile(String.valueOf(l.name) + ".java", sb);
    }

    private void addSuppressWarningAnnotations(StringBuilder sb) {
        sb.append("@SuppressWarnings({\"cast\", \"unused\"})\n");
    }

    private void generateLists() {
        for (ListDef l : this.prog.listDefs) {
            this.generateList(l);
        }
    }

    private void generateStandardClasses() {
        StringBuilder sb = new StringBuilder();
        this.printProlog(sb);
        sb.append("public interface " + this.getCommonSupertypeType() + " {\n" + "\t@org.eclipse.jdt.annotation.Nullable " + this.getCommonSupertypeType() + " getParent();\n" + "\t" + this.getCommonSupertypeType() + " copy();\n" + "\tint size();\n" + "\tvoid clearAttributes();\n" + "\tvoid clearAttributesLocal();\n" + "\t" + this.getCommonSupertypeType() + " get(int i);\n" + "\t" + this.getCommonSupertypeType() + " set(int i, " + this.getCommonSupertypeType() + " newElement);\n" + "\tvoid setParent(@org.eclipse.jdt.annotation.Nullable " + this.getCommonSupertypeType() + " parent);\n");
        AstEntityDefinition c = new AstEntityDefinition(){

            @Override
            public String getName() {
                return Generator.this.getCommonSupertypeType();
            }
        };
        this.createAttributeStubs(c, sb);
        sb.append("}\n\n");
        this.fileGenerator.createFile(String.valueOf(this.getCommonSupertypeType()) + ".java", sb);
        StringBuilder sb2 = new StringBuilder();
        this.printProlog(sb2);
        sb2.append("interface " + this.getCommonSupertypeType() + "Intern {\n" + "\tvoid setParent(@org.eclipse.jdt.annotation.Nullable " + this.getCommonSupertypeType() + " pos);\n" + "}\n\n");
        this.fileGenerator.createFile(String.valueOf(this.getCommonSupertypeType()) + "Intern.java", sb2);
    }

    private void generateStandardList() {
        StringBuilder sb = new StringBuilder();
        this.printProlog(sb);
        TemplateParseqList.writeTo(sb);
        this.fileGenerator.createFile("ParseqList.java", sb);
    }

    private void generateCyclicDependencyError() {
        StringBuilder sb = new StringBuilder();
        this.printProlog(sb);
        TemplateCyclicDependencyError.writeTo(sb, this.getCommonSupertypeType());
        this.fileGenerator.createFile("CyclicDependencyError.java", sb);
    }

    private String getCommonSupertypeType() {
        return String.valueOf(this.toFirstUpper(this.mainName)) + "Element";
    }

    private void printProlog(StringBuilder sb) {
        sb.append("//generated by parseq\n");
        sb.append("package " + this.packageName + ";\n\n");
    }

    private String toFirstLower(String name) {
        return String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
    }

    private String toFirstUpper(String name) {
        return String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
    }

    private <T> Multimap<T, T> transientClosure(Multimap<T, T> start) {
        HashMultimap changes;
        boolean changed;
        HashMultimap<Object, Object> result = HashMultimap.create();
        result.putAll(start);
        do {
            changes = HashMultimap.create();
            for (Map.Entry e1 : result.entries()) {
                for (Object t : result.get(e1.getValue())) {
                    changes.put(e1.getKey(), t);
                }
            }
        } while (changed = result.putAll(changes));
        return result;
    }
}

