// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array C_nextFree
integer C_firstFree=0
integer C_maxIndex=0
real array C_v_x_0
real array C_v_x_1
real array C_v_x_2
real array C_v_x_3
real array C_v_x_4
real array C_v_y_0
real array C_v_y_1
real array C_v_y_2
real array C_v_y_3
real array C_v_y_4
real array C_v_z_0
real array C_v_z_1
real array C_v_z_2
real array C_v_z_3
real array C_v_z_4
endglobals
native println takes string s returns nothing
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function C_v_x_get takes integer index1, integer index2 returns real
	local real returnVal
	if index2 < 0 or index2 >= 5 then
		call error("Index out of Bounds")
	elseif index2 <= 2 then
		if index2 <= 1 then
			if index2 <= 0 then
				set returnVal = C_v_x_0[index1]
			else
				set returnVal = C_v_x_1[index1]
			endif
		else
			set returnVal = C_v_x_2[index1]
		endif
	elseif index2 <= 3 then
		set returnVal = C_v_x_3[index1]
	else
		set returnVal = C_v_x_4[index1]
	endif
	return returnVal
endfunction

function C_v_x_set takes integer instanceId, integer arrayIndex, real value returns nothing
	if arrayIndex < 0 or arrayIndex >= 5 then
		call error("Index out of Bounds")
	elseif arrayIndex <= 2 then
		if arrayIndex <= 1 then
			if arrayIndex <= 0 then
				set C_v_x_0[instanceId] = value
			else
				set C_v_x_1[instanceId] = value
			endif
		else
			set C_v_x_2[instanceId] = value
		endif
	elseif arrayIndex <= 3 then
		set C_v_x_3[instanceId] = value
	else
		set C_v_x_4[instanceId] = value
	endif
endfunction

function C_v_y_get takes integer index1, integer index2 returns real
	local real returnVal
	if index2 < 0 or index2 >= 5 then
		call error("Index out of Bounds")
	elseif index2 <= 2 then
		if index2 <= 1 then
			if index2 <= 0 then
				set returnVal = C_v_y_0[index1]
			else
				set returnVal = C_v_y_1[index1]
			endif
		else
			set returnVal = C_v_y_2[index1]
		endif
	elseif index2 <= 3 then
		set returnVal = C_v_y_3[index1]
	else
		set returnVal = C_v_y_4[index1]
	endif
	return returnVal
endfunction

function C_v_y_set takes integer instanceId, integer arrayIndex, real value returns nothing
	if arrayIndex < 0 or arrayIndex >= 5 then
		call error("Index out of Bounds")
	elseif arrayIndex <= 2 then
		if arrayIndex <= 1 then
			if arrayIndex <= 0 then
				set C_v_y_0[instanceId] = value
			else
				set C_v_y_1[instanceId] = value
			endif
		else
			set C_v_y_2[instanceId] = value
		endif
	elseif arrayIndex <= 3 then
		set C_v_y_3[instanceId] = value
	else
		set C_v_y_4[instanceId] = value
	endif
endfunction

function C_v_z_get takes integer index1, integer index2 returns real
	local real returnVal
	if index2 < 0 or index2 >= 5 then
		call error("Index out of Bounds")
	elseif index2 <= 2 then
		if index2 <= 1 then
			if index2 <= 0 then
				set returnVal = C_v_z_0[index1]
			else
				set returnVal = C_v_z_1[index1]
			endif
		else
			set returnVal = C_v_z_2[index1]
		endif
	elseif index2 <= 3 then
		set returnVal = C_v_z_3[index1]
	else
		set returnVal = C_v_z_4[index1]
	endif
	return returnVal
endfunction

function C_v_z_set takes integer instanceId, integer arrayIndex, real value returns nothing
	if arrayIndex < 0 or arrayIndex >= 5 then
		call error("Index out of Bounds")
	elseif arrayIndex <= 2 then
		if arrayIndex <= 1 then
			if arrayIndex <= 0 then
				set C_v_z_0[instanceId] = value
			else
				set C_v_z_1[instanceId] = value
			endif
		else
			set C_v_z_2[instanceId] = value
		endif
	elseif arrayIndex <= 3 then
		set C_v_z_3[instanceId] = value
	else
		set C_v_z_4[instanceId] = value
	endif
endfunction

function new_C takes nothing returns integer
	local integer this
	if C_firstFree == 0 then
		if C_maxIndex < 32768 then
			set C_maxIndex = C_maxIndex + 1
			set this = C_maxIndex
		else
			call error("Out of memory: Could not create C.")
			set this = 0
		endif
	else
		set C_firstFree = C_firstFree - 1
		set this = C_nextFree[C_firstFree]
	endif
	return this
endfunction

function init_test takes nothing returns nothing
	local integer c = new_C()
	call C_v_x_set(c, 0, 1.)
	call C_v_y_set(c, 0, 2.)
	call C_v_z_set(c, 0, 3.)
	call C_v_x_set(c, 1, 5.)
	call C_v_y_set(c, 1, 6.)
	call C_v_z_set(c, 1, 7.)
	call println(R2S(C_v_x_get(c, 0)))
	call println(R2S(C_v_z_get(c, 0)))
	call println(R2S(C_v_y_get(c, 1)))
	if C_v_x_get(c, 0) == 1. and C_v_z_get(c, 0) == 3. and C_v_y_get(c, 1) == 6. then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

