// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array IntList_elements
integer array IntList_nextFree
integer IntList_firstFree=0
integer IntList_maxIndex=0
integer array IntList_typeId
integer array IntListIterator_nextFree
integer IntListIterator_firstFree=0
integer IntListIterator_maxIndex=0
integer array IntListIterator_typeId
integer array IntList_size
integer array IntListIterator_list
integer array IntListIterator_pos
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function dispatch_IntListIterator_destroyIntListIterator takes integer this returns nothing
	if IntListIterator_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling IntListIterator.IntListIterator")
		else
			call error("Called IntListIterator.IntListIterator on invalid object.")
		endif
	endif
	if IntListIterator_typeId[this] == 0 then
		call error("Double free: object of type IntListIterator")
	else
		set IntListIterator_nextFree[IntListIterator_firstFree] = this
		set IntListIterator_firstFree = IntListIterator_firstFree + 1
		set IntListIterator_typeId[this] = 0
	endif
endfunction

function dispatch_IntList_test_IntList_add takes integer this, integer x returns integer
	if IntList_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling IntList.add")
		else
			call error("Called IntList.add on invalid object.")
		endif
	endif
	if IntList_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling IntList.getOffset")
		else
			call error("Called IntList.getOffset on invalid object.")
		endif
	endif
	set IntList_elements[64 * (this - 1) + IntList_size[this]] = x
	set IntList_size[this] = IntList_size[this] + 1
	return this
endfunction

function dispatch_IntList_test_IntList_get takes integer this, integer i returns integer
	if IntList_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling IntList.get")
		else
			call error("Called IntList.get on invalid object.")
		endif
	endif
	if IntList_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling IntList.getOffset")
		else
			call error("Called IntList.getOffset on invalid object.")
		endif
	endif
	return IntList_elements[64 * (this - 1) + i]
endfunction

function new_IntList takes nothing returns integer
	local integer this
	if IntList_firstFree == 0 then
		if IntList_maxIndex < 32768 then
			set IntList_maxIndex = IntList_maxIndex + 1
			set this = IntList_maxIndex
			set IntList_typeId[this] = 1
		else
			call error("Out of memory: Could not create IntList.")
			set this = 0
		endif
	else
		set IntList_firstFree = IntList_firstFree - 1
		set this = IntList_nextFree[IntList_firstFree]
		set IntList_typeId[this] = 1
	endif
	set IntList_size[this] = 0
	return this
endfunction

function new_IntListIterator takes integer list returns integer
	local integer this
	if IntListIterator_firstFree == 0 then
		if IntListIterator_maxIndex < 32768 then
			set IntListIterator_maxIndex = IntListIterator_maxIndex + 1
			set this = IntListIterator_maxIndex
			set IntListIterator_typeId[this] = 2
		else
			call error("Out of memory: Could not create IntListIterator.")
			set this = 0
		endif
	else
		set IntListIterator_firstFree = IntListIterator_firstFree - 1
		set this = IntListIterator_nextFree[IntListIterator_firstFree]
		set IntListIterator_typeId[this] = 2
	endif
	set IntListIterator_pos[this] = 0
	set IntListIterator_list[this] = list
	return this
endfunction

function init_test takes nothing returns nothing
	local integer listIterator = dispatch_IntList_test_IntList_add(dispatch_IntList_test_IntList_add(dispatch_IntList_test_IntList_add(new_IntList(), 7), 3), 5)
	local integer sum = 0
	local integer from
	if IntList_typeId[listIterator] == 0 then
		if listIterator == 0 then
			call error("Nullpointer exception when calling IntList.iterator")
		else
			call error("Called IntList.iterator on invalid object.")
		endif
	endif
	set from = new_IntListIterator(listIterator)
	set listIterator = from
	loop
		exitwhen IntListIterator_pos[from] >= IntList_size[IntListIterator_list[from]]
		set IntListIterator_pos[from] = IntListIterator_pos[from] + 1
		set sum = sum + dispatch_IntList_test_IntList_get(IntListIterator_list[from], IntListIterator_pos[from] - 1)
	endloop
	if IntListIterator_typeId[listIterator] == 0 then
		if listIterator == 0 then
			call error("Nullpointer exception when calling IntListIterator.close")
		else
			call error("Called IntListIterator.close on invalid object.")
		endif
	endif
	call dispatch_IntListIterator_destroyIntListIterator(listIterator)
	if sum == 15 then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

