// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
real vec3_moveTowards_return_x=0.
real vec3_moveTowards_return_y=0.
real vec3_moveTowards_return_z=0.
real vec3_normalizedPointerTo_return_x=0.
real vec3_normalizedPointerTo_return_y=0.
real vec3_normalizedPointerTo_return_z=0.
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function vec3_normalizedPointerTo takes real this_x, real this_y, real this_z, real target_x, real target_y, real target_z returns real
	set this_x = target_x - this_x
	set this_y = target_y - this_y
	set this_z = target_z - this_z
	set target_x = SquareRoot(this_x * this_x + this_y * this_y + this_z * this_z)
	if target_x > 0. then
		set target_x = 1. / target_x
		set this_x = this_x * target_x
		set this_y = this_y * target_x
		set this_z = this_z * target_x
	else
		set this_x = 1.
		set this_y = 0.
		set this_z = 0.
	endif
	set vec3_normalizedPointerTo_return_x = this_x
	set vec3_normalizedPointerTo_return_y = this_y
	set vec3_normalizedPointerTo_return_z = this_z
	return vec3_normalizedPointerTo_return_x
endfunction

function vec3_moveTowards takes real this_x, real this_y, real this_z, real target_x, real target_y, real target_z, real dist returns real
	set target_y = vec3_normalizedPointerTo(this_x, this_y, this_z, target_x, target_y, target_z)
	set target_z = vec3_normalizedPointerTo_return_y
	set target_x = vec3_normalizedPointerTo_return_z
	set target_y = target_y * dist
	set target_z = target_z * dist
	set target_x = target_x * dist
	set vec3_moveTowards_return_x = this_x + target_y
	set vec3_moveTowards_return_y = this_y + target_z
	set vec3_moveTowards_return_z = this_z + target_x
	return vec3_moveTowards_return_x
endfunction

function init_test takes nothing returns nothing
	local real tuple_temp = vec3_moveTowards(0., 0., 0., 1., 2., 3., 10.)
	local real tuple_temp_1 = vec3_moveTowards_return_y
	local real tuple_temp_2 = vec3_moveTowards_return_z
	local real tuple_temp_3 = vec3_moveTowards(0., 0., 0., 6., 5., 4., 10.)
	local real tuple_temp_4 = vec3_moveTowards_return_y
	local real tuple_temp_5 = vec3_moveTowards_return_z
	local boolean andLeft
	if tuple_temp - 0.01 < 2.673 and 2.673 < tuple_temp + 0.01 and tuple_temp_1 - 0.01 < 5.345 and 5.345 < tuple_temp_1 + 0.01 and tuple_temp_2 - 0.01 < 8.018 and 8.018 < tuple_temp_2 + 0.01 then
		set andLeft = tuple_temp_3 - 0.01 < 6.838 and 6.838 < tuple_temp_3 + 0.01 and tuple_temp_4 - 0.01 < 5.698 and 5.698 < tuple_temp_4 + 0.01 and tuple_temp_5 - 0.01 < 4.558 and 4.558 < tuple_temp_5 + 0.01
	else
		set andLeft = false
	endif
	if andLeft then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

