// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array A_nextFree
integer A_firstFree=0
integer A_maxIndex=0
integer array A_typeId
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
	set A_firstFree = 0
	set A_maxIndex = 0
endfunction

function A_onDestroy takes integer this returns nothing
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function dealloc_A takes integer obj returns nothing
	if A_typeId[obj] == 0 then
		call error("Double free: object of type A")
	else
		set A_nextFree[A_firstFree] = obj
		set A_firstFree = A_firstFree + 1
		set A_typeId[obj] = 0
	endif
endfunction

function destroyA takes integer this returns nothing
	call A_onDestroy(this)
	call dealloc_A(this)
endfunction

function dispatch_A_destroyA takes integer this returns nothing
	if A_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling A.A")
		else
			call error("Called A.A on invalid object.")
		endif
	endif
	call destroyA(this)
endfunction

function instanceCount takes integer typeId returns integer
	return A_maxIndex - A_firstFree
	return 0
endfunction

function alloc_A takes nothing returns integer
	local integer this
	if A_firstFree == 0 then
		if A_maxIndex < 32768 then
			set A_maxIndex = A_maxIndex + 1
			set this = A_maxIndex
			set A_typeId[this] = 1
		else
			call error("Out of memory: Could not create A.")
			set this = 0
		endif
	else
		set A_firstFree = A_firstFree - 1
		set this = A_nextFree[A_firstFree]
		set A_typeId[this] = 1
	endif
	return this
endfunction

function A_init takes integer this returns nothing
endfunction

function construct_A takes integer this returns nothing
	call A_init(this)
endfunction

function new_A takes nothing returns integer
	local integer this = alloc_A()
	call construct_A(this)
	return this
endfunction

function init_Test takes nothing returns nothing
	local integer a = new_A()
	local integer e
	local integer count1
	local integer count2
	call new_A()
	call new_A()
	call new_A()
	set e = new_A()
	set count1 = instanceCount(1)
	call dispatch_A_destroyA(a)
	call dispatch_A_destroyA(e)
	set count2 = instanceCount(1)
	if count1 == 5 and count2 == 3 then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_Test()
endfunction

function config takes nothing returns nothing
endfunction

