// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
string test_s=null
integer array C_nextFree
integer C_firstFree=0
integer C_maxIndex=0
integer array C_typeId
endglobals
native testFail takes string msg returns nothing
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function C_onDestroy takes integer this returns nothing
	set test_s = test_s + "c" + "b" + "a"
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function dealloc_C takes integer obj returns nothing
	if C_typeId[obj] == 0 then
		call error("Double free: object of type C")
	else
		set C_nextFree[C_firstFree] = obj
		set C_firstFree = C_firstFree + 1
		set C_typeId[obj] = 0
	endif
endfunction

function destroyC takes integer this returns nothing
	call C_onDestroy(this)
	call dealloc_C(this)
endfunction

function dispatch_C_destroyC takes integer this returns nothing
	if C_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling C.C")
		else
			call error("Called C.C on invalid object.")
		endif
	endif
	call destroyC(this)
endfunction

function alloc_C takes nothing returns integer
	local integer this
	if C_firstFree == 0 then
		if C_maxIndex < 32768 then
			set C_maxIndex = C_maxIndex + 1
			set this = C_maxIndex
			set C_typeId[this] = 1
		else
			call error("Out of memory: Could not create C.")
			set this = 0
		endif
	else
		set C_firstFree = C_firstFree - 1
		set this = C_nextFree[C_firstFree]
		set C_typeId[this] = 1
	endif
	return this
endfunction

function construct_C_B_A takes integer this returns nothing
	set test_s = test_s + "A"
endfunction

function construct_C_B takes integer this returns nothing
	call construct_C_B_A(this)
	set test_s = test_s + "B"
endfunction

function C_init takes integer this returns nothing
	call construct_C_B(this)
endfunction

function construct_C takes integer this returns nothing
	call C_init(this)
	set test_s = test_s + "C"
endfunction

function new_C takes nothing returns integer
	local integer this = alloc_C()
	call construct_C(this)
	return this
endfunction

function init_test takes nothing returns nothing
	set test_s = ""
	call dispatch_C_destroyC(new_C())
	if test_s != "ABCcba" then
		call testFail("fail, result = " + test_s)
	endif
	call testSuccess()
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

