// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer test_x=0
integer array I_nextFree
integer I_firstFree=0
integer I_maxIndex=0
integer array I_typeId
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
	set I_firstFree = 0
	set I_maxIndex = 0
endfunction

function B_onDestroy takes integer this returns nothing
	set test_x = 1
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function dealloc_B takes integer obj returns nothing
	if I_typeId[obj] == 0 then
		call error("Double free: object of type B")
	else
		set I_nextFree[I_firstFree] = obj
		set I_firstFree = I_firstFree + 1
		set I_typeId[obj] = 0
	endif
endfunction

function destroyB takes integer this returns nothing
	call B_onDestroy(this)
	call dealloc_B(this)
endfunction

function C_onDestroy takes integer this returns nothing
	set test_x = 2
endfunction

function dealloc_C takes integer obj returns nothing
	if I_typeId[obj] == 0 then
		call error("Double free: object of type C")
	else
		set I_nextFree[I_firstFree] = obj
		set I_firstFree = I_firstFree + 1
		set I_typeId[obj] = 0
	endif
endfunction

function destroyC takes integer this returns nothing
	call C_onDestroy(this)
	call dealloc_C(this)
endfunction

function dealloc_I takes integer obj returns nothing
	if I_typeId[obj] == 0 then
		call error("Double free: object of type I")
	else
		set I_nextFree[I_firstFree] = obj
		set I_firstFree = I_firstFree + 1
		set I_typeId[obj] = 0
	endif
endfunction

function destroyI takes integer this returns nothing
	call dealloc_I(this)
endfunction

function dispatch_I_destroyI takes integer this returns nothing
	if I_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling I.I")
		else
			call error("Called I.I on invalid object.")
		endif
	endif
	if I_typeId[this] <= 2 then
		if I_typeId[this] <= 1 then
			call destroyI(this)
		else
			call destroyB(this)
		endif
	else
		call destroyC(this)
	endif
endfunction

function alloc_C takes nothing returns integer
	local integer this
	if I_firstFree == 0 then
		if I_maxIndex < 32768 then
			set I_maxIndex = I_maxIndex + 1
			set this = I_maxIndex
			set I_typeId[this] = 3
		else
			call error("Out of memory: Could not create C.")
			set this = 0
		endif
	else
		set I_firstFree = I_firstFree - 1
		set this = I_nextFree[I_firstFree]
		set I_typeId[this] = 3
	endif
	return this
endfunction

function C_init takes integer this returns nothing
endfunction

function construct_C takes integer this returns nothing
	call C_init(this)
endfunction

function new_C takes nothing returns integer
	local integer this = alloc_C()
	call construct_C(this)
	return this
endfunction

function init_test takes nothing returns nothing
	local integer i
	set test_x = 0
	set i = new_C()
	call dispatch_I_destroyI(i)
	if test_x == 2 then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

