// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array F_nextFree
integer F_firstFree=0
integer F_maxIndex=0
integer array F_typeId
integer array Cell_nextFree
integer Cell_firstFree=0
integer Cell_maxIndex=0
integer array Cell_typeId
integer array Cell_elem
endglobals
native println takes string s returns nothing
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
	set F_firstFree = 0
	set F_maxIndex = 0
	set Cell_firstFree = 0
	set Cell_maxIndex = 0
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function alloc_F_map_test takes nothing returns integer
	local integer this
	if F_firstFree == 0 then
		if F_maxIndex < 32768 then
			set F_maxIndex = F_maxIndex + 1
			set this = F_maxIndex
			set F_typeId[this] = 3
		else
			call error("Out of memory: Could not create F_map_test.")
			set this = 0
		endif
	else
		set F_firstFree = F_firstFree - 1
		set this = F_nextFree[F_firstFree]
		set F_typeId[this] = 3
	endif
	return this
endfunction

function Cell_get takes integer this returns integer
	return Cell_elem[this]
endfunction

function dispatch_Cell_test_Cell_get takes integer this returns integer
	local integer test_Cell_get_result
	if Cell_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Cell.get")
		else
			call error("Called Cell.get on invalid object.")
		endif
	endif
	set test_Cell_get_result = Cell_get(this)
	return test_Cell_get_result
endfunction

function apply_map_test takes integer this, integer i returns real
	return i * 10.
endfunction

function realToIndex takes real r returns integer
	return R2I(r * 1000.)
endfunction

function apply_wrapper takes integer this, integer a returns integer
	return realToIndex(apply_map_test(this, a))
endfunction

function dispatch_F_test_F_apply takes integer this, integer a returns integer
	local integer test_F_apply_result
	if F_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling F.apply")
		else
			call error("Called F.apply on invalid object.")
		endif
	endif
	set test_F_apply_result = apply_wrapper(this, a)
	return test_F_apply_result
endfunction

function alloc_Cell takes nothing returns integer
	local integer this
	if Cell_firstFree == 0 then
		if Cell_maxIndex < 32768 then
			set Cell_maxIndex = Cell_maxIndex + 1
			set this = Cell_maxIndex
			set Cell_typeId[this] = 1
		else
			call error("Out of memory: Could not create Cell.")
			set this = 0
		endif
	else
		set Cell_firstFree = Cell_firstFree - 1
		set this = Cell_nextFree[Cell_firstFree]
		set Cell_typeId[this] = 1
	endif
	return this
endfunction

function Cell_init takes integer this returns nothing
endfunction

function construct_Cell takes integer this, integer t returns nothing
	call Cell_init(this)
	set Cell_elem[this] = t
endfunction

function new_Cell takes integer t returns integer
	local integer this = alloc_Cell()
	call construct_Cell(this, t)
	return this
endfunction

function Cell_map takes integer this, integer f returns integer
	return new_Cell(dispatch_F_test_F_apply(f, Cell_elem[this]))
endfunction

function dispatch_Cell_test_Cell_map takes integer this, integer f returns integer
	local integer test_Cell_map_result
	if Cell_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Cell.map")
		else
			call error("Called Cell.map on invalid object.")
		endif
	endif
	set test_Cell_map_result = Cell_map(this, f)
	return test_Cell_map_result
endfunction

function realFromIndex takes integer i returns real
	return i / 1000.
endfunction

function real_assertEquals takes real this, real expected returns nothing
	if this == expected then
		call testSuccess()
	else
		call println(R2S(this))
	endif
endfunction

function init_test takes nothing returns nothing
	local integer a = new_Cell(5)
	local integer temp = a
	local integer clVar = alloc_F_map_test()
	local integer b = dispatch_Cell_test_Cell_map(temp, clVar)
	call real_assertEquals(realFromIndex(dispatch_Cell_test_Cell_get(b)), 50.)
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

