// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array C_nextFree
integer C_firstFree=0
integer C_maxIndex=0
integer array C_typeId
integer array Iterator_nextFree
integer Iterator_firstFree=0
integer Iterator_maxIndex=0
integer array Iterator_i
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function Iterator_hasNext takes integer this returns boolean
	return Iterator_i[this] < 10
endfunction

function Iterator_next takes integer this returns integer
	set Iterator_i[this] = Iterator_i[this] + 1
	return Iterator_i[this]
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function alloc_Iterator takes nothing returns integer
	local integer this
	if Iterator_firstFree == 0 then
		if Iterator_maxIndex < 32768 then
			set Iterator_maxIndex = Iterator_maxIndex + 1
			set this = Iterator_maxIndex
		else
			call error("Out of memory: Could not create Iterator.")
			set this = 0
		endif
	else
		set Iterator_firstFree = Iterator_firstFree - 1
		set this = Iterator_nextFree[Iterator_firstFree]
	endif
	return this
endfunction

function Iterator_init takes integer this returns nothing
	set Iterator_i[this] = 0
endfunction

function construct_Iterator takes integer this returns nothing
	call Iterator_init(this)
endfunction

function new_Iterator takes nothing returns integer
	local integer this = alloc_Iterator()
	call construct_Iterator(this)
	return this
endfunction

function C_iterator takes integer this returns integer
	return new_Iterator()
endfunction

function dispatch_C_test_C_iterator takes integer this returns integer
	if C_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling C.iterator")
		else
			call error("Called C.iterator on invalid object.")
		endif
	endif
	return C_iterator(this)
endfunction

function alloc_C takes nothing returns integer
	local integer this
	if C_firstFree == 0 then
		if C_maxIndex < 32768 then
			set C_maxIndex = C_maxIndex + 1
			set this = C_maxIndex
			set C_typeId[this] = 1
		else
			call error("Out of memory: Could not create C.")
			set this = 0
		endif
	else
		set C_firstFree = C_firstFree - 1
		set this = C_nextFree[C_firstFree]
		set C_typeId[this] = 1
	endif
	return this
endfunction

function C_init takes integer this returns nothing
endfunction

function construct_C takes integer this returns nothing
	call C_init(this)
endfunction

function new_C takes nothing returns integer
	local integer this = alloc_C()
	call construct_C(this)
	return this
endfunction

function init_test takes nothing returns nothing
	local integer from = dispatch_C_test_C_iterator(new_C())
	loop
		exitwhen  not Iterator_hasNext(from)
		if Iterator_next(from) == 5 then
			call testSuccess()
		endif
	endloop
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

