// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array Iterator_nextFree
integer Iterator_firstFree=0
integer Iterator_maxIndex=0
integer array Iterator_typeId
integer array List_nextFree
integer List_firstFree=0
integer List_maxIndex=0
integer array List_typeId
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function new_Iterator takes integer t returns integer
	if Iterator_firstFree == 0 then
		if Iterator_maxIndex < 32768 then
			set Iterator_maxIndex = Iterator_maxIndex + 1
			set t = Iterator_maxIndex
			set Iterator_typeId[t] = 4
		else
			call error("Out of memory: Could not create Iterator.")
			set t = 0
		endif
	else
		set Iterator_firstFree = Iterator_firstFree - 1
		set t = Iterator_nextFree[Iterator_firstFree]
		set Iterator_typeId[t] = 4
	endif
	return t
endfunction

function new_List takes nothing returns integer
	local integer this
	if List_firstFree == 0 then
		if List_maxIndex < 32768 then
			set List_maxIndex = List_maxIndex + 1
			set this = List_maxIndex
			set List_typeId[this] = 5
		else
			call error("Out of memory: Could not create List.")
			set this = 0
		endif
	else
		set List_firstFree = List_firstFree - 1
		set this = List_nextFree[List_firstFree]
		set List_typeId[this] = 5
	endif
	return this
endfunction

function init_test takes nothing returns nothing
	local integer a = new_List()
	if List_typeId[a] == 0 then
		if a == 0 then
			call error("Nullpointer exception when calling List.iterator")
		else
			call error("Called List.iterator on invalid object.")
		endif
	endif
	set a = new_Iterator(a)
	loop
		if Iterator_typeId[a] == 0 then
			if a == 0 then
				call error("Nullpointer exception when calling Iterator.hasNext")
			else
				call error("Called Iterator.hasNext on invalid object.")
			endif
		endif
		if Iterator_typeId[a] == 0 then
			if a == 0 then
				call error("Nullpointer exception when calling Iterator.next")
			else
				call error("Called Iterator.next on invalid object.")
			endif
		endif
		call testSuccess()
	endloop
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

