// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array C_nextFree
integer C_firstFree=0
integer C_maxIndex=0
integer array C_typeId
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function dispatch_C_destroyC takes integer this returns nothing
	if C_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling C.C")
		else
			call error("Called C.C on invalid object.")
		endif
	endif
	if C_typeId[this] == 0 then
		call error("Double free: object of type C")
	else
		set C_nextFree[C_firstFree] = this
		set C_firstFree = C_firstFree + 1
		set C_typeId[this] = 0
	endif
endfunction

function new_C takes nothing returns integer
	local integer this
	if C_firstFree == 0 then
		if C_maxIndex < 32768 then
			set C_maxIndex = C_maxIndex + 1
			set this = C_maxIndex
			set C_typeId[this] = 1
		else
			call error("Out of memory: Could not create C.")
			set this = 0
		endif
	else
		set C_firstFree = C_firstFree - 1
		set this = C_nextFree[C_firstFree]
		set C_typeId[this] = 1
	endif
	return this
endfunction

function init_test takes nothing returns nothing
	local integer i = 0
	local integer array cs
	loop
		exitwhen i > 6000
		set cs[i] = new_C()
		set i = i + 1
	endloop
	set i = 0
	loop
		exitwhen i > 6000
		call dispatch_C_destroyC(cs[i])
		set i = i + 1
	endloop
	set i = 0
	loop
		exitwhen i > 6000
		set cs[i] = new_C()
		set i = i + 1
	endloop
	if cs[6000] <= 6001 then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

