// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer array A_nextFree
integer A_firstFree=0
integer A_maxIndex=0
string array A_s_0
string array A_s_1
string array A_s_2
string array A_s_3
endglobals
native testFail takes string msg returns nothing
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function A_s_get takes integer index1, integer index2 returns string
	local string returnVal
	if index2 < 0 or index2 >= 4 then
		call error("Index out of Bounds")
	elseif index2 <= 1 then
		if index2 <= 0 then
			set returnVal = A_s_0[index1]
		else
			set returnVal = A_s_1[index1]
		endif
	elseif index2 <= 2 then
		set returnVal = A_s_2[index1]
	else
		set returnVal = A_s_3[index1]
	endif
	return returnVal
endfunction

function A_s_set takes integer instanceId, integer arrayIndex, string value returns nothing
	if arrayIndex < 0 or arrayIndex >= 4 then
		call error("Index out of Bounds")
	elseif arrayIndex <= 1 then
		if arrayIndex <= 0 then
			set A_s_0[instanceId] = value
		else
			set A_s_1[instanceId] = value
		endif
	elseif arrayIndex <= 2 then
		set A_s_2[instanceId] = value
	else
		set A_s_3[instanceId] = value
	endif
endfunction

function new_A takes nothing returns integer
	local integer this
	if A_firstFree == 0 then
		if A_maxIndex < 32768 then
			set A_maxIndex = A_maxIndex + 1
			set this = A_maxIndex
		else
			call error("Out of memory: Could not create A.")
			set this = 0
		endif
	else
		set A_firstFree = A_firstFree - 1
		set this = A_nextFree[A_firstFree]
	endif
	return this
endfunction

function init_test takes nothing returns nothing
	local integer a = new_A()
	call A_s_set(a, 0, "a")
	call A_s_set(a, 1, "b")
	call A_s_set(a, 2, "c")
	call A_s_set(a, 3, "d")
	if A_s_get(a, 0) == "a" and A_s_get(a, 1) == "b" and A_s_get(a, 2) == "c" and A_s_get(a, 3) == "d" then
		call testSuccess()
	else
		call testFail("wrong value")
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

