// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer test_x=0
integer array B_nextFree
integer B_firstFree=0
integer B_maxIndex=0
integer array B_typeId
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
	set B_firstFree = 0
	set B_maxIndex = 0
endfunction

function B_onDestroy takes integer this returns nothing
	local integer y = 2
	set test_x = test_x * y
endfunction

function A_onDestroy takes integer this returns nothing
	local integer z = 1
	set test_x = test_x + z
	call B_onDestroy(this)
endfunction

function X_onDestroy takes integer this returns nothing
	call A_onDestroy(this)
endfunction

function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function dealloc_X takes integer obj returns nothing
	if B_typeId[obj] == 0 then
		call error("Double free: object of type X")
	else
		set B_nextFree[B_firstFree] = obj
		set B_firstFree = B_firstFree + 1
		set B_typeId[obj] = 0
	endif
endfunction

function destroyX takes integer this returns nothing
	call X_onDestroy(this)
	call dealloc_X(this)
endfunction

function dispatch_X_destroyX takes integer this returns nothing
	if B_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling X.X")
		else
			call error("Called X.X on invalid object.")
		endif
	endif
	call destroyX(this)
endfunction

function alloc_X takes nothing returns integer
	local integer this
	if B_firstFree == 0 then
		if B_maxIndex < 32768 then
			set B_maxIndex = B_maxIndex + 1
			set this = B_maxIndex
			set B_typeId[this] = 3
		else
			call error("Out of memory: Could not create X.")
			set this = 0
		endif
	else
		set B_firstFree = B_firstFree - 1
		set this = B_nextFree[B_firstFree]
		set B_typeId[this] = 3
	endif
	return this
endfunction

function X_init takes integer this returns nothing
endfunction

function A_init takes integer this returns nothing
endfunction

function B_init takes integer this returns nothing
endfunction

function construct_B takes integer this returns nothing
	call B_init(this)
endfunction

function construct_A takes integer this returns nothing
	call construct_B(this)
	call A_init(this)
endfunction

function construct_X takes integer this returns nothing
	call construct_A(this)
	call X_init(this)
endfunction

function new_X takes nothing returns integer
	local integer this = alloc_X()
	call construct_X(this)
	return this
endfunction

function init_test takes nothing returns nothing
	local integer a
	set test_x = 2
	set a = new_X()
	call dispatch_X_destroyX(a)
	if test_x == 6 then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

