// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
integer test_x=0
integer array B_nextFree
integer B_firstFree=0
integer B_maxIndex=0
integer array B_typeId
endglobals
native testSuccess takes nothing returns nothing
function error takes string msg returns nothing
	call BJDebugMsg(msg + "\n" + "")
endfunction

function destroyA takes integer this returns nothing
	set test_x = (test_x + 1) * 2
	if B_typeId[this] == 0 then
		call error("Double free: object of type A")
	else
		set B_nextFree[B_firstFree] = this
		set B_firstFree = B_firstFree + 1
		set B_typeId[this] = 0
	endif
endfunction

function dispatch_B_destroyB takes integer this returns nothing
	if B_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling B.B")
		else
			call error("Called B.B on invalid object.")
		endif
	endif
	if B_typeId[this] <= 1 then
		set test_x = test_x * 2
		if B_typeId[this] == 0 then
			call error("Double free: object of type B")
		else
			set B_nextFree[B_firstFree] = this
			set B_firstFree = B_firstFree + 1
			set B_typeId[this] = 0
		endif
	else
		call destroyA(this)
	endif
endfunction

function initGlobals takes nothing returns nothing
endfunction

function new_A takes nothing returns integer
	local integer this
	if B_firstFree == 0 then
		if B_maxIndex < 32768 then
			set B_maxIndex = B_maxIndex + 1
			set this = B_maxIndex
			set B_typeId[this] = 2
		else
			call error("Out of memory: Could not create A.")
			set this = 0
		endif
	else
		set B_firstFree = B_firstFree - 1
		set this = B_nextFree[B_firstFree]
		set B_typeId[this] = 2
	endif
	return this
endfunction

function main takes nothing returns nothing
	call initGlobals()
	set test_x = 2
	call dispatch_B_destroyB(new_A())
	if test_x == 6 then
		call testSuccess()
	endif
endfunction

function config takes nothing returns nothing
endfunction

