// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
real vec2_polarOffset_return_x=0.
real vec2_polarOffset_return_y=0.
real angle_toVec_return_x=0.
real angle_toVec_return_y=0.
real vec2_op_plus_return_x=0.
real vec2_op_plus_return_y=0.
endglobals
native testSuccess takes nothing returns nothing
function initGlobals takes nothing returns nothing
endfunction

function angle_toVec takes real this_radians, real len returns real
	set angle_toVec_return_x = Cos(this_radians) * len
	set angle_toVec_return_y = Sin(this_radians) * len
	return angle_toVec_return_x
endfunction

function vec2_op_plus takes real this_x, real this_y, real v_x, real v_y returns real
	set vec2_op_plus_return_x = this_x + v_x
	set vec2_op_plus_return_y = this_y + v_y
	return vec2_op_plus_return_x
endfunction

function vec2_polarOffset takes real this_x, real this_y, real ang_radians, real dist returns real
	set vec2_polarOffset_return_x = vec2_op_plus(this_x, this_y, angle_toVec(ang_radians, dist), angle_toVec_return_y)
	set vec2_polarOffset_return_y = vec2_op_plus_return_y
	return vec2_polarOffset_return_x
endfunction

function init_test takes nothing returns nothing
	local real tuple_temp = vec2_polarOffset(1., 2., 1.5708, 10.)
	local real tuple_temp_1 = vec2_polarOffset_return_y
	if tuple_temp >= 0.99 and tuple_temp <= 1.01 and tuple_temp_1 >= 11.99 and tuple_temp_1 <= 12.01 then
		call testSuccess()
	endif
endfunction

function main takes nothing returns nothing
	call initGlobals()
	call init_test()
endfunction

function config takes nothing returns nothing
endfunction

