// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367
globals
// originframetype ORIGIN_FRAME_GAME_UI=null
// integer bj_MAX_PLAYER_SLOTS=0
// rect bj_mapInitialPlayableArea=null
string array Colors_hexs
integer Colors_decs=0
hashtable ErrorHandling_HT=null
framehandle Framehandle_GAME_UI=null
real GameTimer_currentTime=0.
boolean MagicFunctions_compiletime=false
rect MapBounds_playableMapRect=null
rect MapBounds_boundRect=null
real MapBounds_playableMin_x=0.
real MapBounds_playableMin_y=0.
real MapBounds_playableMax_x=0.
real MapBounds_playableMax_y=0.
real MapBounds_boundMin_x=0.
real MapBounds_boundMin_y=0.
real MapBounds_boundMax_x=0.
real MapBounds_boundMax_y=0.
integer ObjectRecycler_objectLists=0
player Player_localPlayer=null
hashtable Table_ht=null
integer TypeCasting_typecastdata=0
hashtable hashtable_compiletime=null
hashtable hashtable_compiletime_40=null
integer array Table_nextFree
integer Table_firstFree=0
integer Table_maxIndex=0
integer array Table_typeId
integer array SEntry_nextFree
integer SEntry_firstFree=0
integer SEntry_maxIndex=0
integer array Stack_nextFree
integer Stack_firstFree=0
integer Stack_maxIndex=0
integer array Stack_typeId
integer array SEntry_elem
integer array SEntry_prev
integer array Stack_dummy
integer array Stack_top
integer array Stack_size
real vec2_op_plus_return_x=0.
real vec2_op_plus_return_y=0.
real vec2_op_mult_return_x=0.
code ref_function_init_AbilityIds=null
code ref_function_init_Real=null
code ref_function_init_Integer=null
code ref_function_init_Angle=null
code ref_function_init_String=null
code ref_function_init_Vectors=null
code ref_function_init_Destructable=null
code ref_function_init_Player=null
code ref_function_init_Basics=null
code ref_function_init_MagicFunctions=null
code ref_function_init_Table=null
code ref_function_init_Playercolor=null
code ref_function_init_Maths=null
code ref_function_init_Colors=null
code ref_function_init_Printing=null
code ref_function_init_GameTimer=null
code ref_function_init_ErrorHandling=null
code ref_function_init_HashList=null
code ref_function_init_Matrices=null
code ref_function_init_Quaternion=null
code ref_function_init_Framehandle=null
code ref_function_init_Group=null
code ref_function_init_Lightning=null
code ref_function_init_WeatherEffects=null
code ref_function_init_TypeCasting=null
code ref_function_init_EventHelper=null
code ref_function_init_MapBounds=null
code ref_function_init_ObjectRecycler=null
code ref_function_code__startPeriodic_GameTimer=null
endglobals
function Loglevel_getTag takes integer this returns string
	if this == 0 then
		return "|cffADADADtrace|r"
	elseif this == 1 then
		return "|cff2685DCdebug|r"
	elseif this == 2 then
		return "|cffFFCC00info|r"
	elseif this == 3 then
		return "|cffF47E3Ewarning|r"
	else
		return "|cffFB2700error|r"
	endif
endfunction

function printLog takes player showTo, integer loglvl, string msg returns nothing
	if 2 <= loglvl then
		call DisplayTimedTextToPlayer(showTo, 0., 0., 45., Loglevel_getTag(loglvl) + " - " + msg)
	endif
endfunction

function Log_error takes string msg returns nothing
	call printLog(Player_localPlayer, 4, msg)
endfunction

function compileError takes string msg returns nothing
endfunction

function hashtable_hasBoolean takes hashtable this, integer parentKey, integer childKey returns boolean
	return HaveSavedBoolean(this, parentKey, childKey)
endfunction

function hashtable_hasInt takes hashtable this, integer parentKey, integer childKey returns boolean
	return HaveSavedInteger(this, parentKey, childKey)
endfunction

function hashtable_loadBoolean takes hashtable this, integer parentKey, integer childKey returns boolean
	return LoadBoolean(this, parentKey, childKey)
endfunction

function hashtable_loadInt takes hashtable this, integer parentKey, integer childKey returns integer
	return LoadInteger(this, parentKey, childKey)
endfunction

function hashtable_saveBoolean takes hashtable this, integer parentKey, integer childKey, boolean value returns nothing
	call SaveBoolean(this, parentKey, childKey, value)
endfunction

function hashtable_saveInt takes hashtable this, integer parentKey, integer childKey, integer value returns nothing
	call SaveInteger(this, parentKey, childKey, value)
endfunction

function real_toInt takes real this returns integer
	return R2I(this)
endfunction

function string_getHash takes string this returns integer
	return StringHash(this)
endfunction

function error takes string msg returns nothing
	local integer hash
	if MagicFunctions_compiletime then
		call compileError("ERROR: " + msg)
	else
		set hash = string_getHash(msg)
		if hashtable_hasInt(ErrorHandling_HT, -1, hash) then
			if hashtable_loadInt(ErrorHandling_HT, -1, hash) + 60 < GameTimer_currentTime then
				call Log_error(msg + "")
				call hashtable_saveInt(ErrorHandling_HT, -1, hash, real_toInt(GameTimer_currentTime))
				call hashtable_saveBoolean(ErrorHandling_HT, -1, hash, false)
			elseif hashtable_hasBoolean(ErrorHandling_HT, -1, hash) then
				if  not hashtable_loadBoolean(ErrorHandling_HT, -1, hash) then
					call Log_error("|cffFF3A29Excessive repeating errors are being omitted")
					call hashtable_saveBoolean(ErrorHandling_HT, -1, hash, true)
				endif
			else
				call Log_error("|cffFF3A29Excessive repeating errors are being omitted")
				call hashtable_saveBoolean(ErrorHandling_HT, -1, hash, true)
			endif
		else
			call hashtable_saveInt(ErrorHandling_HT, -1, hash, real_toInt(GameTimer_currentTime))
			call Log_error("Message: " + msg + "")
		endif
		call I2S(1 / 0)
	endif
endfunction

function initCompiletimeState_0 takes nothing returns nothing
	call InitHashtable()
	call InitHashtable()
	set hashtable_compiletime_40 = InitHashtable()
	set hashtable_compiletime = InitHashtable()
	call SaveInteger(hashtable_compiletime_40, 1, -242600650, 0)
	call SaveInteger(hashtable_compiletime_40, 1, 1132341824, 1)
	call SaveInteger(hashtable_compiletime_40, 1, -647782241, 2)
	call SaveInteger(hashtable_compiletime_40, 1, -854572045, 3)
	call SaveInteger(hashtable_compiletime_40, 1, -680649701, 4)
	call SaveInteger(hashtable_compiletime_40, 1, -943650483, 5)
	call SaveInteger(hashtable_compiletime_40, 1, -671760605, 6)
	call SaveInteger(hashtable_compiletime_40, 1, 349230650, 7)
	call SaveInteger(hashtable_compiletime_40, 1, -1894922563, 8)
	call SaveInteger(hashtable_compiletime_40, 1, -1474492777, 9)
	call SaveInteger(hashtable_compiletime_40, 1, -1587459251, 10)
	call SaveInteger(hashtable_compiletime_40, 1, -1676716706, 11)
	call SaveInteger(hashtable_compiletime_40, 1, -1559655710, 12)
	call SaveInteger(hashtable_compiletime_40, 1, -1663695754, 13)
	call SaveInteger(hashtable_compiletime_40, 1, 597637742, 14)
	call SaveInteger(hashtable_compiletime_40, 1, 789744696, 15)
	call SaveStr(hashtable_compiletime_40, 2, 0, "")
endfunction

function initCompiletimeState takes nothing returns nothing
	call ExecuteFunc("initCompiletimeState_0")
endfunction

function code__startPeriodic_GameTimer takes nothing returns nothing
	set GameTimer_currentTime = GameTimer_currentTime + 0.030
endfunction

function init_AbilityIds takes nothing returns boolean
	return true
endfunction

function init_Angle takes nothing returns boolean
	return true
endfunction

function init_Basics takes nothing returns boolean
	return true
endfunction

function toHex takes integer number returns string
	local integer firstpart = number / 16
	return Colors_hexs[firstpart] + Colors_hexs[number - firstpart * 16]
endfunction

function colorA_toColorString takes integer this_red, integer this_green, integer this_blue, integer this_alpha returns string
	return "|c" + toHex(this_alpha) + toHex(this_red) + toHex(this_green) + toHex(this_blue)
endfunction

function Table_saveInt takes integer this, integer parentKey, integer value returns nothing
	call hashtable_saveInt(Table_ht, this, parentKey, value)
endfunction

function dispatch_Table_Table_Table_saveInt takes integer this, integer parentKey, integer value returns nothing
	if Table_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Table.saveInt")
		else
			call error("Called Table.saveInt on invalid object.")
		endif
	endif
	call Table_saveInt(this, parentKey, value)
endfunction

function initializeTable takes nothing returns nothing
	local integer i = 0
	loop
		exitwhen i > 15
		call dispatch_Table_Table_Table_saveInt(Colors_decs, string_getHash(Colors_hexs[i]), i)
		set i = i + 1
	endloop
endfunction

function alloc_Table takes nothing returns integer
	local integer this
	if Table_firstFree == 0 then
		if Table_maxIndex < 32768 then
			set Table_maxIndex = Table_maxIndex + 1
			set this = Table_maxIndex
			set Table_typeId[this] = 15
		else
			call error("Out of memory: Could not create Table.")
			set this = 0
		endif
	else
		set Table_firstFree = Table_firstFree - 1
		set this = Table_nextFree[Table_firstFree]
		set Table_typeId[this] = 15
	endif
	return this
endfunction

function Table_init takes integer this returns nothing
endfunction

function construct_Table takes integer this returns nothing
	call Table_init(this)
endfunction

function new_Table takes nothing returns integer
	local integer this = alloc_Table()
	call construct_Table(this)
	return this
endfunction

function init_Colors takes nothing returns boolean
	set Colors_hexs[0] = "0"
	set Colors_hexs[1] = "1"
	set Colors_hexs[2] = "2"
	set Colors_hexs[3] = "3"
	set Colors_hexs[4] = "4"
	set Colors_hexs[5] = "5"
	set Colors_hexs[6] = "6"
	set Colors_hexs[7] = "7"
	set Colors_hexs[8] = "8"
	set Colors_hexs[9] = "9"
	set Colors_hexs[10] = "A"
	set Colors_hexs[11] = "B"
	set Colors_hexs[12] = "C"
	set Colors_hexs[13] = "D"
	set Colors_hexs[14] = "E"
	set Colors_hexs[15] = "F"
	set Colors_decs = new_Table()
	call colorA_toColorString(255, 255, 255, 255)
	call colorA_toColorString(0, 0, 0, 0)
	call colorA_toColorString(255, 204, 0, 255)
	call initializeTable()
	return true
endfunction

function init_Destructable takes nothing returns boolean
	return true
endfunction

function init_ErrorHandling takes nothing returns boolean
	set ErrorHandling_HT = hashtable_compiletime
	return true
endfunction

function alloc_HashMap takes nothing returns integer
	local integer this
	if Table_firstFree == 0 then
		if Table_maxIndex < 32768 then
			set Table_maxIndex = Table_maxIndex + 1
			set this = Table_maxIndex
			set Table_typeId[this] = 16
		else
			call error("Out of memory: Could not create HashMap.")
			set this = 0
		endif
	else
		set Table_firstFree = Table_firstFree - 1
		set this = Table_nextFree[Table_firstFree]
		set Table_typeId[this] = 16
	endif
	return this
endfunction

function HashMap_init takes integer this returns nothing
endfunction

function construct_HashMap takes integer this returns nothing
	call construct_Table(this)
	call HashMap_init(this)
endfunction

function new_HashMap takes nothing returns integer
	local integer this = alloc_HashMap()
	call construct_HashMap(this)
	return this
endfunction

function init_EventHelper takes nothing returns boolean
	call new_HashMap()
	call new_HashMap()
	call new_Table()
	return true
endfunction

function int_toString takes integer this returns string
	return I2S(this)
endfunction

function string_length takes string this returns integer
	return StringLength(this)
endfunction

function verifyFrameNameLength takes string name returns boolean
	if string_length(name) > 560 then
		call error("Trying to address frame with exceeding maximum frame name length (" + int_toString(560) + ") for: " + name)
		return false
	endif
	return true
endfunction

function createFrame takes string typeName, string name, framehandle owner, string inherits, integer createContext returns framehandle
	call verifyFrameNameLength(name)
	return BlzCreateFrameByType(typeName, name, owner, inherits, createContext)
endfunction

function framehandle_setSize takes framehandle this, real width, real height returns nothing
	call BlzFrameSetSize(this, width, height)
endfunction

function init_Framehandle takes nothing returns boolean
	set Framehandle_GAME_UI = BlzGetOriginFrame(ORIGIN_FRAME_GAME_UI, 0)
	call framehandle_setSize(createFrame("FRAME", "SetMousePositionCage", Framehandle_GAME_UI, null, 0), 0.0001, 0.0001)
	return true
endfunction

function timer_start takes timer this, real time, code timerCallBack returns nothing
	call TimerStart(this, time, false, timerCallBack)
endfunction

function timer_startPeriodic takes timer this, real time, code timerCallBack returns nothing
	call TimerStart(this, time, true, timerCallBack)
endfunction

function init_GameTimer takes nothing returns boolean
	call timer_start(CreateTimer(), 100000., null)
	call timer_startPeriodic(CreateTimer(), 0.030, ref_function_code__startPeriodic_GameTimer)
	return true
endfunction

function init_Group takes nothing returns boolean
	call CreateGroup()
	return true
endfunction

function init_HashList takes nothing returns boolean
	return true
endfunction

function init_Integer takes nothing returns boolean
	return true
endfunction

function init_Lightning takes nothing returns boolean
	return true
endfunction

function init_MagicFunctions takes nothing returns boolean
	set MagicFunctions_compiletime = false
	return true
endfunction

function rect_getMaxX takes rect this returns real
	return GetRectMaxX(this)
endfunction

function rect_getMaxY takes rect this returns real
	return GetRectMaxY(this)
endfunction

function rect_getMinX takes rect this returns real
	return GetRectMinX(this)
endfunction

function rect_getMinY takes rect this returns real
	return GetRectMinY(this)
endfunction

function region_addRect takes region this, rect rct returns nothing
	call RegionAddRect(this, rct)
endfunction

function vec2_op_mult takes real this_x, real this_y, real factor returns real
	set vec2_op_mult_return_x = this_x * factor
	return vec2_op_mult_return_x
endfunction

function vec2_op_plus takes real this_x, real this_y, real v_x, real v_y returns real
	set vec2_op_plus_return_x = this_x + v_x
	set vec2_op_plus_return_y = this_y + v_y
	return vec2_op_plus_return_x
endfunction

function initMapBounds takes nothing returns nothing
	local rect cond_result
	local real tuple_temp
	local real tuple_temp_1
	if MagicFunctions_compiletime then
		set cond_result = Rect(-1024., -1024., 1024., 1024.)
	else
		set cond_result = GetPlayableMapRect()
	endif
	set MapBounds_playableMapRect = cond_result
	call region_addRect(CreateRegion(), MapBounds_playableMapRect)
	if MagicFunctions_compiletime then
		set cond_result = Rect(-1536., -1536., 1536., 1536.)
	else
		set cond_result = GetWorldBounds()
	endif
	set MapBounds_boundRect = cond_result
	call region_addRect(CreateRegion(), MapBounds_boundRect)
	set tuple_temp = rect_getMinX(MapBounds_playableMapRect)
	set tuple_temp_1 = rect_getMinY(MapBounds_playableMapRect)
	set MapBounds_playableMin_x = tuple_temp
	set MapBounds_playableMin_y = tuple_temp_1
	set tuple_temp = rect_getMaxX(MapBounds_playableMapRect)
	set tuple_temp_1 = rect_getMaxY(MapBounds_playableMapRect)
	set MapBounds_playableMax_x = tuple_temp
	set MapBounds_playableMax_y = tuple_temp_1
	set tuple_temp = rect_getMinX(MapBounds_boundRect)
	set tuple_temp_1 = rect_getMinY(MapBounds_boundRect)
	set MapBounds_boundMin_x = tuple_temp
	set MapBounds_boundMin_y = tuple_temp_1
	set tuple_temp_1 = rect_getMaxX(MapBounds_boundRect)
	set tuple_temp = rect_getMaxY(MapBounds_boundRect)
	set MapBounds_boundMax_x = tuple_temp_1
	set MapBounds_boundMax_y = tuple_temp
	call vec2_op_mult(vec2_op_plus(MapBounds_playableMin_x, MapBounds_playableMin_y, MapBounds_playableMax_x, MapBounds_playableMax_y), vec2_op_plus_return_y, .5)
	call vec2_op_mult(vec2_op_plus(MapBounds_boundMin_x, MapBounds_boundMin_y, MapBounds_boundMax_x, MapBounds_boundMax_y), vec2_op_plus_return_y, .5)
endfunction

function init_MapBounds takes nothing returns boolean
	call initMapBounds()
	return true
endfunction

function init_Maths takes nothing returns boolean
	return true
endfunction

function init_Matrices takes nothing returns boolean
	return true
endfunction

function angle_degrees takes real this_radians returns real
	return this_radians * 57.295779513
endfunction

function createUnit takes player p, integer unitId, real pos_x, real pos_y, real facing_radians returns unit
	return CreateUnit(p, unitId, pos_x, pos_y, angle_degrees(facing_radians))
endfunction

function Stack_pop takes integer this returns integer
	local integer wval = Stack_top[this]
	set Stack_top[this] = SEntry_prev[Stack_top[this]]
	set Stack_size[this] = Stack_size[this] - 1
	return SEntry_elem[wval]
endfunction

function dispatch_Stack_Stack_Stack_pop takes integer this returns integer
	if Stack_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Stack.pop")
		else
			call error("Called Stack.pop on invalid object.")
		endif
	endif
	return Stack_pop(this)
endfunction

function Table_hasInt takes integer this, integer parentKey returns boolean
	return hashtable_hasInt(Table_ht, this, parentKey)
endfunction

function dispatch_Table_Table_Table_hasInt takes integer this, integer parentKey returns boolean
	if Table_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Table.hasInt")
		else
			call error("Called Table.hasInt on invalid object.")
		endif
	endif
	return Table_hasInt(this, parentKey)
endfunction

function Table_loadInt takes integer this, integer parentKey returns integer
	return hashtable_loadInt(Table_ht, this, parentKey)
endfunction

function dispatch_Table_Table_Table_loadInt takes integer this, integer parentKey returns integer
	if Table_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Table.loadInt")
		else
			call error("Called Table.loadInt on invalid object.")
		endif
	endif
	return Table_loadInt(this, parentKey)
endfunction

function alloc_Stack takes nothing returns integer
	local integer this
	if Stack_firstFree == 0 then
		if Stack_maxIndex < 32768 then
			set Stack_maxIndex = Stack_maxIndex + 1
			set this = Stack_maxIndex
			set Stack_typeId[this] = 12
		else
			call error("Out of memory: Could not create Stack.")
			set this = 0
		endif
	else
		set Stack_firstFree = Stack_firstFree - 1
		set this = Stack_nextFree[Stack_firstFree]
		set Stack_typeId[this] = 12
	endif
	return this
endfunction

function Stack_init takes integer this returns nothing
	set Stack_size[this] = 0
endfunction

function alloc_SEntry takes nothing returns integer
	local integer this
	if SEntry_firstFree == 0 then
		if SEntry_maxIndex < 32768 then
			set SEntry_maxIndex = SEntry_maxIndex + 1
			set this = SEntry_maxIndex
		else
			call error("Out of memory: Could not create SEntry.")
			set this = 0
		endif
	else
		set SEntry_firstFree = SEntry_firstFree - 1
		set this = SEntry_nextFree[SEntry_firstFree]
	endif
	return this
endfunction

function SEntry_init takes integer this returns nothing
endfunction

function construct_SEntry takes integer this, integer elem, integer prev returns nothing
	call SEntry_init(this)
	set SEntry_elem[this] = elem
	set SEntry_prev[this] = prev
endfunction

function new_SEntry takes integer elem, integer prev returns integer
	local integer this = alloc_SEntry()
	call construct_SEntry(this, elem, prev)
	return this
endfunction

function construct_Stack takes integer this returns nothing
	call Stack_init(this)
	set Stack_dummy[this] = new_SEntry(0, 0)
	set Stack_top[this] = Stack_dummy[this]
endfunction

function new_Stack takes nothing returns integer
	local integer this = alloc_Stack()
	call construct_Stack(this)
	return this
endfunction

function hashtable_loadUnitHandle takes hashtable this, integer parentKey, integer childKey returns unit
	return LoadUnitHandle(this, parentKey, childKey)
endfunction

function Table_loadUnit takes integer this, integer parentKey returns unit
	return hashtable_loadUnitHandle(Table_ht, this, parentKey)
endfunction

function dispatch_Table_Table_Table_loadUnit takes integer this, integer parentKey returns unit
	if Table_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Table.loadUnit")
		else
			call error("Called Table.loadUnit on invalid object.")
		endif
	endif
	return Table_loadUnit(this, parentKey)
endfunction

function hashtable_saveFogStateHandle takes hashtable this, integer parentKey, integer childKey, fogstate value returns nothing
	call SaveFogStateHandle(this, parentKey, childKey, value)
endfunction

function Table_saveFogState takes integer this, integer parentKey, fogstate value returns nothing
	call hashtable_saveFogStateHandle(Table_ht, this, parentKey, value)
endfunction

function dispatch_Table_Table_Table_saveFogState takes integer this, integer parentKey, fogstate value returns nothing
	if Table_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Table.saveFogState")
		else
			call error("Called Table.saveFogState on invalid object.")
		endif
	endif
	call Table_saveFogState(this, parentKey, value)
endfunction

function unitFromIndex takes integer index returns unit
	call dispatch_Table_Table_Table_saveFogState(TypeCasting_typecastdata, 0, ConvertFogState(index))
	return dispatch_Table_Table_Table_loadUnit(TypeCasting_typecastdata, 0)
endfunction

function unit_setFacing takes unit this, real a_radians returns nothing
	call SetUnitFacing(this, angle_degrees(a_radians))
endfunction

function unit_show takes unit this returns nothing
	call ShowUnit(this, true)
endfunction

function getUnit takes player p, integer id, real pos_x, real pos_y, real facing_radians returns unit
	local unit receiver
	if dispatch_Table_Table_Table_hasInt(ObjectRecycler_objectLists, id) then
		set receiver = unitFromIndex(dispatch_Stack_Stack_Stack_pop(dispatch_Table_Table_Table_loadInt(ObjectRecycler_objectLists, id)))
		call unit_setFacing(receiver, facing_radians)
		call unit_show(receiver)
		return receiver
	else
		call dispatch_Table_Table_Table_saveInt(ObjectRecycler_objectLists, id, new_Stack())
		return createUnit(p, id, pos_x, pos_y, facing_radians)
	endif
endfunction

function Stack_push takes integer this, integer elem returns nothing
	set Stack_top[this] = new_SEntry(elem, Stack_top[this])
	set Stack_size[this] = Stack_size[this] + 1
endfunction

function dispatch_Stack_Stack_Stack_push takes integer this, integer elem returns nothing
	if Stack_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Stack.push")
		else
			call error("Called Stack.push on invalid object.")
		endif
	endif
	call Stack_push(this, elem)
endfunction

function handle_getHandleId takes handle this returns integer
	return GetHandleId(this)
endfunction

function unitToIndex takes unit object returns integer
	return handle_getHandleId(object)
endfunction

function unit_hide takes unit this returns nothing
	call ShowUnit(this, false)
endfunction

function unit_setPos takes unit this, real x, real y returns nothing
	call SetUnitPosition(this, x, y)
endfunction

function unit_recycle takes unit this returns nothing
	local integer id = GetUnitTypeId(this)
	if dispatch_Table_Table_Table_hasInt(ObjectRecycler_objectLists, id) then
		call dispatch_Stack_Stack_Stack_push(dispatch_Table_Table_Table_loadInt(ObjectRecycler_objectLists, id), unitToIndex(this))
		call unit_hide(this)
		call unit_setPos(this, 1., 2.)
	else
		call error("trying to recycle a unit not created by 'getUnit'!")
	endif
endfunction

function init_ObjectRecycler takes nothing returns boolean
	set ObjectRecycler_objectLists = new_Table()
	call unit_recycle(getUnit(Player(0), 0, 0., 0., 0.))
	return true
endfunction

function initPlayerArray takes nothing returns nothing
	local integer i = 0
	local integer temp = bj_MAX_PLAYER_SLOTS - 1
	loop
		exitwhen i > temp
		set i = i + 1
	endloop
endfunction

function init_Player takes nothing returns boolean
	set Player_localPlayer = GetLocalPlayer()
	call initPlayerArray()
	return true
endfunction

function init_Playercolor takes nothing returns boolean
	return true
endfunction

function init_Printing takes nothing returns boolean
	return true
endfunction

function init_Quaternion takes nothing returns boolean
	return true
endfunction

function init_Real takes nothing returns boolean
	return true
endfunction

function init_String takes nothing returns boolean
	call string_length("0123456789")
	call string_length("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
	return true
endfunction

function init_Table takes nothing returns boolean
	set Table_ht = hashtable_compiletime_40
	return true
endfunction

function hashtable_saveString takes hashtable this, integer parentKey, integer childKey, string value returns nothing
	call SaveStr(this, parentKey, childKey, value)
endfunction

function Table_saveString takes integer this, integer parentKey, string value returns nothing
	call hashtable_saveString(Table_ht, this, parentKey, value)
endfunction

function dispatch_Table_Table_Table_saveString takes integer this, integer parentKey, string value returns nothing
	if Table_typeId[this] == 0 then
		if this == 0 then
			call error("Nullpointer exception when calling Table.saveString")
		else
			call error("Called Table.saveString on invalid object.")
		endif
	endif
	call Table_saveString(this, parentKey, value)
endfunction

function initTypecastData takes nothing returns nothing
	call dispatch_Table_Table_Table_saveString(TypeCasting_typecastdata, 0, "")
endfunction

function init_TypeCasting takes nothing returns boolean
	set TypeCasting_typecastdata = new_Table()
	call initTypecastData()
	return true
endfunction

function init_Vectors takes nothing returns boolean
	call Location(0., 0.)
	return true
endfunction

function init_WeatherEffects takes nothing returns boolean
	return true
endfunction

function initGlobals takes nothing returns nothing
	set ref_function_init_AbilityIds = function init_AbilityIds
	set ref_function_init_Real = function init_Real
	set ref_function_init_Integer = function init_Integer
	set ref_function_init_Angle = function init_Angle
	set ref_function_init_String = function init_String
	set ref_function_init_Vectors = function init_Vectors
	set ref_function_init_Destructable = function init_Destructable
	set ref_function_init_Player = function init_Player
	set ref_function_init_Basics = function init_Basics
	set ref_function_init_MagicFunctions = function init_MagicFunctions
	set ref_function_init_Table = function init_Table
	set ref_function_init_Playercolor = function init_Playercolor
	set ref_function_init_Maths = function init_Maths
	set ref_function_init_Colors = function init_Colors
	set ref_function_init_Printing = function init_Printing
	set ref_function_init_GameTimer = function init_GameTimer
	set ref_function_init_ErrorHandling = function init_ErrorHandling
	set ref_function_init_HashList = function init_HashList
	set ref_function_init_Matrices = function init_Matrices
	set ref_function_init_Quaternion = function init_Quaternion
	set ref_function_init_Framehandle = function init_Framehandle
	set ref_function_init_Group = function init_Group
	set ref_function_init_Lightning = function init_Lightning
	set ref_function_init_WeatherEffects = function init_WeatherEffects
	set ref_function_init_TypeCasting = function init_TypeCasting
	set ref_function_init_EventHelper = function init_EventHelper
	set ref_function_init_MapBounds = function init_MapBounds
	set ref_function_init_ObjectRecycler = function init_ObjectRecycler
	set ref_function_code__startPeriodic_GameTimer = function code__startPeriodic_GameTimer
endfunction

function main takes nothing returns nothing
	local trigger initTrig
	call initGlobals()
	call initCompiletimeState()
	set initTrig = CreateTrigger()
	call TriggerAddCondition(initTrig, Condition(ref_function_init_AbilityIds))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package AbilityIds.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Real))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Real.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Integer))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Integer.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Angle))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Angle.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_String))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package String.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Vectors))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Vectors.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Destructable))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Destructable.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Player))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Player.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Basics))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Basics.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_MagicFunctions))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package MagicFunctions.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Table))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Table.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Playercolor))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Playercolor.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Maths))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Maths.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Colors))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Colors.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Printing))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Printing.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_GameTimer))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package GameTimer.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_ErrorHandling))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package ErrorHandling.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_HashList))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package HashList.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Matrices))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Matrices.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Quaternion))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Quaternion.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Framehandle))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Framehandle.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Group))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Group.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_Lightning))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package Lightning.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_WeatherEffects))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package WeatherEffects.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_TypeCasting))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package TypeCasting.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_EventHelper))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package EventHelper.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_MapBounds))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package MapBounds.")
	endif
	call TriggerClearConditions(initTrig)
	call TriggerAddCondition(initTrig, Condition(ref_function_init_ObjectRecycler))
	if  not TriggerEvaluate(initTrig) then
		call error("Could not initialize package ObjectRecycler.")
	endif
	call TriggerClearConditions(initTrig)
	call DestroyTrigger(initTrig)
endfunction

function config takes nothing returns nothing
endfunction

